/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.base;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.reactors.IHeatReactor;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blockentity.mechanism.multiblocks.base.BlockEntityMultiBlockBase;
import com.denfop.blockentity.reactors.heat.IGraphiteController;
import com.denfop.blockentity.reactors.heat.graphite_controller.BlockEntityGraphiteController;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuWirelessControllerHeatReactors;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.datacomponent.ReactorData;
import com.denfop.inventory.Inventory;
import com.denfop.items.ItemReactorData;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenWirelessControllerHeatReactors;
import com.denfop.utils.Keyboard;
import com.denfop.utils.Localization;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BlockEntityWirelessHeatController
extends BlockEntityInventory
implements IUpdatableTileEvent {
    public final Inventory invslot;
    public List<ItemStack> itemStacks = new LinkedList<ItemStack>();
    public List<BlockEntityGraphiteController> graphiteControllers = new LinkedList<BlockEntityGraphiteController>();
    public BlockEntityMultiBlockBase tileMultiBlockBase = null;

    public BlockEntityWirelessHeatController(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3Entity.wireless_controller_heat_reactors, pos, state);
        this.invslot = new Inventory(this, Inventory.TypeItemSlot.INPUT, 1){

            @Override
            public ItemStack set(int index, ItemStack content) {
                super.set(index, content);
                BlockEntityWirelessHeatController.this.updateList();
                return content;
            }

            @Override
            public boolean canPlaceItem(int index, ItemStack stack) {
                if (!(stack.getItem() instanceof ItemReactorData)) {
                    return false;
                }
                return stack.has(DataComponentsInit.REACTOR_DATA);
            }
        };
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    public ContainerMenuWirelessControllerHeatReactors getGuiContainer(Player var1) {
        return new ContainerMenuWirelessControllerHeatReactors(this, var1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenWirelessControllerHeatReactors((ContainerMenuWirelessControllerHeatReactors)menu);
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachine3Entity.wireless_controller_heat_reactors;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown(340)) {
            // empty if block
        }
        super.addInformation(stack, tooltip);
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packetBuffer = super.writeContainerPacket();
        this.updateList();
        try {
            EncoderHandler.encode(packetBuffer, this.invslot.get(0));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packetBuffer;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.invslot.set(0, (ItemStack)DecoderHandler.decode(customPacketBuffer));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
    }

    @Override
    public void loadBeforeFirstUpdate() {
        super.loadBeforeFirstUpdate();
        if (!this.getWorld().isClientSide) {
            this.updateList();
        }
    }

    public void updateList() {
        this.itemStacks.clear();
        this.graphiteControllers.clear();
        this.itemStacks.clear();
        this.tileMultiBlockBase = null;
        if (this.invslot.get(0).isEmpty()) {
            return;
        }
        ReactorData reactorData = (ReactorData)this.invslot.get(0).get(DataComponentsInit.REACTOR_DATA);
        BlockPos pos = reactorData.pos();
        BlockEntity tileEntity = this.getWorld().getBlockEntity(pos);
        if (tileEntity instanceof BlockEntityMultiBlockBase && tileEntity instanceof IHeatReactor) {
            this.tileMultiBlockBase = (BlockEntityMultiBlockBase)tileEntity;
            if (this.tileMultiBlockBase.isFull()) {
                List<BlockPos> pos1 = this.tileMultiBlockBase.getMultiBlockStucture().getPosFromClass(this.tileMultiBlockBase.getFacing(), this.tileMultiBlockBase.getBlockPos(), IGraphiteController.class);
                for (BlockPos pos2 : pos1) {
                    BlockEntity tileEntity1 = this.getWorld().getBlockEntity(pos2);
                    if (tileEntity1 == null) continue;
                    this.graphiteControllers.add((BlockEntityGraphiteController)tileEntity1);
                    this.itemStacks.add(((BlockEntityGraphiteController)tileEntity1).getPickBlock(null, null));
                }
            }
        } else {
            this.itemStacks.add(ItemStack.EMPTY);
        }
    }

    @Override
    public void updateTileServer(Player var1, double var2) {
        if (!this.invslot.get(0).isEmpty() && this.tileMultiBlockBase != null) {
            BlockEntityGraphiteController controller;
            if ((double)this.graphiteControllers.size() < var2) {
                this.graphiteControllers.clear();
                if (this.tileMultiBlockBase.isFull()) {
                    List<BlockPos> pos1 = this.tileMultiBlockBase.getMultiBlockStucture().getPosFromClass(this.tileMultiBlockBase.getFacing(), this.tileMultiBlockBase.getBlockPos(), IGraphiteController.class);
                    for (BlockPos pos2 : pos1) {
                        BlockEntity tileEntity1 = this.getWorld().getBlockEntity(pos2);
                        if (tileEntity1 == null) continue;
                        this.graphiteControllers.add((BlockEntityGraphiteController)tileEntity1);
                    }
                }
            }
            if ((controller = this.graphiteControllers.get((int)var2)) != null && controller.getMain() != null && controller.getMain().isFull() && !controller.isRemoved()) {
                controller.onActivated(var1, var1.getUsedItemHand(), Direction.NORTH, new Vec3(0.0, 0.0, 0.0));
            }
        }
    }
}

