/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.base;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.primitive.EnumPrimitive;
import com.denfop.api.primitive.PrimitiveHandler;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.InventoryOutput;
import com.denfop.api.recipe.InventoryRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.sound.AudioFixer;
import com.denfop.api.sound.EnumTypeAudio;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blocks.BlockStrongAnvilEntity;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.inventory.Inventory;
import com.denfop.items.resource.ItemRawMetals;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.recipe.IInputHandler;
import com.denfop.sound.EnumSound;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import com.denfop.world.WorldBaseGen;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class BlockEntityStrongAnvil
extends BlockEntityInventory
implements IUpdateTick,
IHasRecipe,
AudioFixer {
    private static final List<AABB> aabbs = Collections.singletonList(new AABB(0.0, 0.0, -1.0, 1.0, 1.0, 2.0));
    private static final List<AABB> aabbs1 = Collections.singletonList(new AABB(-1.0, 0.0, 0.0, 2.0, 1.0, 1.0));
    public final InventoryRecipes inputSlotA;
    public final InventoryOutput outputSlot;
    public int progress = 0;
    public MachineRecipe output;
    public Map<UUID, Double> data;
    ItemStack prevInput = ItemStack.EMPTY;
    ItemStack prevOutput = ItemStack.EMPTY;

    public BlockEntityStrongAnvil(BlockPos pos, BlockState state) {
        super(BlockStrongAnvilEntity.block_strong_anvil, pos, state);
        this.inputSlotA = new InventoryRecipes(this, this, "strong_anvil", this){

            @Override
            public boolean canPlaceItem(int index, ItemStack itemStack) {
                return super.canPlaceItem(0, itemStack);
            }
        };
        this.outputSlot = new InventoryOutput(this, 1);
        Recipes.recipes.addInitRecipes(this);
    }

    public static void addanvil(String input, String output) {
        ItemStack stack = Recipes.inputFactory.getInput(output).getInputs().get(0).copy();
        stack.setCount(2);
        IInputHandler input1 = Recipes.inputFactory;
        Recipes.recipes.addRecipe("strong_anvil", new BaseMachineRecipe(new Input(input1.getInput(input, 1)), new RecipeOutput(null, stack)));
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.prevInput.isEmpty() && !this.inputSlotA.isEmpty()) {
            this.prevInput = this.inputSlotA.get(0);
            new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
        }
        if (!this.prevInput.isEmpty() && !this.inputSlotA.isEmpty() && this.prevInput.getCount() != this.inputSlotA.get(0).getCount()) {
            this.prevInput = this.inputSlotA.get(0);
            new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
        }
        if (!this.prevInput.isEmpty() && this.inputSlotA.isEmpty()) {
            this.prevInput = ItemStack.EMPTY;
            new PacketUpdateFieldTile(this, "slot3", false);
        }
        if (this.prevOutput.isEmpty() && !this.outputSlot.isEmpty()) {
            this.prevOutput = this.outputSlot.get(0);
            new PacketUpdateFieldTile(this, "slot1", this.outputSlot);
        }
        if (this.prevOutput.isEmpty() && !this.outputSlot.isEmpty() && this.prevOutput.getCount() != this.outputSlot.get(0).getCount()) {
            this.prevOutput = this.outputSlot.get(0);
            new PacketUpdateFieldTile(this, "slot1", this.outputSlot);
        }
        if (!this.prevOutput.isEmpty() && this.outputSlot.isEmpty()) {
            this.prevOutput = ItemStack.EMPTY;
            new PacketUpdateFieldTile(this, "slot2", false);
        }
    }

    @Override
    public List<AABB> getAabbs(boolean forCollision) {
        if (this.facing != 4 && this.facing != 5) {
            return aabbs1;
        }
        return aabbs;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        tooltip.add(Localization.translate("primitive_rcm.info"));
        tooltip.add(Localization.translate("primitive_use.info") + IUItem.ObsidianForgeHammer.getItem().getDescription().getString());
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.strong_anvil.getBlock();
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockStrongAnvilEntity.block_strong_anvil;
    }

    @Override
    public List<ItemStack> getSelfDrops(int fortune, boolean wrench) {
        List<ItemStack> drop = super.getSelfDrops(fortune, wrench);
        return drop;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.data = PrimitiveHandler.getPlayersData(EnumPrimitive.STRONG_ANVIL);
        if (!this.getWorld().isClientSide) {
            new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
            new PacketUpdateFieldTile(this, "slot1", this.outputSlot);
        }
        this.output = this.inputSlotA.process();
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
        if (name.equals("slot")) {
            try {
                this.inputSlotA.readFromNbt((HolderLookup.Provider)is.registryAccess(), ((Inventory)DecoderHandler.decode(is)).writeToNbt((HolderLookup.Provider)is.registryAccess(), new CompoundTag()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("slot1")) {
            try {
                this.outputSlot.readFromNbt((HolderLookup.Provider)is.registryAccess(), ((Inventory)DecoderHandler.decode(is)).writeToNbt((HolderLookup.Provider)is.registryAccess(), new CompoundTag()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("slot3")) {
            this.inputSlotA.set(0, ItemStack.EMPTY);
        }
        if (name.equals("slot2")) {
            this.outputSlot.set(0, ItemStack.EMPTY);
        }
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.inputSlotA.readFromNbt((HolderLookup.Provider)customPacketBuffer.registryAccess(), ((Inventory)DecoderHandler.decode(customPacketBuffer)).writeToNbt((HolderLookup.Provider)customPacketBuffer.registryAccess(), new CompoundTag()));
            this.outputSlot.readFromNbt((HolderLookup.Provider)customPacketBuffer.registryAccess(), ((Inventory)DecoderHandler.decode(customPacketBuffer)).writeToNbt((HolderLookup.Provider)customPacketBuffer.registryAccess(), new CompoundTag()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer customPacketBuffer = super.writePacket();
        try {
            EncoderHandler.encode(customPacketBuffer, this.inputSlotA);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            EncoderHandler.encode(customPacketBuffer, this.outputSlot);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return customPacketBuffer;
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        ItemStack stack = player.getItemInHand(hand);
        if (stack.getItem() == IUItem.ObsidianForgeHammer.getItem() && this.output != null && this.outputSlot.canAdd(this.output.getRecipe().output.items.get(0))) {
            this.progress += 20;
            this.getCooldownTracker().setTick(10);
            if (!this.getWorld().isClientSide) {
                this.initiate(0);
            }
            this.progress += (int)(this.data.getOrDefault(player.getUUID(), 0.0) / 2.5);
            if (this.progress >= 100) {
                this.progress = 0;
                player.setItemInHand(hand, stack.getItem().getCraftingRemainingItem(stack));
                if (!this.getWorld().isClientSide) {
                    PrimitiveHandler.addExperience(EnumPrimitive.STRONG_ANVIL, 0.5, player.getUUID());
                }
                ItemStack stack1 = this.output.getRecipe().output.items.get(0).copy();
                double chance = WorldBaseGen.random.nextDouble();
                if (chance < 0.65) {
                    stack1.setCount(1);
                } else if (chance < 0.9750000000000001) {
                    stack1.setCount(2);
                } else {
                    stack1.setCount(3);
                }
                this.outputSlot.add(stack1);
                this.inputSlotA.consume(0, this.output.getRecipe().input.getInputs().get(0).getAmount());
                if (this.inputSlotA.isEmpty() || this.outputSlot.get(0).getCount() >= 64) {
                    this.output = null;
                }
                if (!this.level.isClientSide) {
                    new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
                    new PacketUpdateFieldTile(this, "slot1", this.outputSlot);
                }
            }
            return this.getWorld().isClientSide;
        }
        if (!stack.isEmpty()) {
            if (this.inputSlotA.get(0).isEmpty() && this.inputSlotA.canPlaceItem(4, stack)) {
                this.inputSlotA.set(0, stack.copy());
                stack.setCount(0);
                if (!this.level.isClientSide) {
                    new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
                }
                return true;
            }
            if (!this.inputSlotA.get(0).isEmpty() && this.inputSlotA.get(0).is(stack.getItem())) {
                int minCount = 64 - this.inputSlotA.get(0).getCount();
                minCount = Math.min(stack.getCount(), minCount);
                this.inputSlotA.get(0).grow(minCount);
                stack.grow(-minCount);
                if (!this.level.isClientSide) {
                    new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
                }
                return true;
            }
        } else {
            if (!this.outputSlot.isEmpty()) {
                if (!this.level.isClientSide) {
                    ModUtils.dropAsEntity(this.level, this.pos, this.outputSlot.get(0));
                }
                this.outputSlot.set(0, ItemStack.EMPTY);
                if (!this.level.isClientSide) {
                    new PacketUpdateFieldTile(this, "slot2", false);
                }
                return true;
            }
            if (!this.inputSlotA.isEmpty()) {
                if (!this.level.isClientSide) {
                    ModUtils.dropAsEntity(this.level, this.pos, this.inputSlotA.get(0));
                }
                this.inputSlotA.set(0, ItemStack.EMPTY);
                this.output = null;
                if (!this.level.isClientSide) {
                    new PacketUpdateFieldTile(this, "slot3", false);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
    }

    @Override
    public void init() {
        for (int i = 0; i < ItemRawMetals.Types.values().length; ++i) {
            Object s = ItemRawMetals.Types.values()[i].getName();
            switch (i) {
                case 3: {
                    s = "tungsten";
                    break;
                }
                case 2: {
                    s = "vanadium";
                }
            }
            if (((String)s).equals("uranium")) continue;
            s = ((String)s).substring(0, 1).toUpperCase() + ((String)s).substring(1);
            BlockEntityStrongAnvil.addanvil("c:raw_materials/" + (String)s, "c:crushed/" + (String)s);
        }
        String s = "iron";
        BlockEntityStrongAnvil.addanvil("c:raw_materials/" + s, "c:crushed/" + s);
        s = "gold";
        BlockEntityStrongAnvil.addanvil("c:raw_materials/" + s, "c:crushed/" + s);
        s = "copper";
        BlockEntityStrongAnvil.addanvil("c:raw_materials/" + s, "c:crushed/" + s);
    }

    @Override
    public EnumTypeAudio getTypeAudio() {
        return EnumTypeAudio.ON;
    }

    @Override
    public void setType(EnumTypeAudio type) {
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.molot.getSoundEvent();
    }

    @Override
    public void initiate(int soundEvent) {
        if (soundEvent == 0) {
            this.getWorld().playSound(null, this.pos, this.getSound(), SoundSource.BLOCKS, 0.2f, 1.0f);
        }
    }

    @Override
    public boolean getEnable() {
        return true;
    }
}

