/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.base;

import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.recipe.InventoryOutput;
import com.denfop.api.sound.AudioFixer;
import com.denfop.api.sound.EnumTypeAudio;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.componets.Energy;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.PacketStopSound;
import com.denfop.sound.EnumSound;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.block.state.BlockState;

public abstract class BlockEntityStandartMachine
extends BlockEntityInventory
implements AudioFixer,
IUpdatableTileEvent {
    public InventoryOutput outputSlot = null;
    public Energy energy;
    public EnumTypeAudio typeAudio = EnumTypeAudio.OFF;
    public EnumTypeAudio[] valuesAudio = EnumTypeAudio.values();

    public BlockEntityStandartMachine(int count, MultiBlockEntity block, BlockPos pos, BlockState state) {
        super(block, pos, state);
        if (count != 0) {
            this.outputSlot = new InventoryOutput(this, count);
        }
    }

    @Override
    public EnumTypeAudio getTypeAudio() {
        return this.typeAudio;
    }

    @Override
    public void setType(EnumTypeAudio type) {
        this.typeAudio = type;
    }

    @Override
    public void initiate(int soundEvent) {
        if (this.getTypeAudio() == this.valuesAudio[soundEvent % this.valuesAudio.length]) {
            return;
        }
        this.setType(this.valuesAudio[soundEvent % this.valuesAudio.length]);
        if (this.getSound() == null) {
            return;
        }
        if (!this.getEnable()) {
            return;
        }
        if (soundEvent == 0) {
            this.getWorld().playSound(null, this.getBlockPos(), this.getSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
        } else if (soundEvent == 1) {
            new PacketStopSound(this.getWorld(), this.getBlockPos());
            this.getWorld().playSound(null, this.getBlockPos(), EnumSound.InterruptOne.getSoundEvent(), SoundSource.BLOCKS, 1.0f, 1.0f);
        } else {
            new PacketStopSound(this.getWorld(), this.getBlockPos());
        }
    }

    @Override
    public SoundEvent getSound() {
        return null;
    }

    public float getChargeLevel() {
        return (float)Math.min(1.0, this.energy.getEnergy() / this.energy.getCapacity());
    }
}

