/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.base;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.reactors.CreativeReactor;
import com.denfop.api.reactors.EnumReactors;
import com.denfop.api.reactors.EnumTypeComponent;
import com.denfop.api.reactors.EnumTypeSecurity;
import com.denfop.api.reactors.IReactorItem;
import com.denfop.api.reactors.ITypeRector;
import com.denfop.api.reactors.LogicCreativeFluidReactor;
import com.denfop.api.reactors.LogicCreativeGasReactor;
import com.denfop.api.reactors.LogicCreativeGraphiteReactor;
import com.denfop.api.reactors.LogicCreativeHeatReactor;
import com.denfop.api.reactors.LogicCreativeReactor;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.ISubEnum;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuSimulationReactors;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.datacomponent.ReactorSchedule;
import com.denfop.inventory.Inventory;
import com.denfop.inventory.InventorySimulatorReactor;
import com.denfop.items.ItemCraftingElements;
import com.denfop.items.reactors.ItemComponentVent;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenSimulationReactors;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BlockEntitySimulatorReactor
extends BlockEntityInventory
implements IUpdatableTileEvent {
    public final InventorySimulatorReactor invSlot = new InventorySimulatorReactor(this, Inventory.TypeItemSlot.INPUT, 80){

        @Override
        public boolean canPlaceItem(int index, ItemStack stack) {
            if (BlockEntitySimulatorReactor.this.reactors == null) {
                return false;
            }
            switch (BlockEntitySimulatorReactor.this.reactors.getType()) {
                case FLUID: 
                case HIGH_SOLID: {
                    if (stack.getItem() instanceof IReactorItem) {
                        IReactorItem iReactorItem = (IReactorItem)stack.getItem();
                        return BlockEntitySimulatorReactor.this.levelReactor >= iReactorItem.getLevel();
                    }
                    return false;
                }
                case GAS_COOLING_FAST: {
                    if (stack.getItem() instanceof IReactorItem) {
                        IReactorItem iReactorItem = (IReactorItem)stack.getItem();
                        return BlockEntitySimulatorReactor.this.levelReactor >= iReactorItem.getLevel() && (iReactorItem.getType() != EnumTypeComponent.HEAT_SINK || stack.getItem() instanceof ItemComponentVent);
                    }
                    return false;
                }
                case GRAPHITE_FLUID: {
                    if (stack.getItem() instanceof IReactorItem) {
                        IReactorItem iReactorItem = (IReactorItem)stack.getItem();
                        return BlockEntitySimulatorReactor.this.levelReactor >= iReactorItem.getLevel() && iReactorItem.getType() != EnumTypeComponent.HEAT_EXCHANGER;
                    }
                    return false;
                }
            }
            return false;
        }

        @Override
        public ItemStack set(int index, ItemStack content) {
            super.set(index, content);
            BlockEntitySimulatorReactor.this.needUpdate = true;
            switch (BlockEntitySimulatorReactor.this.reactors.getType()) {
                case FLUID: {
                    BlockEntitySimulatorReactor.this.logicReactor = new LogicCreativeFluidReactor(BlockEntitySimulatorReactor.this.reactor);
                    break;
                }
                case GAS_COOLING_FAST: {
                    BlockEntitySimulatorReactor.this.logicReactor = new LogicCreativeGasReactor(BlockEntitySimulatorReactor.this.reactor);
                    break;
                }
                case GRAPHITE_FLUID: {
                    BlockEntitySimulatorReactor.this.logicReactor = new LogicCreativeGraphiteReactor(BlockEntitySimulatorReactor.this.reactor);
                    break;
                }
                case HIGH_SOLID: {
                    BlockEntitySimulatorReactor.this.logicReactor = new LogicCreativeHeatReactor(BlockEntitySimulatorReactor.this.reactor);
                }
            }
            return content;
        }
    };
    public final Inventory scheduleSlot;
    public int type = -1;
    public int levelReactor = -1;
    public EnumReactors reactors;
    public CreativeReactor reactor = new CreativeReactor(this.reactors, this.invSlot);
    public boolean work;
    public boolean explode;
    public LogicCreativeReactor logicReactor;
    public double output;
    public double rad;
    public double heat;
    public EnumTypeSecurity security;
    private boolean needUpdate = false;

    public BlockEntitySimulatorReactor(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3Entity.simulation_reactors, pos, state);
        this.scheduleSlot = new Inventory(this, this, Inventory.TypeItemSlot.INPUT, 1){

            @Override
            public boolean canPlaceItem(int index, ItemStack stack) {
                return stack.getItem() instanceof ItemCraftingElements && ((ISubEnum)((ItemCraftingElements)stack.getItem()).getElement()).getId() == 143;
            }

            @Override
            public int getStackSizeLimit() {
                return 1;
            }
        };
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.work = customPacketBuffer.readBoolean();
        this.explode = customPacketBuffer.readBoolean();
        this.rad = customPacketBuffer.readDouble();
        this.output = customPacketBuffer.readDouble();
        this.heat = customPacketBuffer.readDouble();
        this.security = EnumTypeSecurity.values()[customPacketBuffer.readInt()];
        this.type = customPacketBuffer.readInt();
        this.levelReactor = customPacketBuffer.readInt();
        try {
            this.reactor.timer.readBuffer(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        this.type = customPacketBuffer.readInt();
        this.levelReactor = customPacketBuffer.readInt();
        if (this.levelReactor != -1 && this.type != -1) {
            this.reactors = EnumReactors.values()[(this.type - 1) * 4 + (this.levelReactor - 1)];
            this.reactor.level = this.levelReactor;
            this.invSlot.clear();
            this.reactor.reset(this.reactors);
            this.size_inventory = 0;
            for (Inventory inventory : this.inventories) {
                this.size_inventory += inventory.size();
            }
        }
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer customPacketBuffer = super.writePacket();
        customPacketBuffer.writeInt(this.type);
        customPacketBuffer.writeInt(this.levelReactor);
        return customPacketBuffer;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachine3Entity.simulation_reactors;
    }

    public ContainerMenuSimulationReactors getGuiContainer(Player var1) {
        return new ContainerMenuSimulationReactors(this, var1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenSimulationReactors((ContainerMenuSimulationReactors)menu);
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        CompoundTag nbtTagCompound = super.writeToNBT(nbt);
        nbtTagCompound.putInt("type", this.type);
        nbtTagCompound.putInt("level", this.levelReactor);
        nbtTagCompound.putBoolean("work", this.work);
        nbtTagCompound.putBoolean("explode", this.explode);
        if (this.reactors != null) {
            nbtTagCompound.putInt("reactors", this.reactors.ordinal());
        }
        return nbtTagCompound;
    }

    @Override
    public void readFromNBT(CompoundTag nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        this.type = nbtTagCompound.getInt("type");
        this.levelReactor = nbtTagCompound.getInt("level");
        this.reactors = EnumReactors.values()[nbtTagCompound.getInt("reactors")];
        this.work = nbtTagCompound.getBoolean("work");
        this.explode = nbtTagCompound.getBoolean("explode");
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeBoolean(this.work);
        customPacketBuffer.writeBoolean(this.explode);
        customPacketBuffer.writeDouble(this.rad);
        customPacketBuffer.writeDouble(this.output);
        customPacketBuffer.writeDouble(this.heat);
        customPacketBuffer.writeInt(this.security.ordinal());
        customPacketBuffer.writeInt(this.type);
        customPacketBuffer.writeInt(this.levelReactor);
        this.reactor.timer.writeBuffer(customPacketBuffer);
        return customPacketBuffer;
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
    }

    @Override
    public void loadBeforeFirstUpdate() {
        super.loadBeforeFirstUpdate();
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.needUpdate && this.level.getGameTime() % 20L == 0L && this.reactors != null && !this.scheduleSlot.isEmpty()) {
            this.needUpdate = false;
            ItemStack stack = this.scheduleSlot.get(0);
            List<ItemStack> infoStack = this.logicReactor.getInfoStack();
            ArrayList<ItemStack> stacksItem = new ArrayList<ItemStack>();
            ArrayList<Integer> indexItem = new ArrayList<Integer>();
            for (int y = 0; y < this.reactors.getHeight(); ++y) {
                block1: for (int x = 0; x < this.reactors.getWidth(); ++x) {
                    ItemStack stack1 = this.reactor.getItemAt(x, y);
                    if (stack1.isEmpty()) {
                        stacksItem.add(ItemStack.EMPTY);
                        indexItem.add(y * this.reactors.getWidth() + x);
                        continue;
                    }
                    for (ItemStack itemStack : infoStack) {
                        if (!itemStack.is(stack1.getItem())) continue;
                        stacksItem.add(stack1);
                        indexItem.add(y * this.reactors.getWidth() + x);
                        continue block1;
                    }
                }
            }
            ReactorSchedule reactorSchedule = new ReactorSchedule(this.type, this.levelReactor, this.reactors.getNameReactor().toLowerCase(), (int)((double)this.logicReactor.getGeneration() * (this.reactors.getType() == ITypeRector.GAS_COOLING_FAST ? 1.175 : 1.0)), this.logicReactor.getRadGeneration(), stacksItem, indexItem);
            stack.set(DataComponentsInit.REACTOR_SCHEDULE, (Object)reactorSchedule);
        }
        if (this.work && !this.explode && this.reactors != null && this.logicReactor != null) {
            this.logicReactor.onTick();
            this.reactor.tick(this.logicReactor.getMaxHeat());
            this.explode = this.reactor.explode;
            this.output = this.reactor.getOutput();
            this.rad = this.reactor.getRad();
            this.heat = this.reactor.getHeat();
            this.security = this.reactor.getSecurity();
        } else {
            this.output = 0.0;
            this.rad = 0.0;
            this.heat = 0.0;
            if (this.security != EnumTypeSecurity.NONE) {
                this.reactor.setTime(EnumTypeSecurity.STABLE);
            }
            this.security = EnumTypeSecurity.NONE;
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.level.isClientSide && this.type != -1 && this.levelReactor != -1) {
            this.reactors = EnumReactors.values()[(this.type - 1) * 4 + (this.levelReactor - 1)];
            this.invSlot.clear();
            this.reactor.reset(this.reactors);
            this.reactor.level = this.levelReactor;
            this.work = false;
            this.explode = false;
            this.reactor.setTime(EnumTypeSecurity.STABLE);
            switch (this.reactors.getType()) {
                case FLUID: {
                    this.logicReactor = new LogicCreativeFluidReactor(this.reactor);
                    break;
                }
                case GAS_COOLING_FAST: {
                    this.logicReactor = new LogicCreativeGasReactor(this.reactor);
                    break;
                }
                case GRAPHITE_FLUID: {
                    this.logicReactor = new LogicCreativeGraphiteReactor(this.reactor);
                    break;
                }
                case HIGH_SOLID: {
                    this.logicReactor = new LogicCreativeHeatReactor(this.reactor);
                }
            }
        }
    }

    @Override
    public void updateTileServer(Player var1, double var2) {
        if (var2 < 0.0) {
            this.levelReactor = (int)(var2 *= -1.0);
        } else if (var2 >= 1.0) {
            this.type = (int)var2;
        } else if (var2 < 1.0) {
            this.work = !this.work;
            this.explode = false;
            this.reactor.explode = false;
            this.reactor.setTime(EnumTypeSecurity.STABLE);
            return;
        }
        if (this.levelReactor != -1 && this.type != -1) {
            this.reactors = EnumReactors.values()[(this.type - 1) * 4 + (this.levelReactor - 1)];
            this.invSlot.clear();
            this.reactor.reset(this.reactors);
            this.size_inventory = 0;
            for (Inventory inventory : this.inventories) {
                this.size_inventory += inventory.size();
            }
            this.work = false;
            this.explode = false;
            var1.closeContainer();
            this.reactor.setTime(EnumTypeSecurity.STABLE);
            this.reactor.level = this.levelReactor;
            switch (this.reactors.getType()) {
                case FLUID: {
                    this.logicReactor = new LogicCreativeFluidReactor(this.reactor);
                    break;
                }
                case GAS_COOLING_FAST: {
                    this.logicReactor = new LogicCreativeGasReactor(this.reactor);
                    break;
                }
                case GRAPHITE_FLUID: {
                    this.logicReactor = new LogicCreativeGraphiteReactor(this.reactor);
                    break;
                }
                case HIGH_SOLID: {
                    this.logicReactor = new LogicCreativeHeatReactor(this.reactor);
                }
            }
        }
    }
}

