/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.base;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.vein.common.Type;
import com.denfop.api.vein.common.Vein;
import com.denfop.api.vein.common.VeinSystem;
import com.denfop.api.widget.IType;
import com.denfop.blockentity.base.BlockEntityElectricMachine;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.ISubEnum;
import com.denfop.blocks.mechanism.BlockQuarryVeinEntity;
import com.denfop.componets.EnumTypeStyle;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuQuarryVein;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.datacomponent.VeinInfo;
import com.denfop.items.ItemVeinSensor;
import com.denfop.items.upgradekit.ItemUpgradeMachinesKit;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.render.oilquarry.DataBlock;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenQuarryVein;
import com.denfop.sound.EnumSound;
import com.denfop.utils.Keyboard;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BlockEntityQuarryVein
extends BlockEntityElectricMachine
implements IUpdatableTileEvent,
IType {
    @OnlyIn(value=Dist.CLIENT)
    public DataBlock dataBlock;
    public int levelMech = 1;
    public int time = 0;
    public int progress = 0;
    public Vein vein;
    public boolean start = true;
    public int col;
    private int count = 0;
    private boolean work;

    public BlockEntityQuarryVein(BlockPos pos, BlockState state) {
        super(400.0, 14, 1, BlockQuarryVeinEntity.quarry_vein, pos, state);
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockQuarryVeinEntity.quarry_vein;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.oilquarry.getBlock();
    }

    @Override
    public ItemStack getPickBlock(Player player, HitResult target) {
        ItemStack stack = super.getPickBlock(player, target);
        CompoundTag nbt = ModUtils.nbt(stack);
        nbt.putString("state", "active_" + this.levelMech);
        nbt.putInt("level", this.levelMech);
        return stack;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void updateEntityClient() {
        super.updateEntityClient();
        if ((this.vein == null || !this.vein.get()) && this.getWorld().getGameTime() % 6L == 0L && this.work) {
            BlockPos pos1 = this.pos.below();
            BlockState state = this.level.getBlockState(pos1);
            if (state.isAir()) {
                state = Blocks.STONE.defaultBlockState();
            }
            this.level.levelEvent(2001, this.pos, Block.getId((BlockState)state));
        }
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        if (!player.getItemInHand(hand).isEmpty()) {
            if (player.getItemInHand(hand).getItem() instanceof ItemUpgradeMachinesKit) {
                ItemUpgradeMachinesKit itemUpgradeMachinesKit = (ItemUpgradeMachinesKit)player.getItemInHand(hand).getItem();
                if (this.levelMech < 4 && ((ISubEnum)itemUpgradeMachinesKit.getElement()).getId() == 3) {
                    this.levelMech = 4;
                    this.setActive("active_" + this.levelMech);
                    player.getItemInHand(hand).setCount(player.getItemInHand(hand).getCount() - 1);
                    this.updateTileEntityField();
                    return true;
                }
                if (this.levelMech < 4 && this.levelMech == ((ISubEnum)itemUpgradeMachinesKit.getElement()).getId() + 1) {
                    ++this.levelMech;
                    player.getItemInHand(hand).setCount(player.getItemInHand(hand).getCount() - 1);
                    this.updateTileEntityField();
                    this.setActive("active_" + this.levelMech);
                    return true;
                }
            } else if (player.getItemInHand(hand).getItem() instanceof ItemVeinSensor && this.vein != VeinSystem.system.getEMPTY() && this.vein.get() && this.vein.getType() != Type.EMPTY) {
                String type = this.vein.getType() == Type.VEIN ? this.getType(this.vein.getMeta(), this.vein.isOldMineral()) : (this.vein.getType() == Type.OIL ? "oil" : "gas");
                player.getItemInHand(hand).set(DataComponentsInit.VEIN_INFO, (Object)new VeinInfo(type, this.pos.getX(), this.pos.getZ()));
                return true;
            }
        }
        return super.onActivated(player, hand, side, vec3);
    }

    private String getType(int meta, boolean oldMineral) {
        if (oldMineral) {
            String[] s = new String[]{"magnetite", "calaverite", "galena", "nickelite", "pyrite", "quartzite", "uranite", "azurite", "rhodonite", "alfildit", "euxenite", "smithsonite", "ilmenite", "todorokite", "ferroaugite", "sheelite"};
            return s[meta % s.length];
        }
        String[] s = new String[]{"arsenopyrite", "braggite", "wolframite", "germanite", "coltan", "crocoite", "xenotime", "iridosmine", "theoprastite", "tetrahedrite", "fergusonite", "celestine", "zircon", "crystal"};
        return s[meta % s.length];
    }

    @Override
    public void onPlaced(ItemStack stack, LivingEntity placer, Direction facing) {
        super.onPlaced(stack, placer, facing);
        CompoundTag nbt = ModUtils.nbt(stack);
        int n = this.levelMech = nbt.getInt("level") != 0 ? nbt.getInt("level") : 1;
        if (this.levelMech != 1) {
            this.setActive("active_" + this.levelMech);
        }
        if (this.getWorld().dimension() != Level.OVERWORLD) {
            this.vein = VeinSystem.system.getEMPTY();
        } else {
            if (this.level.isClientSide) {
                return;
            }
            ChunkAccess chunk = this.getWorld().getChunk(this.pos);
            ChunkPos chunkpos = chunk.getPos();
            if (!VeinSystem.system.getChunkPos().contains(chunkpos)) {
                VeinSystem.system.addVein((LevelChunk)chunk);
            }
            this.vein = VeinSystem.system.getVein(chunkpos);
            if (this.vein.get()) {
                this.progress = 1200;
            }
            new PacketUpdateFieldTile(this, "vein", this.vein);
        }
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, this.levelMech);
            EncoderHandler.encode(packet, this.vein);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.levelMech = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.vein = (Vein)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.progress = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.levelMech = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.vein = (Vein)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.progress);
            EncoderHandler.encode(packet, this.levelMech);
            EncoderHandler.encode(packet, this.vein);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.level.isClientSide) {
            return;
        }
        if (this.getWorld().dimension() != Level.OVERWORLD) {
            this.vein = VeinSystem.system.getEMPTY();
        } else {
            LevelChunk chunk = (LevelChunk)this.getWorld().getChunk(this.pos);
            ChunkPos chunkpos = chunk.getPos();
            if (!VeinSystem.system.getChunkPos().contains(chunkpos)) {
                VeinSystem.system.addVein(chunk);
            }
            this.vein = VeinSystem.system.getVein(chunkpos);
            if (this.vein.get()) {
                this.progress = 1200;
            }
            if (this.progress >= 1200) {
                this.vein.setFind(true);
            }
        }
        this.updateTileEntityField();
    }

    private void updateTileEntityField() {
        new PacketUpdateFieldTile(this, "level", this.levelMech);
        new PacketUpdateFieldTile(this, "vein", this.vein);
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("iu.machines_work_energy") + "5" + Localization.translate("iu.machines_work_energy_type_eu"));
        }
        super.addInformation(stack, tooltip);
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        if (name.equals("count")) {
            try {
                this.count = (Integer)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("progress")) {
            try {
                this.progress = (Integer)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("work")) {
            try {
                this.work = (Boolean)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("vein")) {
            try {
                this.vein = (Vein)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("level")) {
            try {
                this.levelMech = (Integer)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        super.updateField(name, is);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.vein == null) {
            return;
        }
        if (this.vein.getCol() != this.count) {
            this.count = this.vein.getCol();
            if (this.getWorld().getGameTime() % 4L == 0L) {
                new PacketUpdateFieldTile(this, "count", this.count);
            }
        }
        if (this.vein.get()) {
            if (this.getWorld().getGameTime() % 20L == 0L && this.col != this.vein.getCol()) {
                new PacketUpdateFieldTile(this, "vein", this.vein);
                this.col = this.vein.getCol();
            }
            return;
        }
        if (this.progress < 1200 && this.energy.getEnergy() >= 5.0 && !this.vein.get()) {
            if (!this.work) {
                this.work = true;
                new PacketUpdateFieldTile(this, "work", this.work);
            }
            if (this.progress == 0) {
                this.initiate(2);
                this.time = 0;
                this.initiate(0);
            }
            if (this.time > 340) {
                this.initiate(2);
                this.time = 0;
            }
            if (this.time == 0) {
                this.initiate(0);
            }
            ++this.time;
            this.progress += (int)Math.pow(2.0, this.levelMech - 1);
            this.energy.useEnergy(5.0);
            if (this.progress >= 1200) {
                this.initiate(2);
                this.progress = 1200;
                this.vein.setFind(true);
                this.updateTileEntityField();
            }
        } else {
            if (this.work) {
                this.work = false;
                new PacketUpdateFieldTile(this, "work", this.work);
            }
            if (this.time > 0) {
                this.initiate(2);
                this.time = 0;
            }
        }
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.progress = nbttagcompound.getInt("progress");
        this.levelMech = nbttagcompound.getInt("level");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.putInt("progress", this.progress);
        nbttagcompound.putInt("level", this.levelMech);
        return nbttagcompound;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<?>> getGui(Player entityPlayer, ContainerMenuBase<?> isAdmin) {
        return new ScreenQuarryVein((ContainerMenuQuarryVein)isAdmin);
    }

    public ContainerMenuQuarryVein getGuiContainer(Player entityPlayer) {
        return new ContainerMenuQuarryVein(entityPlayer, this);
    }

    @Override
    public EnumTypeStyle getStyle() {
        switch (this.levelMech) {
            case 2: {
                return EnumTypeStyle.ADVANCED;
            }
            case 3: {
                return EnumTypeStyle.IMPROVED;
            }
            case 4: {
                return EnumTypeStyle.PERFECT;
            }
        }
        return EnumTypeStyle.DEFAULT;
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.quarry.getSoundEvent();
    }
}

