/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.base;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.recipe.InventoryOutput;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blockentity.base.BlockEntityElectricMachine;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockBaseMachineEntity;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.Fluids;
import com.denfop.componets.Redstone;
import com.denfop.componets.RedstoneHandler;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuNeutronGenerator;
import com.denfop.inventory.Inventory;
import com.denfop.inventory.InventoryFluid;
import com.denfop.inventory.InventoryFluidByList;
import com.denfop.inventory.InventoryUpgrade;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenNeutronGenerator;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class BlockEntityNeutronGenerator
extends BlockEntityElectricMachine
implements IUpgradableBlock,
IUpdatableTileEvent {
    public final InventoryUpgrade upgradeSlot;
    public final InventoryOutput outputSlot = new InventoryOutput(this, 1);
    public final InventoryFluid containerslot = new InventoryFluidByList((BlockEntityInventory)this, Inventory.TypeItemSlot.INPUT, 1, InventoryFluid.TypeFluidSlot.OUTPUT, (Fluid)FluidName.fluidneutron.getInstance().get());
    public final FluidTank fluidTank;
    protected final Fluids fluids = this.addComponent(new Fluids(this));
    private final float energycost;
    private final Redstone redstone;
    private final SoilPollutionComponent pollutionSoil;
    private final AirPollutionComponent pollutionAir;
    public boolean work = true;

    public BlockEntityNeutronGenerator(BlockPos pos, BlockState state) {
        super(2.08E9, 14, 1, BlockBaseMachineEntity.neutron_generator, pos, state);
        this.energycost = 162500.0f;
        this.fluidTank = this.fluids.addTank("fluidTank", 9000, Fluids.fluidPredicate((Fluid)FluidName.fluidneutron.getInstance().get()), Inventory.TypeItemSlot.OUTPUT);
        this.redstone = this.addComponent(new Redstone(this));
        this.redstone.subscribe(new RedstoneHandler(){

            @Override
            public void action(int input) {
                BlockEntityNeutronGenerator.this.energy.setEnabled(input == 0);
                BlockEntityNeutronGenerator.this.work = input != 0;
                BlockEntityNeutronGenerator.this.energy.setReceivingEnabled(BlockEntityNeutronGenerator.this.work);
            }
        });
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.005));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.05));
        this.upgradeSlot = new InventoryUpgrade(this, 4);
    }

    private static int applyModifier(int extra) {
        double ret = Math.round(14.0 + (double)extra);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.work = (Boolean)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.work);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachineEntity.neutron_generator;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.machines.getBlock(this.getTeBlock());
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().isClientSide) {
            this.setUpgradestat();
            this.energy.setReceivingEnabled(this.work);
        }
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
    }

    @Override
    public void readFromNBT(CompoundTag nbt) {
        super.readFromNBT(nbt);
        this.work = nbt.getBoolean("work");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        super.writeToNBT(nbt);
        nbt.putBoolean("work", this.work);
        return nbt;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (!this.containerslot.isEmpty()) {
            this.containerslot.processFromTank((IFluidTank)this.fluidTank, this.outputSlot);
        }
        if (this.work && this.energy.getEnergy() >= (double)this.energycost) {
            boolean needsInvUpdate;
            if (!this.getActive()) {
                this.setActive(true);
            }
            if ((needsInvUpdate = this.attemptGeneration()) && this.upgradeSlot.tickNoMark()) {
                this.setUpgradestat();
            }
        } else if (this.getActive()) {
            this.setActive(false);
        }
        this.upgradeSlot.tickNoMark();
    }

    public boolean attemptGeneration() {
        int k = (int)(this.energy.getEnergy() / (double)this.energycost);
        if (this.fluidTank.getFluidAmount() + 1 > this.fluidTank.getCapacity()) {
            return false;
        }
        int m = this.fluidTank.getCapacity() - this.fluidTank.getFluidAmount();
        this.fluidTank.fill(new FluidStack((Fluid)FluidName.fluidneutron.getInstance().get(), Math.min(m, k)), IFluidHandler.FluidAction.EXECUTE);
        this.energy.useEnergy(this.energycost * (float)Math.min(m, k));
        return true;
    }

    public String getProgressAsString() {
        int p = Math.min((int)(this.energy.getEnergy() * 100.0 / (double)this.energycost), 100);
        return p + "%";
    }

    public ContainerMenuNeutronGenerator getGuiContainer(Player entityPlayer) {
        return new ContainerMenuNeutronGenerator(entityPlayer, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player entityPlayer, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenNeutronGenerator((ContainerMenuNeutronGenerator)menu);
    }

    public void setUpgradestat() {
        this.energy.setSinkTier(BlockEntityNeutronGenerator.applyModifier(this.upgradeSlot.extraTier));
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Transformer, UpgradableProperty.FluidExtract, UpgradableProperty.ItemExtract);
    }

    @Override
    public void updateTileServer(Player entityPlayer, double i) {
        if (i != 10.0) {
            this.work = !this.work;
            this.energy.setReceivingEnabled(this.work);
        } else {
            super.updateTileServer(entityPlayer, i);
        }
    }

    @Override
    public SoundEvent getSound() {
        return null;
    }
}

