/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.base;

import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.recipe.InventoryOutput;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blocks.state.DefaultDrop;
import com.denfop.componets.Fluids;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuTank;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.inventory.Inventory;
import com.denfop.inventory.InventoryFluid;
import com.denfop.inventory.InventoryFluidByList;
import com.denfop.inventory.InventoryUpgrade;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenTank;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.apache.commons.lang3.mutable.MutableObject;

public class BlockEntityLiquedTank
extends BlockEntityInventory
implements IUpgradableBlock {
    public final InventoryUpgrade upgradeSlot;
    public final InventoryFluidByList containerslot = new InventoryFluidByList((BlockEntityInventory)this, Inventory.TypeItemSlot.INPUT, 1, InventoryFluid.TypeFluidSlot.OUTPUT, new Fluid[0]);
    public final InventoryFluidByList containerslot1;
    public final Fluids fluids;
    public final InventoryOutput outputSlot;
    public FluidTank fluidTank;
    public int prev = -10;
    private int old_amount;
    BlockEntityLiquedTank blockEntityLiquedTankDown;

    public BlockEntityLiquedTank(int tanksize, MultiBlockEntity block, BlockPos pos, BlockState state) {
        super(block, pos, state);
        this.containerslot.setUsually(true);
        this.containerslot1 = new InventoryFluidByList((BlockEntityInventory)this, Inventory.TypeItemSlot.INPUT, 1, InventoryFluid.TypeFluidSlot.INPUT, new Fluid[0]);
        this.containerslot1.setUsually(true);
        this.fluids = this.addComponent(new Fluids(this));
        this.fluidTank = this.fluids.addTank("fluidTank", tanksize * 1000);
        this.outputSlot = new InventoryOutput(this, 1);
        this.upgradeSlot = new InventoryUpgrade(this, 4);
    }

    @Override
    public int getLightValue() {
        if (this.fluidTank.getFluid().isEmpty() || this.fluidTank.getFluid().getFluid() == net.minecraft.world.level.material.Fluids.EMPTY) {
            return super.getLightValue();
        }
        return this.fluidTank.getFluid().getFluid().getFluidType().getLightLevel();
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            FluidTank fluidTank1 = (FluidTank)DecoderHandler.decode(customPacketBuffer);
            this.fluidTank.setFluid(fluidTank1.getFluid());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.fluidTank);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        if (!this.getWorld().isClientSide && player.getItemInHand(hand).getCapability(Capabilities.FluidHandler.ITEM, null) != null) {
            return ModUtils.interactWithFluidHandler(player, hand, (IFluidHandler)this.fluids.getCapability(Capabilities.FluidHandler.BLOCK, side));
        }
        return super.onActivated(player, hand, side, vec3);
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (stack.has(DataComponentsInit.DATA) && ((CompoundTag)stack.get(DataComponentsInit.DATA)).contains("fluid")) {
            FluidStack fluidStack = FluidStack.parseOptional((HolderLookup.Provider)this.level.registryAccess(), (CompoundTag)((CompoundTag)((CompoundTag)stack.get(DataComponentsInit.DATA)).get("fluid")));
            tooltip.add(Localization.translate("iu.fluid.info") + String.valueOf(fluidStack.getHoverName().getVisualOrderText()));
            tooltip.add(Localization.translate("iu.fluid.info1") + fluidStack.getAmount() / 1000 + " B");
        }
        tooltip.add(Localization.translate("iu.storage_fluid") + this.fluidTank.getCapacity() / 1000 + " B");
        super.addInformation(stack, tooltip);
    }

    @Override
    public void onPlaced(ItemStack stack, LivingEntity placer, Direction facing) {
        super.onPlaced(stack, placer, facing);
        if (stack.has(DataComponentsInit.DATA) && ((CompoundTag)stack.get(DataComponentsInit.DATA)).contains("fluid")) {
            FluidStack fluidStack = FluidStack.parseOptional((HolderLookup.Provider)placer.registryAccess(), (CompoundTag)((CompoundTag)((CompoundTag)stack.get(DataComponentsInit.DATA)).get("fluid")));
            if (fluidStack != null) {
                this.fluidTank.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            }
            this.old_amount = this.fluidTank.getFluidAmount();
            new PacketUpdateFieldTile(this, "fluidTank", this.fluidTank);
        }
    }

    @Override
    public List<ItemStack> getWrenchDrops(Player player, int fortune) {
        List<ItemStack> itemStackList = super.getWrenchDrops(player, fortune);
        if (this.fluidTank.getFluidAmount() > 0) {
            CompoundTag nbt = ModUtils.nbt(itemStackList.get(0));
            nbt.put("fluid", this.fluidTank.getFluid().save((HolderLookup.Provider)player.registryAccess(), (Tag)new CompoundTag()));
        }
        return itemStackList;
    }

    @Override
    public ItemStack adjustDrop(ItemStack drop, boolean wrench) {
        if ((drop = super.adjustDrop(drop, wrench)).is(this.getPickBlock(null, null).getItem()) && (wrench || this.teBlock.getDefaultDrop() == DefaultDrop.Self) && this.fluidTank.getFluidAmount() > 0) {
            CompoundTag nbt = ModUtils.nbt(drop);
            nbt.put("fluid", this.fluidTank.getFluid().save((HolderLookup.Provider)this.level.registryAccess(), (Tag)new CompoundTag()));
        }
        return drop;
    }

    public FluidTank getFluidTank() {
        return this.fluidTank;
    }

    public double gaugeLiquidScaled(double i) {
        return this.getFluidTank().getFluidAmount() <= 0 ? 0.0 : (double)this.getFluidTank().getFluidAmount() * i / (double)this.getFluidTank().getCapacity();
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, this.fluidTank);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.fluidTank = (FluidTank)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean needsFluid() {
        return this.getFluidTank().getFluidAmount() < this.getFluidTank().getCapacity();
    }

    @Override
    public void onNeighborChange(BlockState neighbor, BlockPos neighborPos) {
        super.onNeighborChange(neighbor, neighborPos);
        if (this.pos.offset(Direction.DOWN.getNormal()).equals((Object)neighborPos)) {
            BlockEntityLiquedTank liquedTank;
            BlockEntity blockEntity = this.getLevel().getBlockEntity(neighborPos);
            this.blockEntityLiquedTankDown = blockEntity instanceof BlockEntityLiquedTank ? (liquedTank = (BlockEntityLiquedTank)blockEntity) : null;
        }
    }

    @Override
    public void updateEntityServer() {
        MutableObject output;
        int amount;
        super.updateEntityServer();
        boolean needsInvUpdate = false;
        if (this.level.getGameTime() % 20L == 0L) {
            boolean need = false;
            if (this.fluidTank.getFluidAmount() != this.old_amount) {
                this.old_amount = this.fluidTank.getFluidAmount();
                need = true;
            }
            if (need) {
                new PacketUpdateFieldTile(this, "fluidTank", this.fluidTank);
            }
        }
        if (this.blockEntityLiquedTankDown != null && !this.fluidTank.getFluid().isEmpty() && (this.blockEntityLiquedTankDown.fluidTank.isEmpty() || FluidStack.isSameFluid((FluidStack)this.blockEntityLiquedTankDown.fluidTank.getFluid(), (FluidStack)this.fluidTank.getFluid())) && (amount = this.blockEntityLiquedTankDown.fluidTank.fill(this.fluidTank.getFluid(), IFluidHandler.FluidAction.SIMULATE)) > 0) {
            FluidStack fluidStack = this.fluidTank.getFluid().copy();
            this.fluidTank.drain(amount, IFluidHandler.FluidAction.EXECUTE);
            this.blockEntityLiquedTankDown.fluidTank.fill(new FluidStack(fluidStack.getFluid(), amount), IFluidHandler.FluidAction.EXECUTE);
        }
        if (this.containerslot.transferFromTank((IFluidTank)this.fluidTank, (MutableObject<ItemStack>)(output = new MutableObject()), true) && (output.getValue() == null || this.outputSlot.canAdd((ItemStack)output.getValue()))) {
            this.containerslot.transferFromTank((IFluidTank)this.fluidTank, (MutableObject<ItemStack>)output, false);
            if (output.getValue() != null) {
                this.outputSlot.add((ItemStack)output.getValue());
            }
        }
        if (this.needsFluid()) {
            output = new MutableObject();
            if (this.fluidTank.getFluidAmount() + 1000 <= this.fluidTank.getCapacity() && this.containerslot1.transferToTank((IFluidTank)this.fluidTank, (MutableObject<ItemStack>)output, true) && (output.getValue() == null || this.outputSlot.canAdd((ItemStack)output.getValue()))) {
                needsInvUpdate = this.containerslot1.transferToTank((IFluidTank)this.fluidTank, (MutableObject<ItemStack>)output, false);
                if (output.getValue() != null) {
                    this.outputSlot.add((ItemStack)output.getValue());
                }
            }
        }
        if (this.upgradeSlot.tickNoMark() && needsInvUpdate) {
            this.setUpgradestat();
        }
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        if (name.equals("fluidTank")) {
            try {
                this.fluidTank.setFluid(((FluidTank)DecoderHandler.decode(is)).getFluid());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        super.updateField(name, is);
    }

    public ContainerMenuTank getGuiContainer(Player entityPlayer) {
        return new ContainerMenuTank(entityPlayer, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player entityPlayer, ContainerMenuBase<? extends CustomWorldContainer> isAdmin) {
        return new ScreenTank(new ContainerMenuTank(entityPlayer, this));
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.level.isClientSide) {
            BlockEntityLiquedTank liquedTank;
            this.setUpgradestat();
            BlockEntity blockEntity = this.getLevel().getBlockEntity(this.pos.offset(Direction.DOWN.getNormal()));
            this.blockEntityLiquedTankDown = blockEntity instanceof BlockEntityLiquedTank ? (liquedTank = (BlockEntityLiquedTank)blockEntity) : null;
        }
    }

    public void setUpgradestat() {
    }

    @Override
    public void setChanged() {
        super.setChanged();
        if (!this.level.isClientSide) {
            this.setUpgradestat();
        }
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Transformer, UpgradableProperty.ItemExtract, UpgradableProperty.ItemInput, UpgradableProperty.FluidInput, UpgradableProperty.FluidExtract);
    }
}

