/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.base;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.InventoryRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blockentity.base.BlockEntityElectricMachine;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockConverterMatterEntity;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuConverterSolidMatter;
import com.denfop.inventory.InventoryConverterSolidMatter;
import com.denfop.inventory.InventoryUpgrade;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.recipe.IInputHandler;
import com.denfop.register.RegisterOreDictionary;
import com.denfop.screen.ScreenConverterSolidMatter;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.utils.ModUtils;
import com.denfop.utils.Precision;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BlockEntityConverterSolidMatter
extends BlockEntityElectricMachine
implements IUpgradableBlock,
IUpdateTick,
IHasRecipe {
    public final InventoryConverterSolidMatter MatterSlot;
    public final InventoryRecipes inputSlot;
    public final InventoryUpgrade upgradeSlot;
    public final int defaultOperationLength;
    public final int defaultEnergyConsume;
    public double[] quantitysolid = new double[8];
    public int energyConsume = 2;
    public double defaultEnergyStorage = 50000.0;
    public double progress = 0.0;
    public double guiProgress = 0.0;
    public int operationLength = 100;
    public int operationsPerTick;
    public MachineRecipe output;
    public boolean required = false;
    public double[] outputmatter = new double[9];

    public BlockEntityConverterSolidMatter(BlockPos pos, BlockState state) {
        super(50000.0, 14, 1, BlockConverterMatterEntity.converter_matter, pos, state);
        this.MatterSlot = new InventoryConverterSolidMatter(this);
        this.upgradeSlot = new InventoryUpgrade(this, 3);
        this.inputSlot = new InventoryRecipes((BlockEntityInventory)this, "converter", (IUpdateTick)this);
        this.defaultOperationLength = 100;
        this.defaultEnergyConsume = 2;
        Recipes.recipes.addInitRecipes(this);
    }

    public static void addrecipe(ItemStack stack, double matter, double sunmatter, double aquamatter, double nethermatter, double nightmatter, double earthmatter, double endmatter, double aermatter) {
        CompoundTag nbt = new CompoundTag();
        double[] quantitysolid = new double[]{Precision.round(matter, 2), Precision.round(sunmatter, 2), Precision.round(aquamatter, 2), Precision.round(nethermatter, 2), Precision.round(nightmatter, 2), Precision.round(earthmatter, 2), Precision.round(endmatter, 2), Precision.round(aermatter, 2)};
        for (int i = 0; i < quantitysolid.length; ++i) {
            ModUtils.SetDoubleWithoutItem(nbt, "quantitysolid_" + i, quantitysolid[i]);
        }
        IInputHandler input = Recipes.inputFactory;
        if (stack.isEmpty()) {
            return;
        }
        Recipes.recipes.addRecipe("converter", new BaseMachineRecipe(new Input(input.getInput(stack)), new RecipeOutput(nbt, stack)));
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.progress = (Double)DecoderHandler.decode(customPacketBuffer);
            this.quantitysolid = (double[])DecoderHandler.decode(customPacketBuffer);
            this.guiProgress = (Double)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.progress);
            EncoderHandler.encode(packet, this.quantitysolid);
            EncoderHandler.encode(packet, this.guiProgress);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockConverterMatterEntity.converter_matter;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.convertersolidmatter.getBlock();
    }

    @Override
    public void init() {
        int i;
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.STONE), 0.2, 0.0, 0.0, 0.0, 0.0, 0.15, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.COBBLESTONE), 0.1, 0.0, 0.0, 0.0, 0.0, 0.05, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.NETHERRACK), 0.1, 0.0, 0.0, 0.05, 0.0, 0.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.GRASS_BLOCK), 0.5, 0.0, 0.0, 0.0, 0.0, 4.0, 0.0, 1.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.GRAVEL), 0.5, 0.0, 0.0, 0.0, 0.0, 0.5, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.GOLD_ORE), 1.0, 0.0, 0.0, 0.0, 0.0, 4.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.COAL_ORE), 1.0, 0.0, 0.0, 0.0, 0.0, 2.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.GOLD_BLOCK), 180.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.IRON_BLOCK), 24.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.GOLD_INGOT), 20.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.IRON_INGOT), 2.67, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.DIAMOND), 50.0, 0.0, 10.0, 0.0, 0.0, 40.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.EMERALD), 70.0, 0.0, 10.0, 0.0, 0.0, 40.0, 0.0, 200.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.DIAMOND_BLOCK), 500.0, 0.0, 100.0, 0.0, 0.0, 400.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.EMERALD_BLOCK), 700.0, 0.0, 100.0, 0.0, 0.0, 400.0, 0.0, 200.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.COAL), 1.5, 0.0, 0.0, 0.0, 0.0, 0.55, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.LAPIS_LAZULI), 5.0, 0.0, 0.0, 0.0, 1.0, 7.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.REDSTONE, 1), 0.5, 0.5, 0.0, 0.0, 0.0, 1.7, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.COAL_BLOCK), 15.0, 0.0, 0.0, 0.0, 0.0, 4.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.STRING), 150.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 200.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.LEATHER), 150.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 50.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.SLIME_BALL), 100.0, 0.0, 200.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.BLAZE_ROD), 100.0, 0.0, 0.0, 1000.0, 500.0, 0.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.BONE), 20.0, 0.0, 0.0, 0.0, 100.0, 0.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.BLACK_DYE), 20.0, 40.0, 40.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.RED_DYE), 20.0, 40.0, 40.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.GREEN_DYE), 20.0, 40.0, 40.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.BROWN_DYE), 20.0, 40.0, 40.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.BLUE_DYE), 20.0, 40.0, 40.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.PURPLE_DYE), 20.0, 40.0, 40.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.CYAN_DYE), 20.0, 40.0, 40.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.LIGHT_GRAY_DYE), 20.0, 40.0, 40.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.GRAY_DYE), 20.0, 40.0, 40.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.PINK_DYE), 20.0, 40.0, 40.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.LIME_DYE), 20.0, 40.0, 40.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.YELLOW_DYE), 20.0, 40.0, 40.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.LIGHT_BLUE_DYE), 20.0, 40.0, 40.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.MAGENTA_DYE), 20.0, 40.0, 40.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.ORANGE_DYE), 20.0, 40.0, 40.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.WHITE_DYE), 20.0, 40.0, 40.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.FLINT), 1.0, 0.0, 0.0, 0.0, 0.0, 0.25, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.SOUL_SAND), 0.0, 0.0, 0.0, 150.0, 50.0, 0.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.NETHER_BRICKS), 0.0, 0.0, 0.0, 250.0, 100.0, 0.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.CLAY_BALL), 0.0, 0.0, 40.0, 0.0, 0.0, 0.0, 0.0, 20.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.BRICK), 0.0, 0.0, 40.0, 0.0, 0.0, 0.0, 0.0, 20.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.NETHERRACK), 0.0, 0.0, 40.0, 40.0, 0.0, 0.0, 0.0, 20.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.GUNPOWDER), 4.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.LAPIS_BLOCK), 50.0, 0.0, 0.0, 0.0, 10.0, 60.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.REDSTONE_BLOCK), 5.0, 5.0, 0.0, 0.0, 0.0, 15.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.QUARTZ_BLOCK), 30.0, 0.0, 0.0, 300.0, 20.0, 0.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.QUARTZ), 7.5, 0.0, 0.0, 75.0, 5.0, 0.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.STICK), 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.OAK_PLANKS), 10.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.SPRUCE_PLANKS), 10.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.BIRCH_PLANKS), 10.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.JUNGLE_PLANKS), 10.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.ACACIA_PLANKS), 10.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.DARK_OAK_PLANKS), 10.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.PUMPKIN), 1000.0, 1000.0, 1000.0, 0.0, 0.0, 0.0, 0.0, 2000.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.MELON), 1000.0, 1000.0, 1000.0, 0.0, 0.0, 0.0, 0.0, 2000.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.WHEAT), 1000.0, 2000.0, 500.0, 0.0, 0.0, 0.0, 0.0, 2000.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.SUGAR_CANE), 300.0, 200.0, 500.0, 0.0, 0.0, 0.0, 0.0, 500.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.FEATHER), 300.0, 200.0, 500.0, 0.0, 0.0, 0.0, 0.0, 500.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.WHITE_WOOL), 600.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 800.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.NETHER_WART), 1000.0, 0.0, 0.0, 2500.0, 2000.0, 0.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.GLOWSTONE), 30.0, 20.0, 0.0, 300.0, 20.0, 0.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.GLASS), 2.0, 0.0, 0.5, 0.0, 0.0, 0.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.END_STONE), 0.5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.25, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.GLOWSTONE_DUST), 7.5, 5.0, 0.0, 75.0, 5.0, 0.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(IUItem.copperBlock, 8.0, 0.0, 0.0, 0.0, 0.0, 4.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(IUItem.tinBlock, 10.0, 0.0, 0.0, 0.0, 0.0, 4.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(IUItem.bronzeBlock, 10.0, 0.0, 0.0, 0.0, 0.0, 4.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(IUItem.advironblock, 20.0, 0.0, 0.0, 0.0, 0.0, 8.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(IUItem.uraniumBlock, 15.0, 0.0, 0.0, 0.0, 0.0, 8.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(IUItem.leadBlock, 80.0, 0.0, 0.0, 0.0, 0.0, 40.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(IUItem.copperIngot, 0.8888888888888888, 0.0, 0.0, 0.0, 0.0, 0.4444444444444444, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(IUItem.tinIngot, 1.1111111111111112, 0.0, 0.0, 0.0, 0.0, 0.4444444444444444, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(IUItem.bronzeIngot, 1.1111111111111112, 0.0, 0.0, 0.0, 0.0, 0.4444444444444444, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(IUItem.advIronIngot, 2.2222222222222223, 0.0, 0.0, 0.0, 0.0, 0.8888888888888888, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)IUItem.itemiu.getStack(2), 1), 1.6666666666666667, 0.0, 0.0, 0.0, 0.0, 0.8888888888888888, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(IUItem.leadIngot, 8.88888888888889, 0.0, 0.0, 0.0, 0.0, 4.444444444444445, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(IUItem.platecopper, 0.8888888888888888, 0.0, 0.0, 0.0, 0.0, 0.4444444444444444, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(IUItem.platetin, 1.1111111111111112, 0.0, 0.0, 0.0, 0.0, 0.4444444444444444, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(IUItem.platebronze, 1.1111111111111112, 0.0, 0.0, 0.0, 0.0, 0.4444444444444444, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(IUItem.plateadviron, 2.2222222222222223, 0.0, 0.0, 0.0, 0.0, 0.8888888888888888, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(IUItem.platelead, 8.88888888888889, 0.0, 0.0, 0.0, 0.0, 4.444444444444445, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(IUItem.casingcopper, 0.4444444444444444, 0.0, 0.0, 0.0, 0.0, 0.2222222222222222, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(IUItem.casingtin, 0.5555555555555556, 0.0, 0.0, 0.0, 0.0, 0.2222222222222222, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(IUItem.casingbronze, 0.5555555555555556, 0.0, 0.0, 0.0, 0.0, 0.2222222222222222, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(IUItem.casingadviron, 1.1111111111111112, 0.0, 0.0, 0.0, 0.0, 0.4444444444444444, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(IUItem.casinglead, 4.444444444444445, 0.0, 0.0, 0.0, 0.0, 2.2222222222222223, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(IUItem.copperCableItem, 0.4444444444444444, 0.0, 0.0, 0.0, 0.0, 0.2222222222222222, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(IUItem.tinCableItem, 0.37037037037037035, 0.0, 0.0, 0.0, 0.0, 0.14814814814814814, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(IUItem.goldCableItem, 5.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(IUItem.ironCableItem, 0.6675, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(IUItem.plategold, 20.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(IUItem.plateiron, 2.67, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(IUItem.rubber, 150.0, 0.0, 40.0, 0.0, 0.0, 0.0, 0.0, 50.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Items.ENDER_PEARL), 0.0, 0.0, 0.0, 0.0, 250.0, 0.0, 2000.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)Blocks.OBSIDIAN), 0.0, 0.0, 0.0, 0.0, 30.0, 10.0, 10.0, 0.0);
        for (i = 0; i < IUItem.name_mineral.size(); ++i) {
            BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)IUItem.iuingot.getStack(i), 1), 12.0, 0.0, 0.0, 0.0, 0.0, 36.0, 0.0, 0.0);
        }
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)IUItem.iuingot.getStack(25), 1), 12.0, 0.0, 0.0, 0.0, 0.0, 36.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)IUItem.iuingot.getStack(26), 1), 12.0, 0.0, 0.0, 0.0, 0.0, 36.0, 0.0, 0.0);
        BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)IUItem.iuingot.getStack(27), 1), 12.0, 0.0, 0.0, 0.0, 0.0, 36.0, 0.0, 0.0);
        for (i = 0; i < RegisterOreDictionary.list_baseore1.size(); ++i) {
            BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)IUItem.iuingot.getStack(i + 28), 1), 12.0, 0.0, 0.0, 0.0, 0.0, 36.0, 0.0, 0.0);
        }
        for (i = 0; i < RegisterOreDictionary.list_baseore1.size(); ++i) {
            BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)IUItem.stik.getStack(i + 22), 1), 6.0, 0.0, 0.0, 0.0, 0.0, 18.0, 0.0, 0.0);
        }
        for (i = 0; i < IUItem.name_mineral.size(); ++i) {
            BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)IUItem.stik.getStack(i), 1), 6.0, 0.0, 0.0, 0.0, 0.0, 18.0, 0.0, 0.0);
        }
        for (i = 0; i < RegisterOreDictionary.list_baseore1.size(); ++i) {
            BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)IUItem.plate.getStack(i + 31), 1), 12.0, 0.0, 0.0, 0.0, 0.0, 36.0, 0.0, 0.0);
        }
        for (i = 0; i < IUItem.name_mineral.size(); ++i) {
            BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)IUItem.plate.getStack(i), 1), 12.0, 0.0, 0.0, 0.0, 0.0, 36.0, 0.0, 0.0);
        }
        for (i = 0; i < RegisterOreDictionary.list_baseore1.size(); ++i) {
            BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)IUItem.doubleplate.getStack(i + 31), 1), 108.0, 0.0, 0.0, 0.0, 0.0, 288.0, 0.0, 0.0);
        }
        for (i = 0; i < IUItem.name_mineral.size(); ++i) {
            BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)IUItem.doubleplate.getStack(i), 1), 108.0, 0.0, 0.0, 0.0, 0.0, 288.0, 0.0, 0.0);
        }
        for (i = 0; i < IUItem.name_mineral.size(); ++i) {
            BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)IUItem.casing.getStack(i), 1), 6.0, 0.0, 0.0, 0.0, 0.0, 18.0, 0.0, 0.0);
        }
        for (i = 0; i < RegisterOreDictionary.list_baseore1.size(); ++i) {
            BlockEntityConverterSolidMatter.addrecipe(new ItemStack((ItemLike)IUItem.casing.getStack(i + 29), 1), 6.0, 0.0, 0.0, 0.0, 0.0, 18.0, 0.0, 0.0);
        }
        IUItem.machineRecipe = Recipes.recipes.getRecipeStack("converter");
    }

    public void setOverclockRates() {
        this.operationsPerTick = this.upgradeSlot.getOperationsPerTick(this.defaultOperationLength);
        this.operationLength = this.upgradeSlot.getOperationLength(this.defaultOperationLength);
        this.energyConsume = (int)this.upgradeSlot.getEnergyDemand(2);
    }

    public double getProgress() {
        return this.guiProgress;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        MachineRecipe output = this.output;
        if (output != null && this.outputSlot.canAdd(this.output.getRecipe().output.items) && !this.inputSlot.isEmpty() && this.required) {
            double p;
            if (!this.getActive()) {
                this.setActive(true);
            }
            if (this.level.getGameTime() % 20L == 0L) {
                this.MatterSlot.getmatter();
            }
            if (this.useEnergy(this.energyConsume, false) && this.required) {
                this.progress += 1.0;
                this.useEnergy(this.energyConsume, true);
            }
            if ((p = this.progress / (double)this.operationLength) <= 1.0) {
                this.guiProgress = p;
            }
            if (p > 1.0) {
                this.guiProgress = 1.0;
            }
            if (this.progress >= (double)this.operationLength && this.required) {
                this.operate(output);
                this.progress = 0.0;
            }
        } else if (this.getActive()) {
            this.setActive(false);
        }
        if (this.upgradeSlot.tickNoMark()) {
            this.setOverclockRates();
        }
    }

    private void useMatter() {
        for (int i = 0; i < this.quantitysolid.length; ++i) {
            int n = i;
            this.quantitysolid[n] = this.quantitysolid[n] - this.outputmatter[i];
        }
    }

    public void getrequiredmatter(RecipeOutput output) {
        if (output == null) {
            this.required = false;
            return;
        }
        for (int i = 0; i < this.quantitysolid.length; ++i) {
            if (this.quantitysolid[i] >= this.outputmatter[i]) continue;
            this.required = false;
            return;
        }
        this.required = true;
    }

    public void operate(MachineRecipe output) {
        List<ItemStack> processResult = output.getRecipe().output.items;
        this.operateOnce(processResult);
    }

    public void operateOnce(List<ItemStack> processResult) {
        this.useMatter();
        this.outputSlot.add(processResult);
        this.getrequiredmatter(this.output.getRecipe().getOutput());
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.inputSlots.remove(this.inputSlot);
        this.inputSlot.load();
        this.getOutput();
        if (this.output != null) {
            for (int i = 0; i < this.quantitysolid.length; ++i) {
                this.outputmatter[i] = this.output.getRecipe().output.metadata.getDouble("quantitysolid_" + i);
            }
            this.getrequiredmatter(this.output.getRecipe().getOutput());
        } else {
            this.getrequiredmatter(null);
        }
        this.MatterSlot.getmatter();
    }

    public MachineRecipe getOutput() {
        this.output = this.inputSlot.process();
        return this.output;
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.progress = nbttagcompound.getDouble("progress");
        for (int i = 0; i < this.quantitysolid.length; ++i) {
            this.quantitysolid[i] = nbttagcompound.getDouble("quantitysolid" + i);
        }
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.putDouble("progress", this.progress);
        for (int i = 0; i < this.quantitysolid.length; ++i) {
            nbttagcompound.putDouble("quantitysolid" + i, this.quantitysolid[i]);
        }
        return nbttagcompound;
    }

    public boolean useEnergy(double amount, boolean consume) {
        if (this.energy.canUseEnergy(amount)) {
            if (consume) {
                this.energy.useEnergy(amount);
            }
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<?>> getGui(Player entityPlayer, ContainerMenuBase<?> isAdmin) {
        return new ScreenConverterSolidMatter((ContainerMenuConverterSolidMatter)isAdmin);
    }

    public ContainerMenuConverterSolidMatter getGuiContainer(Player entityPlayer) {
        return new ContainerMenuConverterSolidMatter(entityPlayer, this);
    }

    public float getWrenchDropRate() {
        return 0.85f;
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemExtract, UpgradableProperty.ItemInput);
    }

    @Override
    public void onUpdate() {
        if (this.output != null) {
            for (int i = 0; i < this.quantitysolid.length; ++i) {
                this.outputmatter[i] = this.output.getRecipe().output.metadata.getDouble("quantitysolid_" + i);
            }
        }
        if (this.output == null) {
            this.getrequiredmatter(null);
        } else {
            this.getrequiredmatter(this.output.getRecipe().getOutput());
        }
        this.MatterSlot.getmatter();
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
    }

    @Override
    public SoundEvent getSound() {
        return null;
    }
}

