/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.base;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.InventoryOutput;
import com.denfop.api.recipe.InventoryRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blockentity.base.BlockEntityElectricLiquidTankInventory;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blockentity.base.BlockEntityMultiMatter;
import com.denfop.blockentity.base.IMatter;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockBaseMachine2Entity;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.Energy;
import com.denfop.componets.Redstone;
import com.denfop.componets.RedstoneHandler;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuCombinerMatter;
import com.denfop.inventory.Inventory;
import com.denfop.inventory.InventoryFluid;
import com.denfop.inventory.InventoryFluidByList;
import com.denfop.inventory.InventoryMatter;
import com.denfop.inventory.InventoryUpgrade;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.screen.ScreenCombinerMatter;
import com.denfop.screen.ScreenIndustrialUpgrade;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.apache.commons.lang3.mutable.MutableObject;

public class BlockEntityCombinerMatter
extends BlockEntityElectricLiquidTankInventory
implements IUpgradableBlock,
IUpdateTick,
IMatter {
    public final InventoryMatter inputSlot;
    public final InventoryUpgrade upgradeSlot;
    public final InventoryRecipes amplifierSlot = new InventoryRecipes((BlockEntityInventory)this, "matterAmplifier", (IUpdateTick)this);
    public final InventoryOutput outputSlot = new InventoryOutput(this, 1);
    public final InventoryFluid containerslot;
    protected final Redstone redstone;
    private final SoilPollutionComponent pollutionSoil;
    private final AirPollutionComponent pollutionAir;
    public int scrap;
    public double energycost = 0.0;
    private double lastEnergy;
    private MachineRecipe recipe;
    private int amountScrap;

    public BlockEntityCombinerMatter(BlockPos pos, BlockState state) {
        super(0.0, 14, 12, BlockBaseMachine2Entity.combiner_matter, pos, state);
        this.fluidTank.setTypeItemSlot(Inventory.TypeItemSlot.INPUT);
        this.containerslot = new InventoryFluidByList((BlockEntityInventory)this, Inventory.TypeItemSlot.INPUT, 1, InventoryFluid.TypeFluidSlot.OUTPUT, (Fluid)FluidName.fluiduu_matter.getInstance().get());
        this.upgradeSlot = new InventoryUpgrade(this, 4);
        this.inputSlot = new InventoryMatter(this);
        this.energy = this.addComponent(Energy.asBasicSink((BlockEntityInventory)this, 0.0, 14).addManagedSlot(this.dischargeSlot));
        this.redstone = this.addComponent(new Redstone(this));
        this.redstone.subscribe(new RedstoneHandler(){

            @Override
            public void action(int input) {
                BlockEntityCombinerMatter.this.energy.setEnabled(input == 0);
            }
        });
        this.fluidTank.setTypeItemSlot(Inventory.TypeItemSlot.OUTPUT);
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.05));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.1));
    }

    private static int applyModifier(int base) {
        double ret = Math.round((double)(base + 14) * 1.0);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.scrap = (Integer)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.scrap);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachine2Entity.combiner_matter;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine1.getBlock(this.getTeBlock().getId());
    }

    @Override
    public int getInventoryStackLimit() {
        return 4;
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.scrap = nbttagcompound.getInt("scrap");
        this.lastEnergy = nbttagcompound.getDouble("lastEnergy");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.putInt("scrap", this.scrap);
        nbttagcompound.putDouble("lastEnergy", this.lastEnergy);
        return nbttagcompound;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.fluidTank.getCapacity() <= 0) {
            this.fluidTank.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE);
        }
        if (this.redstone.hasRedstoneInput() || this.energy.getEnergy() <= 0.0) {
            if (this.getActive()) {
                this.setActive(false);
            }
        } else {
            double bonus;
            if (this.scrap > 0 && (bonus = Math.min((double)this.scrap, this.energy.getEnergy() - this.lastEnergy)) > 0.0) {
                this.energy.forceAddEnergy(5.0 * bonus);
                this.scrap = (int)((double)this.scrap - bonus);
            }
            if (!this.getActive()) {
                this.setActive(true);
            }
            if (this.scrap < 10000 && this.amountScrap > 0) {
                this.recipe = this.getRecipeOutput();
                if (this.recipe != null) {
                    this.amplifierSlot.consume();
                    this.scrap += this.amountScrap;
                    if (this.amplifierSlot.isEmpty()) {
                        this.getOutput();
                    }
                }
            }
            if (this.energy.canUseEnergy(this.energycost)) {
                this.attemptGeneration();
            }
            this.lastEnergy = this.energy.getEnergy();
            MutableObject output = new MutableObject();
            if (this.containerslot.transferFromTank((IFluidTank)this.fluidTank, (MutableObject<ItemStack>)output, true) && (output.getValue() == null || this.outputSlot.canAdd((ItemStack)output.getValue()))) {
                this.containerslot.transferFromTank((IFluidTank)this.fluidTank, (MutableObject<ItemStack>)output, false);
                if (output.getValue() != null) {
                    this.outputSlot.add((ItemStack)output.getValue());
                }
            }
            if (this.upgradeSlot.tickNoMark()) {
                this.setUpgradestat();
            }
        }
    }

    private void getOutput() {
        this.recipe = this.amplifierSlot.process();
        this.setRecipeOutput(this.recipe);
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
        if (!this.getWorld().isClientSide) {
            Map<ChunkPos, List<IMatter>> chunkPosListMap = BlockEntityMultiMatter.worldMatterMap.get(this.getWorld().dimension());
            if (chunkPosListMap == null) {
                chunkPosListMap = new HashMap<ChunkPos, List<IMatter>>();
                ChunkPos chunkPos = new ChunkPos(this.pos.getX() >> 4, this.pos.getZ() >> 4);
                LinkedList matters = new LinkedList();
                chunkPosListMap.put(chunkPos, matters);
                BlockEntityMultiMatter.worldMatterMap.put((ResourceKey<Level>)this.getWorld().dimension(), chunkPosListMap);
            } else {
                ChunkPos chunkPos = new ChunkPos(this.pos.getX() >> 4, this.pos.getZ() >> 4);
                List<IMatter> matters = chunkPosListMap.get(chunkPos);
                if (matters == null) {
                    matters = new LinkedList<IMatter>();
                    chunkPosListMap.put(chunkPos, matters);
                } else {
                    matters.remove(this);
                }
            }
        }
    }

    public void attemptGeneration() {
        int k = (int)(this.energy.getEnergy() / this.energycost);
        if (this.fluidTank.getFluidAmount() + 1 > this.fluidTank.getCapacity()) {
            return;
        }
        int m = this.fluidTank.getCapacity() - this.fluidTank.getFluidAmount();
        this.fluidTank.fill(new FluidStack((Fluid)FluidName.fluiduu_matter.getInstance().get(), Math.min(m, k)), IFluidHandler.FluidAction.EXECUTE);
        this.energy.useEnergy(this.energycost * (double)Math.min(m, k));
    }

    public ContainerMenuCombinerMatter getGuiContainer(Player entityPlayer) {
        return new ContainerMenuCombinerMatter(entityPlayer, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player entityPlayer, ContainerMenuBase<? extends CustomWorldContainer> isAdmin) {
        return new ScreenCombinerMatter((ContainerMenuCombinerMatter)isAdmin);
    }

    @Override
    public SoundEvent getSound() {
        return null;
    }

    public float getWrenchDropRate() {
        return 0.7f;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().isClientSide) {
            this.setUpgradestat();
            this.inputSlot.update();
            this.amplifierSlot.load();
            this.getOutput();
            Map<ChunkPos, List<IMatter>> chunkPosListMap = BlockEntityMultiMatter.worldMatterMap.get(this.getWorld().dimension());
            if (chunkPosListMap == null) {
                chunkPosListMap = new HashMap<ChunkPos, List<IMatter>>();
                ChunkPos chunkPos = new ChunkPos(this.pos.getX() >> 4, this.pos.getZ() >> 4);
                LinkedList<BlockEntityCombinerMatter> matters = new LinkedList<BlockEntityCombinerMatter>();
                matters.add(this);
                chunkPosListMap.put(chunkPos, matters);
                BlockEntityMultiMatter.worldMatterMap.put((ResourceKey<Level>)this.getWorld().dimension(), chunkPosListMap);
            } else {
                ChunkPos chunkPos = new ChunkPos(this.pos.getX() >> 4, this.pos.getZ() >> 4);
                List<IMatter> matters = chunkPosListMap.get(chunkPos);
                if (matters == null) {
                    matters = new LinkedList<IMatter>();
                    matters.add(this);
                    chunkPosListMap.put(chunkPos, matters);
                } else {
                    matters.add(this);
                }
            }
        }
    }

    public void setUpgradestat() {
        this.energy.setSinkTier(BlockEntityCombinerMatter.applyModifier(this.upgradeSlot.extraTier));
    }

    @Override
    public double getEnergy() {
        return this.energy.getEnergy();
    }

    @Override
    public boolean useEnergy(double amount) {
        if (this.energy.canUseEnergy(amount)) {
            this.energy.useEnergy(amount);
            return true;
        }
        return false;
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Transformer, UpgradableProperty.ItemExtract, UpgradableProperty.ItemInput, UpgradableProperty.FluidExtract);
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.recipe;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.recipe = output;
        this.amountScrap = this.recipe == null ? 0 : this.recipe.getRecipe().getOutput().metadata.getInt("amount");
    }

    @Override
    public FluidTank getMatterTank() {
        return this.fluidTank;
    }
}

