/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.base;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.energy.event.load.EnergyTileLoadEvent;
import com.denfop.api.energy.event.unload.EnergyTileUnLoadEvent;
import com.denfop.api.energy.forgeenergy.EnergyForge;
import com.denfop.api.energy.forgeenergy.EnergyForgeSink;
import com.denfop.api.energy.forgeenergy.EnergyForgeSinkSource;
import com.denfop.api.energy.forgeenergy.EnergyForgeSource;
import com.denfop.api.energy.interfaces.EnergyTile;
import com.denfop.api.energy.networking.EnergyNetGlobal;
import com.denfop.blockentity.base.CooldownTracker;
import com.denfop.blocks.BlockResource;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.state.HarvestTool;
import com.denfop.componets.AbstractComponent;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.Energy;
import com.denfop.componets.Redstone;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.events.TickHandlerIU;
import com.denfop.inventory.Inventory;
import com.denfop.network.DecoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketStopSound;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.network.packet.PacketUpdateTile;
import com.denfop.utils.Keyboard;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import com.denfop.world.WorldBaseGen;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

public abstract class BlockEntityBase
extends BlockEntity {
    public static final List<AABB> defaultAabbs = Collections.singletonList(new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
    public static int ticker = 1;
    public static Map<ResourceKey<Level>, List<ChunkPos>> updates = new ConcurrentHashMap<ResourceKey<Level>, List<ChunkPos>>();
    public final MultiBlockEntity teBlock;
    public final BlockTileEntity block;
    public BlockPos pos;
    public Map<BlockCapability<?, ?>, AbstractComponent> capabilityComponents;
    public List<AbstractComponent> componentList = new ArrayList<AbstractComponent>();
    public List<AbstractComponent> updateServerList = new ArrayList<AbstractComponent>();
    public List<AbstractComponent> updateClientList = new ArrayList<AbstractComponent>();
    public Map<String, AbstractComponent> advComponentMap = new HashMap<String, AbstractComponent>();
    public SoilPollutionComponent pollutionSoil;
    public AirPollutionComponent pollutionAir;
    public String active = "";
    public boolean isLoaded;
    public byte facing;
    public HolderLookup.Provider provider;
    public BlockState blockState;
    boolean hasHashCode = false;
    CooldownTracker cooldownTracker = new CooldownTracker();
    boolean loaded = false;
    private boolean isClientLoaded;
    private int hashCode;

    public BlockEntityBase(MultiBlockEntity multiBlockItem, BlockPos p_155229_, BlockState p_155230_) {
        super(multiBlockItem.getBlockType(), p_155229_, p_155230_);
        this.blockState = p_155230_;
        this.teBlock = this.getTeBlock();
        this.block = this.getBlock();
        this.pos = p_155229_;
    }

    public static boolean checkSide(List<AABB> aabbs, Direction side, boolean strict) {
        AABB aabb2;
        if (aabbs == defaultAabbs) {
            return true;
        }
        int dx = side.getStepX();
        int dy = side.getStepY();
        int dz = side.getStepZ();
        int xS = (dx + 1) / 2;
        int yS = (dy + 1) / 2;
        int zS = (dz + 1) / 2;
        int xE = (dx + 2) / 2;
        int yE = (dy + 2) / 2;
        int zE = (dz + 2) / 2;
        if (strict) {
            for (AABB aabb2 : aabbs) {
                switch (side) {
                    case DOWN: {
                        if (!(aabb2.minY < 0.0)) break;
                        return false;
                    }
                    case UP: {
                        if (!(aabb2.maxY > 1.0)) break;
                        return false;
                    }
                    case NORTH: {
                        if (!(aabb2.minZ < 0.0)) break;
                        return false;
                    }
                    case SOUTH: {
                        if (!(aabb2.maxZ > 1.0)) break;
                        return false;
                    }
                    case WEST: {
                        if (!(aabb2.minX < 0.0)) break;
                        return false;
                    }
                    case EAST: {
                        if (!(aabb2.maxX > 1.0)) break;
                        return false;
                    }
                }
            }
        }
        Iterator<AABB> var12 = aabbs.iterator();
        do {
            if (!var12.hasNext()) {
                return false;
            }
            aabb2 = var12.next();
        } while (!(aabb2.minX <= (double)xS) || !(aabb2.minY <= (double)yS) || !(aabb2.minZ <= (double)zS) || !(aabb2.maxX >= (double)xE) || !(aabb2.maxY >= (double)yE) || !(aabb2.maxZ >= (double)zE));
        return true;
    }

    public RegistryAccess registryAccess() {
        return this.getWorld().registryAccess();
    }

    public void setChanged() {
        if (!this.getLevel().isClientSide()) {
            for (AbstractComponent abstractComponent : this.componentList) {
                abstractComponent.markDirty();
            }
        }
        if (this.level != null) {
            BlockEntityBase.setChanged((Level)this.level, (BlockPos)this.worldPosition, (BlockState)this.blockState);
        }
    }

    public BlockPos getPos() {
        return this.worldPosition;
    }

    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (this.level == null) {
            AirPollutionComponent air = this.getComp(AirPollutionComponent.class);
            SoilPollutionComponent soil = this.getComp(SoilPollutionComponent.class);
            if (air != null || soil != null) {
                if (Keyboard.isKeyDown(340)) {
                    tooltip.add(Localization.translate("iu.pollution.info1"));
                    tooltip.add(Localization.translate("iu.pollution.info2"));
                    tooltip.add(Localization.translate("iu.pollution.info3"));
                }
                tooltip.add(Localization.translate("iu.pollution.info"));
            }
        }
        for (AbstractComponent component : this.componentList) {
            component.addInformation(stack, tooltip);
        }
    }

    public Level getWorld() {
        return this.getLevel();
    }

    public void readFromNBT(CompoundTag nbt) {
        this.facing = nbt.getByte("facing");
        this.active = nbt.getString("active");
        if (!this.componentList.isEmpty() && nbt.contains("component_mod", 10)) {
            CompoundTag componentsNbt = nbt.getCompound("component_mod");
            for (int i = 0; i < this.componentList.size(); ++i) {
                AbstractComponent component = this.componentList.get(i);
                CompoundTag componentNbt = componentsNbt.getCompound("component_" + i);
                component.readFromNbt(componentNbt);
            }
        }
    }

    protected void loadAdditional(CompoundTag p_338466_, HolderLookup.Provider p_338445_) {
        super.loadAdditional(p_338466_, p_338445_);
        this.provider = p_338445_;
        this.readFromNBT(p_338466_);
    }

    public void onLoaded() {
        this.pos = this.worldPosition;
        this.componentList.forEach(AbstractComponent::onLoaded);
        this.rerender();
        if (!this.getLevel().isClientSide && this.needUpdate()) {
            IUCore.network.getServer().addTileToOvertimeUpdate(this);
        }
        this.hashCode();
    }

    public CompoundTag writeToNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.provider = provider;
        return this.writeToNBT(nbt);
    }

    public CompoundTag writeToNBT(CompoundTag nbt) {
        nbt.putByte("facing", this.facing);
        nbt.putString("active", this.active);
        if (!this.componentList.isEmpty()) {
            CompoundTag componentsNbt = new CompoundTag();
            for (int i = 0; i < this.componentList.size(); ++i) {
                AbstractComponent component = this.componentList.get(i);
                CompoundTag nbt1 = component.writeToNbt();
                if (nbt1 == null) {
                    nbt1 = new CompoundTag();
                }
                componentsNbt.put("component_" + i, (Tag)nbt1);
            }
            nbt.put("component_mod", (Tag)componentsNbt);
        }
        return nbt;
    }

    protected void saveAdditional(CompoundTag p_187471_, HolderLookup.Provider p_323635_) {
        super.saveAdditional(p_187471_, p_323635_);
        this.provider = p_323635_;
        this.writeToNBT(p_187471_);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        new PacketUpdateTile(this);
        return null;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider p_323910_) {
        new PacketUpdateTile(this);
        return super.getUpdateTag(p_323910_);
    }

    public void tick() {
        if (this.isRemoved()) {
            return;
        }
        if (this.getLevel().isClientSide) {
            this.updateEntityClient();
        } else {
            this.updateEntityServer();
            if (ticker % 120 == 0) {
                ChunkPos chunkPos = new ChunkPos(this.worldPosition);
                if (!this.isRemoved() && !updates.computeIfAbsent((ResourceKey<Level>)this.level.dimension(), k -> new LinkedList()).contains(chunkPos)) {
                    updates.computeIfAbsent((ResourceKey<Level>)this.level.dimension(), k -> new LinkedList()).add(chunkPos);
                    this.level.blockEntityChanged(this.worldPosition);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateEntityClient() {
        this.pos = this.worldPosition;
        this.updateClientList.forEach(AbstractComponent::updateEntityClient);
        if (!this.isClientLoaded) {
            this.loadBeforeFirstClientUpdate();
        }
        if (this.cooldownTracker.getTick() > 0) {
            this.cooldownTracker.removeTick();
        }
    }

    public void loadBeforeFirstClientUpdate() {
        this.isClientLoaded = true;
    }

    public void updateEntityServer() {
        this.pos = this.worldPosition;
        if (!this.getSupportedFacings().contains(this.getFacing())) {
            for (Property property : this.blockState.getProperties()) {
                if (!property.getName().equals("facing")) continue;
                Direction value = (Direction)this.blockState.getValue(property);
                this.setFacing(value);
                break;
            }
        }
        for (AbstractComponent component : this.updateServerList) {
            component.updateEntityServer();
        }
        if (!this.isLoaded) {
            this.loadBeforeFirstUpdate();
        }
        if (this.cooldownTracker.getTick() > 0) {
            this.cooldownTracker.removeTick();
        }
    }

    public void setRemoved() {
        if (this.loaded) {
            this.onUnloaded();
        }
        super.setRemoved();
    }

    public void onLoad() {
        if (!this.loaded) {
            super.onLoad();
            this.loaded = true;
            Level world = this.getLevel();
            if (this.worldPosition != null) {
                TickHandlerIU.requestSingleWorldTick(world, world1 -> this.onLoaded());
            }
        }
    }

    public void loadBeforeFirstUpdate() {
        this.isLoaded = true;
        try {
            for (Direction direction : Direction.values()) {
                EnergyTile energyTile;
                if (this.getLevel().isClientSide) continue;
                BlockPos neighborPos = this.pos.offset(direction.getNormal());
                BlockState neighbor = this.getLevel().getBlockState(neighborPos);
                if (!(this instanceof EnergyTile) && this.getComp(Energy.class) == null || !(neighbor.getBlock() instanceof EntityBlock) || neighbor.getBlock() instanceof BlockTileEntity) continue;
                IEnergyStorage storage = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, neighborPos, (Object)ModUtils.getFacingFromTwoPositions(this.pos, neighborPos));
                BlockEntity blockEntity = this.getLevel().getBlockEntity(neighborPos);
                if (storage == null || blockEntity.isRemoved() || (energyTile = EnergyNetGlobal.instance.getTile(this.level, neighborPos)) != EnergyNetGlobal.EMPTY) continue;
                EnergyForge energyForge = null;
                if (storage.canExtract() && storage.canReceive()) {
                    energyForge = new EnergyForgeSinkSource(blockEntity);
                } else if (storage.canReceive()) {
                    energyForge = new EnergyForgeSink(blockEntity);
                } else if (storage.canExtract()) {
                    energyForge = new EnergyForgeSource(blockEntity);
                }
                if (energyForge == null) continue;
                NeoForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this.getWorld(), energyForge));
            }
            this.rerender();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void rerender() {
        BlockState state1 = this.blockState;
        this.blockState = null;
        BlockState state = this.getBlockState();
        if (state1 == null) {
            state1 = state;
        }
        if (this.isChunkLoaded(this.level, this.pos)) {
            this.getLevel().sendBlockUpdated(this.worldPosition, this.blockState, this.blockState, 2);
        }
    }

    public boolean isChunkLoaded(@org.jetbrains.annotations.Nullable Level world, @NotNull BlockPos pos) {
        return this.isChunkLoaded(world, SectionPos.blockToSectionCoord((int)pos.getX()), SectionPos.blockToSectionCoord((int)pos.getZ()));
    }

    public boolean isChunkLoaded(Level world, int chunkX, int chunkZ) {
        if (world == null) {
            return false;
        }
        if (world instanceof Level) {
            Level accessor = world;
            if (!accessor.isClientSide) {
                return accessor.hasChunk(chunkX, chunkZ);
            }
        }
        return world.getChunk(chunkX, chunkZ, ChunkStatus.FULL, false) != null;
    }

    public void onClicked(Player player) {
    }

    public void onNeighborChange(BlockState neighbor, BlockPos neighborPos) {
        if (this.componentList != null) {
            for (AbstractComponent component : this.componentList) {
                component.onNeighborChange(neighbor, neighborPos);
            }
        }
        if (!this.getLevel().isClientSide) {
            EnergyTile energyTile;
            if ((this instanceof EnergyTile || this.getComp(Energy.class) != null) && neighbor.getBlock() instanceof EntityBlock && !(neighbor.getBlock() instanceof BlockTileEntity)) {
                IEnergyStorage storage = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, neighborPos, (Object)ModUtils.getFacingFromTwoPositions(this.pos, neighborPos));
                BlockEntity blockEntity = this.getLevel().getBlockEntity(neighborPos);
                if (storage != null && !blockEntity.isRemoved()) {
                    EnergyTile energyTile2 = EnergyNetGlobal.instance.getTile(this.level, neighborPos);
                    EnergyForge energyForge = null;
                    if (storage.canExtract() && storage.canReceive()) {
                        energyForge = new EnergyForgeSinkSource(blockEntity);
                    } else if (storage.canReceive()) {
                        energyForge = new EnergyForgeSink(blockEntity);
                    } else if (storage.canExtract()) {
                        energyForge = new EnergyForgeSource(blockEntity);
                    }
                    if (energyForge != null) {
                        boolean changed = true;
                        if (energyTile2 != EnergyNetGlobal.EMPTY) {
                            changed = false;
                            Map<Direction, IEnergyStorage> newStorages = energyForge.getStorages();
                            Map<Direction, IEnergyStorage> oldStorages = ((EnergyForge)energyTile2).getStorages();
                            if (oldStorages == null) {
                                changed = true;
                            } else {
                                for (Direction dir : Direction.values()) {
                                    IEnergyStorage newS;
                                    IEnergyStorage oldS = oldStorages.get(dir);
                                    if (oldS == null != ((newS = newStorages.get(dir)) == null)) {
                                        changed = true;
                                        break;
                                    }
                                    if (oldS == null || newS == null || oldS.canReceive() == newS.canReceive() && oldS.canExtract() == newS.canExtract()) continue;
                                    changed = true;
                                    break;
                                }
                            }
                            if (changed) {
                                NeoForge.EVENT_BUS.post((Event)new EnergyTileUnLoadEvent(this.getWorld(), energyTile2));
                            }
                        }
                        if (changed) {
                            NeoForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this.getWorld(), energyForge));
                        }
                    }
                }
            } else if ((this instanceof EnergyTile || this.getComp(Energy.class) != null) && (energyTile = EnergyNetGlobal.instance.getTile(this.level, neighborPos)) != EnergyNetGlobal.EMPTY && energyTile instanceof EnergyForge) {
                NeoForge.EVENT_BUS.post((Event)new EnergyTileUnLoadEvent(this.getWorld(), energyTile));
            }
        }
    }

    public boolean hasSpecialModel() {
        return false;
    }

    public boolean canPlace(BlockEntityBase te, BlockPos pos, Level world, Direction direction, LivingEntity entity) {
        Direction facing = this.getPlacementFacing(entity, direction);
        byte temp = this.facing;
        this.facing = (byte)facing.ordinal();
        AABB aabb = this.getAabb(false).move(pos);
        int minX = Mth.floor((double)aabb.minX);
        int maxX = Mth.ceil((double)aabb.maxX);
        int minY = Mth.floor((double)aabb.minY);
        int maxY = Mth.ceil((double)aabb.maxY);
        int minZ = Mth.floor((double)aabb.minZ);
        int maxZ = Mth.ceil((double)aabb.maxZ);
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        for (int x = minX; x < maxX; ++x) {
            for (int y = minY; y < maxY; ++y) {
                for (int z = minZ; z < maxZ; ++z) {
                    checkPos.set(x, y, z);
                    BlockState state = world.getBlockState((BlockPos)checkPos);
                    if (state.isAir() || state.getCollisionShape((BlockGetter)world, (BlockPos)checkPos).isEmpty()) continue;
                    this.facing = temp;
                    return false;
                }
            }
        }
        this.facing = temp;
        return true;
    }

    public int getWeakPower(Direction side) {
        return 0;
    }

    public boolean canConnectRedstone() {
        return this.hasComponent(Redstone.class);
    }

    public boolean hasComponent(Class<? extends AbstractComponent> cls) {
        for (AbstractComponent component : this.componentList) {
            if (component.getClass() != cls) continue;
            return true;
        }
        return false;
    }

    public int getComparatorInputOverride() {
        return 0;
    }

    public int getLightOpacity() {
        return 0;
    }

    public int getLightValue() {
        return 0;
    }

    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        return false;
    }

    public CooldownTracker getCooldownTracker() {
        return this.cooldownTracker;
    }

    public CustomPacketBuffer writeUpdatePacket() {
        return new CustomPacketBuffer(this.getLevel().registryAccess());
    }

    public void readUpdatePacket(CustomPacketBuffer packetBuffer) {
    }

    public boolean needUpdate() {
        return false;
    }

    public CustomPacketBuffer writeContainerPacket() {
        return new CustomPacketBuffer(this.getWorld().registryAccess());
    }

    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
    }

    public void onNetworkUpdate(String field) {
        if (field.equals("active") || field.equals("facing")) {
            this.rerender();
        }
    }

    public boolean canEntityDestroy(Entity entity) {
        for (AbstractComponent component : this.componentList) {
            if (component.canEntityDestroy(entity)) continue;
            return false;
        }
        return true;
    }

    public List<AbstractComponent> getComponentList() {
        return this.componentList;
    }

    public List<ItemStack> getSelfDrops(int fortune, boolean wrench) {
        ItemStack drop = this.getPickBlock(null, null);
        if ((drop = this.adjustDrop(drop, wrench, fortune)) == null) {
            drop = ItemStack.EMPTY;
        }
        if (!drop.isEmpty()) {
            for (AbstractComponent component : this.componentList) {
                if (!component.needWriteNBTToDrops()) continue;
                CompoundTag tagCompound = ModUtils.nbt(drop);
                tagCompound.put(component.toString(), (Tag)component.writeNBTToDrops(new CompoundTag()));
            }
        }
        return Collections.singletonList(drop);
    }

    public boolean wrenchCanRemove(Player player) {
        for (AbstractComponent component : this.componentList) {
            if (component.wrenchCanRemove(player)) continue;
            return false;
        }
        return this.getTeBlock().getHarvestTool() == HarvestTool.Wrench;
    }

    public void onPlaced(ItemStack stack, LivingEntity placer, Direction facing) {
        Level world = this.getLevel();
        if ((facing = this.getPlacementFacing(placer, facing)) != this.getFacing()) {
            this.setFacing(facing);
        }
        if (world.isClientSide) {
            this.rerender();
        }
        for (AbstractComponent component : this.componentList) {
            if (component.needWriteNBTToDrops()) {
                CompoundTag tagCompound = ModUtils.nbt(stack);
                CompoundTag tag = tagCompound.getCompound(component.toString());
                component.readFromNbt(tag);
            }
            component.onPlaced(stack, placer, facing);
        }
    }

    public AABB getVisualBoundingBox() {
        return this.getAabb(false);
    }

    public AABB getPhysicsBoundingBox() {
        return this.getAabb(true);
    }

    public AABB getOutlineBoundingBox() {
        return this.getVisualBoundingBox();
    }

    public void addCollisionBoxesToList(AABB mask, List<AABB> list, Entity collidingEntity) {
        AABB maskNormalized = mask.move((double)(-this.worldPosition.getX()), (double)(-this.worldPosition.getY()), (double)(-this.worldPosition.getZ()));
        for (AABB aabb : this.getAabbs(true)) {
            if (!aabb.intersects(maskNormalized)) continue;
            list.add(aabb.move(this.worldPosition));
        }
    }

    public AABB getAabb(boolean forCollision) {
        List<AABB> aabbs = this.getAabbs(forCollision);
        if (aabbs.isEmpty()) {
            throw new RuntimeException("No AABBs for " + String.valueOf((Object)this));
        }
        if (aabbs.size() == 1) {
            return aabbs.get(0);
        }
        double zS = Double.POSITIVE_INFINITY;
        double yS = Double.POSITIVE_INFINITY;
        double xS = Double.POSITIVE_INFINITY;
        double zE = Double.NEGATIVE_INFINITY;
        double yE = Double.NEGATIVE_INFINITY;
        double xE = Double.NEGATIVE_INFINITY;
        for (AABB aabb : aabbs) {
            xS = Math.min(xS, aabb.minX);
            yS = Math.min(yS, aabb.minY);
            zS = Math.min(zS, aabb.minZ);
            xE = Math.max(xE, aabb.maxX);
            yE = Math.max(yE, aabb.maxY);
            zE = Math.max(zE, aabb.maxZ);
        }
        return new AABB(xS, yS, zS, xE, yE, zE);
    }

    public void onEntityCollision(Entity entity) {
    }

    private void validateBlockState(BlockState p_353132_) {
        if (!this.isValidBlockState(p_353132_)) {
            String var10002 = this.getNameForReporting();
            throw new IllegalStateException("Invalid block entity " + var10002 + " state at " + String.valueOf(this.worldPosition) + ", got " + String.valueOf(p_353132_));
        }
    }

    private String getNameForReporting() {
        String var10000 = String.valueOf(BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey((Object)this.getType()));
        return var10000 + " // " + ((Object)((Object)this)).getClass().getCanonicalName();
    }

    public BlockState getBlockState() {
        if (this.blockState == null) {
            try {
                this.blockState = (BlockState)((BlockState)this.block.defaultBlockState().setValue((Property)this.block.typeProperty, (Comparable)this.block.typeProperty.getState(this.teBlock, this.active))).setValue(this.block.facingProperty, (Comparable)this.getFacing());
            }
            catch (Exception e) {
                this.blockState = this.block.defaultBlockState();
            }
            return this.blockState;
        }
        return this.blockState;
    }

    @Deprecated
    public void setBlockState(BlockState p_155251_) {
        this.validateBlockState(p_155251_);
        this.blockState = p_155251_;
    }

    public abstract MultiBlockEntity getTeBlock();

    public abstract BlockTileEntity getBlock();

    public int hashCode() {
        if (!this.hasHashCode) {
            this.hasHashCode = true;
            this.hashCode = super.hashCode();
        }
        return this.hashCode;
    }

    public <T extends AbstractComponent> T getComp(String cls) {
        for (AbstractComponent component : this.componentList) {
            if (!component.toString().trim().equals(cls)) continue;
            return (T)component;
        }
        return null;
    }

    public ItemStack getItem(Player player, HitResult target) {
        return this.block.getItemStack();
    }

    public Set<Direction> getSupportedFacings() {
        return this.teBlock.getSupportedFacings();
    }

    public List<AABB> getAabbs(boolean forCollision) {
        return defaultAabbs;
    }

    public ItemStack adjustDrop(ItemStack drop, boolean wrench) {
        return this.adjustDrop(drop, wrench, WorldBaseGen.random.nextInt(100));
    }

    public Iterable<? extends AbstractComponent> getComps() {
        return this.componentList;
    }

    public <T> T getCapability(@NotNull BlockCapability<T, Direction> cap, @org.jetbrains.annotations.Nullable Direction side) {
        if (this.capabilityComponents == null) {
            return null;
        }
        AbstractComponent comp = this.capabilityComponents.get(cap);
        return comp == null ? null : (T)comp.getCapability(cap, side);
    }

    public void onExploded(Explosion explosion) {
    }

    public <T extends AbstractComponent> T addComponent(T component) {
        if (component == null) {
            throw new NullPointerException("null component");
        }
        this.componentList.add(component);
        this.advComponentMap.put(component.toString(), component);
        if (component.isClient()) {
            this.updateClientList.add(component);
        }
        if (component.isServer()) {
            this.updateServerList.add(component);
        }
        for (BlockCapability<?, ?> capability : component.getProvidedCapabilities(null)) {
            this.addComponentCapability(capability, component);
        }
        return component;
    }

    public <T extends AbstractComponent> void removeComponent(T component) {
        if (component == null) {
            throw new NullPointerException("null component");
        }
        this.componentList.remove(component);
        this.advComponentMap.remove(component.toString(), component);
        if (component.isClient()) {
            this.updateClientList.remove(component);
        }
        if (component.isServer()) {
            this.updateServerList.remove(component);
        }
        for (BlockCapability<?, ?> capability : component.getProvidedCapabilities(null)) {
            this.removeComponentCapability(capability, component);
        }
    }

    public void addComponentCapability(BlockCapability<?, ?> cap, AbstractComponent component) {
        if (this.capabilityComponents == null) {
            this.capabilityComponents = new IdentityHashMap();
        }
        AbstractComponent prev = this.capabilityComponents.put(cap, component);
        assert (prev == null);
    }

    public void removeComponentCapability(BlockCapability<?, ?> cap, AbstractComponent component) {
        if (this.capabilityComponents == null) {
            this.capabilityComponents = new IdentityHashMap();
        }
        this.capabilityComponents.remove(cap, component);
    }

    public void onChunkUnloaded() {
        if (this.loaded) {
            this.onUnloaded();
        }
        super.onChunkUnloaded();
    }

    public void onUnloaded() {
        if (this.needUpdate()) {
            IUCore.network.getServer().removeTileToOvertimeUpdate(this);
        }
        this.componentList.forEach(AbstractComponent::onUnloaded);
        try {
            new PacketStopSound(this.getWorld(), this.getBlockPos());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.getLevel().isClientSide) {
            // empty if block
        }
    }

    public boolean onSneakingActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        for (AbstractComponent component : this.componentList) {
            if (!component.onSneakingActivated(player, hand)) continue;
            return true;
        }
        return this.getLevel().isClientSide;
    }

    public Map<BlockCapability<?, ?>, AbstractComponent> getCapabilityComponents() {
        return this.capabilityComponents;
    }

    public void onBlockBreak(boolean wrench) {
        for (AbstractComponent component : this.componentList) {
            component.blockBreak();
        }
    }

    public void wrenchBreak() {
        this.onBlockBreak(true);
    }

    public boolean onRemovedByPlayer(Player player, boolean willHarvest) {
        return true;
    }

    public ItemStack getPickBlock(Player player, HitResult target) {
        return this.block.getItemStack();
    }

    public List<ItemStack> getAuxDrops(int fortune) {
        return Collections.emptyList();
    }

    public float getHardness() {
        return this.teBlock.getHardness();
    }

    public boolean getActive() {
        return this.active.contains("active");
    }

    public void setActive(String active) {
        if (this.active.equals(active)) {
            return;
        }
        if (!this.isChunkLoaded(this.level, this.pos)) {
            return;
        }
        this.active = active;
        if (!this.getLevel().isClientSide) {
            new PacketUpdateFieldTile(this, "active", this.active);
        }
        this.getWorld().setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)this.block.typeProperty, (Comparable)this.block.typeProperty.getState(this.teBlock, this.active)), 3);
    }

    public void setActive(boolean active) {
        if (!active && this.active.equals("")) {
            return;
        }
        if (active) {
            if (!this.active.equals("active")) {
                this.active = "active";
                if (!this.getLevel().isClientSide) {
                    new PacketUpdateFieldTile(this, "active", this.active);
                }
            }
        } else {
            this.active = "";
            if (!this.getLevel().isClientSide) {
                new PacketUpdateFieldTile(this, "active", this.active);
            }
        }
        if (!this.isChunkLoaded(this.level, this.pos)) {
            return;
        }
        this.getWorld().setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)this.block.typeProperty, (Comparable)this.block.typeProperty.getState(this.teBlock, this.active)), 3);
    }

    public Direction getFacing() {
        return Direction.values()[this.facing];
    }

    public void setFacing(Direction facing) {
        if (facing == null) {
            throw new NullPointerException("null facing");
        }
        if (this.facing == facing.ordinal()) {
            return;
        }
        if (!this.getSupportedFacings().contains(facing)) {
            return;
        }
        this.facing = (byte)facing.ordinal();
        if (!this.getLevel().isClientSide) {
            new PacketUpdateFieldTile(this, "facing", this.facing);
        }
        if (!this.isChunkLoaded(this.level, this.pos)) {
            return;
        }
        this.getWorld().setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue(this.block.facingProperty, (Comparable)this.getFacing()), 3);
    }

    public boolean canSetFacingWrench(Direction facing, Player player) {
        if (!this.teBlock.allowWrenchRotating()) {
            return false;
        }
        if (facing == this.getFacing()) {
            return false;
        }
        this.setFacing(facing);
        return this.getSupportedFacings().contains(facing);
    }

    public boolean setFacingWrench(Direction facing, Player player) {
        if (!this.canSetFacingWrench(facing, player)) {
            return false;
        }
        this.setFacing(facing);
        return true;
    }

    public List<ItemStack> getWrenchDrops(Player player, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.addAll(this.getSelfDrops(fortune, true));
        ret.addAll(this.getAuxDrops(fortune));
        return ret;
    }

    public SoundType getBlockSound(Entity entity) {
        return SoundType.STONE;
    }

    public Direction getPlacementFacing(LivingEntity placer, Direction facing) {
        Set<Direction> supportedFacings = this.getSupportedFacings();
        if (supportedFacings.isEmpty()) {
            return Direction.DOWN;
        }
        if (placer != null) {
            Vec3 dir = placer.getLookAngle();
            Direction bestFacing = null;
            double maxMatch = Double.NEGATIVE_INFINITY;
            for (Direction cFacing : supportedFacings) {
                double match = dir.dot(Vec3.atLowerCornerOf((Vec3i)cFacing.getOpposite().getNormal()));
                if (!(match > maxMatch)) continue;
                maxMatch = match;
                bestFacing = cFacing;
            }
            return bestFacing;
        }
        return facing != null && supportedFacings.contains(facing.getOpposite()) ? facing.getOpposite() : this.getSupportedFacings().iterator().next();
    }

    public ItemStack adjustDrop(ItemStack drop, boolean wrench, int fortune) {
        block14: {
            block13: {
                if (wrench) break block13;
                switch (this.teBlock.getDefaultDrop()) {
                    default: {
                        drop = this.getPickBlock(null, null);
                        break block14;
                    }
                    case Generator: {
                        drop = new ItemStack(IUItem.basemachine2.getItem(78), 1);
                        break block14;
                    }
                    case None: {
                        drop = null;
                        break block14;
                    }
                    case Machine: {
                        return IUItem.blockResource.getItemStack(BlockResource.Type.machine);
                    }
                    case AdvMachine: {
                        return IUItem.blockResource.getItemStack(BlockResource.Type.advanced_machine);
                    }
                }
            }
            switch (this.teBlock.getDefaultDrop()) {
                default: {
                    drop = this.getPickBlock(null, null);
                    break;
                }
                case Generator: {
                    if (fortune >= 2) break;
                    drop = new ItemStack(IUItem.basemachine2.getItem(78), 1);
                    break;
                }
                case None: {
                    drop = null;
                    break;
                }
                case Machine: {
                    if (fortune < 2) {
                        return IUItem.blockResource.getItemStack(BlockResource.Type.machine);
                    }
                }
                case AdvMachine: {
                    if (fortune >= 2) break;
                    return IUItem.blockResource.getItemStack(BlockResource.Type.advanced_machine);
                }
            }
        }
        return drop;
    }

    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = new CustomPacketBuffer(this.getLevel().registryAccess());
        packet.writeShort(this.teBlock.getIDBlock());
        packet.writeString(this.active);
        packet.writeByte(this.facing);
        return packet;
    }

    public CompoundTag getNBTFromSlot(CustomPacketBuffer customPacketBuffer) {
        try {
            Inventory slot = (Inventory)DecoderHandler.decode(customPacketBuffer);
            return slot.writeToNbt(new CompoundTag(), (HolderLookup.Provider)customPacketBuffer.registryAccess());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void updateField(String name, CustomPacketBuffer is) {
        if (name.equals("active")) {
            try {
                this.active = (String)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("facing")) {
            is.readUnsignedByte();
            this.facing = is.readByte();
        }
        this.onNetworkUpdate(name);
    }

    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        this.active = customPacketBuffer.readString();
        this.facing = customPacketBuffer.readByte();
        this.rerender();
    }

    public boolean doesSideBlockRendering(Direction side) {
        return BlockEntityBase.checkSide(this.getAabbs(false), side, false);
    }

    public <T extends AbstractComponent> T getComp(Class<T> cls) {
        for (AbstractComponent component : this.componentList) {
            if (component.getClass() != cls) continue;
            return (T)component;
        }
        return null;
    }
}

