/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.base;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.energy.networking.EnergyNetGlobal;
import com.denfop.api.otherenergies.common.EnergyType;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blockentity.base.BlockEntityElectricMachine;
import com.denfop.blockentity.base.FakePlayerSpawner;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.containermenu.ContainerMenuAutoSpawner;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.inventory.InventoryModules;
import com.denfop.inventory.InventoryUpgradeModule;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.screen.ScreenAutoSpawner;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.utils.Keyboard;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BlockEntityAutoSpawner
extends BlockEntityElectricMachine
implements IUpgradableBlock {
    public final InventoryModules module_slot;
    public final double[] maxprogress;
    public final InventoryUpgradeModule module_upgrade;
    public final int tempcostenergy;
    public final double maxEnergy2;
    public final int defaultconsume;
    public final ComponentBaseEnergy exp;
    private final SoilPollutionComponent pollutionSoil;
    private final AirPollutionComponent pollutionAir;
    public int[] progress;
    public int costenergy = 1500;
    public int[] tempprogress;
    public FakePlayerSpawner player;
    public double energy2;
    public int speed = 0;
    public int chance = 0;
    public int spawn = 1;
    public int experience = 0;
    public LivingEntity[] mobUtils = new LivingEntity[4];
    public String[] description_mobs = new String[4];
    public LootTable[] loot_Tables = new LootTable[4];
    public LootParams.Builder[] lootContext = new LootParams.Builder[4];
    public int fireAspect;

    public BlockEntityAutoSpawner(BlockPos pos, BlockState state) {
        super(150000.0, 14, 27, BlockBaseMachine3Entity.spawner, pos, state);
        this.module_slot = new InventoryModules(this);
        this.module_upgrade = new InventoryUpgradeModule(this);
        this.progress = new int[this.module_slot.size()];
        this.maxEnergy2 = 200000.0;
        this.maxprogress = new double[4];
        this.tempprogress = new int[]{100, 100, 100, 100};
        this.tempcostenergy = 1500;
        this.defaultconsume = this.costenergy;
        this.exp = this.addComponent(ComponentBaseEnergy.asBasicSource(EnergyType.EXPERIENCE, this, 15000.0, 14));
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.1));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.1));
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachine3Entity.spawner;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public int getContainerSize() {
        return super.getContainerSize();
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("iu.machines_work_energy") + this.defaultconsume + Localization.translate("iu.machines_work_energy_type_eu"));
        }
        super.addInformation(stack, tooltip);
    }

    public int receiveEnergy(int paramInt, boolean paramBoolean) {
        int i = (int)Math.min(this.maxEnergy2 - this.energy2, Math.min(EnergyNetGlobal.instance.getPowerFromTier(this.energy.getSinkTier()) * 4.0, (double)paramInt));
        if (!paramBoolean) {
            this.energy2 += (double)i;
        }
        return i;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.progress = (int[])DecoderHandler.decode(customPacketBuffer);
            this.energy2 = (Double)DecoderHandler.decode(customPacketBuffer);
            this.tempprogress = (int[])DecoderHandler.decode(customPacketBuffer);
            this.description_mobs = (String[])DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.progress);
            EncoderHandler.encode(packet, this.energy2);
            EncoderHandler.encode(packet, this.tempprogress);
            EncoderHandler.encode(packet, this.description_mobs);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.level.isClientSide) {
            this.player = new FakePlayerSpawner(this.getWorld());
        }
        this.module_slot.update();
        this.module_upgrade.update();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenAutoSpawner((ContainerMenuAutoSpawner)menu);
    }

    public ContainerMenuAutoSpawner getGuiContainer(Player entityPlayer) {
        return new ContainerMenuAutoSpawner(entityPlayer, this);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.level.getGameTime() % 20L == 0L && !this.outputSlot.isEmpty()) {
            ModUtils.tick(this.outputSlot, this);
        }
        boolean active = false;
        for (int i = 0; i < this.module_slot.size(); ++i) {
            if (this.module_slot.get(i).isEmpty()) continue;
            if (this.energy.getEnergy() >= (double)this.costenergy || this.energy2 >= (double)(this.costenergy * 4)) {
                int n = i;
                this.progress[n] = this.progress[n] + 1;
                active = true;
                if (this.energy.getEnergy() >= (double)this.costenergy) {
                    this.energy.useEnergy(this.costenergy);
                } else {
                    this.energy2 -= (double)(this.costenergy * 4);
                }
            }
            this.tempprogress[i] = (int)(this.maxprogress[i] - this.maxprogress[i] * (double)this.speed / 100.0);
            this.tempprogress[i] = Math.max(1, this.tempprogress[i]);
            if (this.progress[i] < this.tempprogress[i]) continue;
            this.progress[i] = 0;
            if (this.mobUtils[i] == null) continue;
            LivingEntity entity = this.mobUtils[i];
            this.dropItemFromEntity(entity, this.player.damageSources().playerAttack((Player)this.player), this.loot_Tables[i], i);
            int exp = Math.max(entity.getExperienceReward((ServerLevel)this.level, (Entity)entity), 1);
            this.exp.addEnergy((double)exp + (double)(this.experience * exp) / 100.0);
        }
        if (this.getActive() && !active) {
            this.setActive(active);
        } else if (!this.getActive() && active) {
            this.setActive(active);
        }
    }

    private void dropItemFromEntity(LivingEntity entity, DamageSource source, LootTable table, int index) {
        if (!(entity instanceof WitherBoss || entity instanceof EnderDragon || this.level.isClientSide)) {
            int i = this.chance;
            try {
                LootParams.Builder lootcontext$builder = this.lootContext[index];
                if (table == null) {
                    return;
                }
                if (lootcontext$builder == null) {
                    lootcontext$builder = this.lootContext[index] = new LootParams.Builder((ServerLevel)this.level).withParameter(LootContextParams.THIS_ENTITY, (Object)entity).withParameter(LootContextParams.ATTACKING_ENTITY, (Object)this.player).withParameter(LootContextParams.LAST_DAMAGE_PLAYER, (Object)this.player).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)source).withParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)entity).withLuck((float)i).withParameter(LootContextParams.ORIGIN, (Object)new Vec3((double)this.pos.getX(), (double)this.pos.getY(), (double)this.pos.getZ()));
                }
                LootParams context = lootcontext$builder.create(LootContextParamSets.ENTITY);
                ArrayList list = Lists.newArrayList();
                for (int j = 0; j < this.spawn; ++j) {
                    table.getRandomItems(context, list::add);
                }
                for (ItemStack item : list) {
                    MachineRecipe recipe;
                    ItemStack smelt = ItemStack.EMPTY;
                    if (this.fireAspect > 0 && (recipe = Recipes.recipes.getRecipeMachineMultiOutput(Recipes.recipes.getRecipe("furnace"), Recipes.recipes.getRecipeList("furnace"), false, Collections.singletonList(item))) != null) {
                        smelt = recipe.getRecipe().output.items.get(0).copy();
                        smelt.setCount(item.getCount());
                    }
                    if (smelt.isEmpty()) {
                        this.outputSlot.add(item);
                        continue;
                    }
                    this.outputSlot.add(smelt);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.putDouble("energy2", this.energy2);
        for (int i = 0; i < 4; ++i) {
            nbttagcompound.putInt("progress" + i, this.progress[i]);
        }
        return nbttagcompound;
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        for (int i = 0; i < 4; ++i) {
            this.progress[i] = nbttagcompound.getInt("progress" + i);
        }
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.ItemExtract);
    }

    @Override
    public SoundEvent getSound() {
        return null;
    }
}

