/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.windsystem.upgrade;

import com.denfop.api.windsystem.upgrade.EnumInfoRotorUpgradeModules;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public class RotorUpgradeItemInform {
    public static final Codec<RotorUpgradeItemInform> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.xmap(EnumInfoRotorUpgradeModules::valueOf, Enum::name).fieldOf("upgrade").forGetter(obj -> obj.upgrade), (App)Codec.INT.fieldOf("number").forGetter(obj -> obj.number)).apply((Applicative)instance, RotorUpgradeItemInform::new));
    public static final StreamCodec<FriendlyByteBuf, RotorUpgradeItemInform> STREAM_CODEC = StreamCodec.of((buf, value) -> {
        buf.writeEnum((Enum)value.upgrade);
        buf.writeInt(value.number);
    }, buf -> new RotorUpgradeItemInform((EnumInfoRotorUpgradeModules)buf.readEnum(EnumInfoRotorUpgradeModules.class), buf.readInt()));
    public final EnumInfoRotorUpgradeModules upgrade;
    public int number;

    public RotorUpgradeItemInform(EnumInfoRotorUpgradeModules modules, int number) {
        this.upgrade = modules;
        this.number = number;
    }

    public boolean matched(EnumInfoRotorUpgradeModules modules) {
        return this.upgrade.name.equals(modules.name);
    }

    public int getInformation(EnumInfoRotorUpgradeModules modules) {
        if (this.upgrade.name.equals(modules.name)) {
            return this.number;
        }
        return 0;
    }

    public String getName() {
        switch (this.upgrade) {
            case STRENGTH_I: 
            case STRENGTH_II: 
            case STRENGTH_III: {
                return String.valueOf(ChatFormatting.YELLOW) + Localization.translate("wind.strength_info") + String.valueOf(ChatFormatting.GREEN) + ModUtils.getString(this.upgrade.getCoef() * (double)this.number * 100.0) + "%";
            }
            case POWER_I: 
            case POWER_II: 
            case POWER_III: {
                return String.valueOf(ChatFormatting.AQUA) + Localization.translate("wind.power_info") + String.valueOf(ChatFormatting.GREEN) + ModUtils.getString(this.upgrade.getCoef() * (double)this.number * 100.0) + "%";
            }
            case EFFICIENCY_I: 
            case EFFICIENCY_II: 
            case EFFICIENCY_III: {
                return String.valueOf(ChatFormatting.GOLD) + Localization.translate("wind.efficiency_info") + String.valueOf(ChatFormatting.GREEN) + ModUtils.getString(this.upgrade.getCoef() * (double)this.number * 100.0) + "%";
            }
            case AUTO: {
                return String.valueOf(ChatFormatting.LIGHT_PURPLE) + Localization.translate("wind.auto_info");
            }
            case MIN: {
                return String.valueOf(ChatFormatting.RED) + Localization.translate("wind.min_info");
            }
            case WIND_I: 
            case WIND_II: 
            case WIND_III: {
                return String.valueOf(ChatFormatting.BLUE) + Localization.translate("wind.wind_speed_info") + String.valueOf(ChatFormatting.GREEN) + (int)this.upgrade.getCoef() + " m/s";
            }
            case WIND_POWER_II: 
            case WIND_POWER_I: 
            case WIND_POWER_III: {
                return String.valueOf(ChatFormatting.DARK_AQUA) + Localization.translate("wind.wind_power_info") + String.valueOf(ChatFormatting.GREEN) + (int)this.upgrade.getCoef();
            }
            case REPAIR_II: 
            case REPAIR_I: 
            case REPAIR_III: {
                return String.valueOf(ChatFormatting.DARK_PURPLE) + Localization.translate("wind.rotor_repair_info") + String.valueOf(ChatFormatting.GREEN) + (int)this.upgrade.getCoef() + " " + Localization.translate("iu.seconds");
            }
        }
        return "";
    }
}

