/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.windsystem.upgrade;

import com.denfop.api.widget.EnumTypeSlot;
import com.denfop.api.widget.ITypeSlot;
import com.denfop.api.windsystem.InventoryUpgrade;
import com.denfop.inventory.Inventory;
import com.denfop.items.ItemWindRotor;
import com.denfop.network.IUpdatableTileEvent;
import net.minecraft.world.item.ItemStack;

public class InventoryRotor
extends Inventory
implements ITypeSlot {
    private final InventoryUpgrade slotUpgrade;

    public InventoryRotor(InventoryUpgrade slotUpgrade) {
        super(slotUpgrade.base, Inventory.TypeItemSlot.INPUT, 1);
        this.setStackSizeLimit(1);
        this.slotUpgrade = slotUpgrade;
    }

    @Override
    public EnumTypeSlot getTypeSlot() {
        return EnumTypeSlot.ROTOR;
    }

    @Override
    public boolean canShift() {
        return false;
    }

    @Override
    public boolean canPlaceItem(int index, ItemStack stack) {
        return stack.getItem() instanceof ItemWindRotor;
    }

    @Override
    public ItemStack set(int index, ItemStack content) {
        if (content.isEmpty() && !((ItemStack)this.contents.get(index)).isEmpty()) {
            ((IUpdatableTileEvent)((Object)this.slotUpgrade.base)).updateTileServer(null, 0.0);
        }
        super.set(index, content);
        if (content.isEmpty()) {
            this.slotUpgrade.update();
        }
        if (!content.isEmpty()) {
            this.slotUpgrade.update(content);
        }
        return content;
    }
}

