/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.widget;

import com.denfop.api.widget.ButtonListSliderWidget;
import com.denfop.api.widget.ScrollDirection;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.utils.Localization;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SliderWidget
extends AbstractWidget {
    protected static final ResourceLocation TEXTURES = ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/slider.png");
    private final String name;
    private final float min;
    private final float max;
    private final int id;
    public boolean isMouseDown;
    public ButtonListSliderWidget.GuiResponder responder;
    public FormatHelper formatHelper;
    private String displayString1;
    private float sliderPosition = 1.0f;

    public SliderWidget(ButtonListSliderWidget.GuiResponder p_i45541_1_, int p_i45541_2_, int p_i45541_3_, int p_i45541_4_, String p_i45541_5_, float p_i45541_6_, float p_i45541_7_, float p_i45541_8_, FormatHelper p_i45541_9_) {
        super(p_i45541_3_, p_i45541_4_, 150, 1, (Component)Component.literal((String)""));
        this.id = p_i45541_2_;
        this.name = p_i45541_5_;
        this.min = p_i45541_6_;
        this.max = p_i45541_7_;
        this.sliderPosition = (p_i45541_8_ - p_i45541_6_) / (p_i45541_7_ - p_i45541_6_);
        this.formatHelper = p_i45541_9_;
        this.responder = p_i45541_1_;
        this.displayString1 = this.getDisplayString();
    }

    public SliderWidget(ButtonListSliderWidget.GuiResponder p_i45541_1_, int p_i45541_2_, int p_i45541_3_, int p_i45541_4_, String p_i45541_5_, float p_i45541_6_, float p_i45541_7_, float p_i45541_8_, FormatHelper p_i45541_9_, int width) {
        super(p_i45541_3_, p_i45541_4_, width, 1, (Component)Component.literal((String)""));
        this.id = p_i45541_2_;
        this.name = p_i45541_5_;
        this.min = p_i45541_6_;
        this.max = p_i45541_7_;
        this.sliderPosition = (p_i45541_8_ - p_i45541_6_) / (p_i45541_7_ - p_i45541_6_);
        this.formatHelper = p_i45541_9_;
        this.responder = p_i45541_1_;
        this.displayString1 = this.getDisplayString();
    }

    public float getSliderValue() {
        return this.min + (this.max - this.min) * this.sliderPosition;
    }

    public void setSliderValue(float p_175218_1_, boolean p_175218_2_) {
        this.sliderPosition = (p_175218_1_ - this.min) / (this.max - this.min);
        this.displayString1 = this.getDisplayString();
        if (p_175218_2_) {
            this.responder.setEntryValue(this.id, this.getSliderValue());
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.add(NarratedElementType.TITLE, this.getDisplayString());
    }

    public float getSliderPosition() {
        return this.sliderPosition;
    }

    public void setSliderPosition(float p_175219_1_) {
        this.sliderPosition = p_175219_1_;
        this.displayString1 = this.getDisplayString();
        this.responder.setEntryValue(this.id, this.getSliderValue());
    }

    private String getDisplayString() {
        return this.formatHelper == null ? Localization.translate(this.name, new Object[0]) + ": " + this.getSliderValue() : this.formatHelper.getText(this.id, Localization.translate(this.name, new Object[0]), this.getSliderValue());
    }

    protected int getHoverState(boolean p_146114_1_) {
        return 0;
    }

    public boolean mouseDragged(double p_146119_2_, double p_146119_3_, int button, double dragX, double dragY) {
        if (this.visible) {
            if (this.isMouseDown && this.isMouseOver(this.getX(), p_146119_3_)) {
                this.updateSliderPosition(p_146119_2_);
                this.displayString1 = this.getDisplayString();
                this.responder.setEntryValue(this.id, this.getSliderValue());
                return true;
            }
            return false;
        }
        return false;
    }

    private void updateSliderPosition(double mouseX) {
        this.sliderPosition = (float)(mouseX - (double)(this.getX() + 4)) / (float)(this.width - 8);
        if (this.sliderPosition < 0.0f) {
            this.sliderPosition = 0.0f;
        }
        if (this.sliderPosition > 1.0f) {
            this.sliderPosition = 1.0f;
        }
        this.responder.setEntryValue(this.id, Math.round(this.getSliderValue()));
    }

    protected void renderWidget(GuiGraphics guiGraphics, int i, int i1, float v) {
        ScreenIndustrialUpgrade.bindTexture(TEXTURES);
        guiGraphics.blit(ScreenIndustrialUpgrade.currentTexture, this.getX(), this.getY(), 0, 255, this.width, 1);
        guiGraphics.blit(ScreenIndustrialUpgrade.currentTexture, this.getX(), this.getY() - 2, 6, 13, 1, 4);
        guiGraphics.blit(ScreenIndustrialUpgrade.currentTexture, this.getX() + this.width - 1, this.getY() - 2, 6, 13, 1, 4);
        guiGraphics.blit(ScreenIndustrialUpgrade.currentTexture, this.getX() + this.width / 2, this.getY() - 2, 6, 13, 1, 4);
        for (int x = this.getX() + this.width / 4; x < this.getX() + this.width - 1; x += this.width / 4) {
            guiGraphics.blit(ScreenIndustrialUpgrade.currentTexture, x + 1, this.getY() - 1, 9, 14, 1, 3);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(ScreenIndustrialUpgrade.currentTexture, this.getX() + (int)(this.sliderPosition * (float)(this.width - 3)), this.getY() - 2, 12, 13, 3, 5);
        int j = 0xE0E0E0;
        if (this.packedFGColor != 0) {
            j = this.packedFGColor;
        } else if (!this.active) {
            j = 0xA0A0A0;
        } else if (this.isHovered) {
            j = 0xFFFFA0;
        }
        guiGraphics.drawCenteredString(Minecraft.getInstance().font, this.getDisplayString(), this.getX() + this.width / 2, this.getY() + -3 - 8, j);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOver(mouseX, mouseY)) {
            this.isMouseDown = true;
            this.updateSliderPosition(mouseX);
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.isMouseDown = false;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    private boolean isMouseOver(int mouseX, int mouseY) {
        return mouseX >= this.getX() - 4 && mouseX < this.getX() + 4 + this.width && mouseY >= this.getY() - 4 && mouseY < this.getY() + 8 + this.height;
    }

    public boolean handleMouseWheel(ScrollDirection direction, int mouseX, int mouseY) {
        if (this.visible && this.active && this.isMouseOver(mouseX, mouseY)) {
            float step = 1.0f / (this.max - this.min);
            this.sliderPosition += direction == ScrollDirection.down ? step : -step;
            if (this.sliderPosition < 0.0f) {
                this.sliderPosition = 0.0f;
            }
            if (this.sliderPosition > 1.0f) {
                this.sliderPosition = 1.0f;
            }
            this.displayString1 = this.getDisplayString();
            this.responder.setEntryValue(this.id, Math.round(this.getSliderValue()));
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface FormatHelper {
        public String getText(int var1, String var2, float var3);
    }
}

