/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.widget;

import com.denfop.api.widget.ScreenWidget;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.utils.ModUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.ItemStack;

public class ItemStackWidget
extends ScreenWidget {
    private final Supplier<ItemStack> itemSupplier;

    public ItemStackWidget(ScreenIndustrialUpgrade<?> gui, int x, int y, Supplier<ItemStack> itemSupplier) {
        super(gui, x, y, 16, 16);
        this.itemSupplier = itemSupplier;
    }

    @Override
    public void drawBackground(GuiGraphics poseStack, int mouseX, int mouseY) {
        if (!this.visible()) {
            return;
        }
        super.drawBackground(poseStack, mouseX, mouseY);
        ItemStack stack = this.itemSupplier.get();
        if (!ModUtils.isEmpty(stack)) {
            RenderSystem.enableBlend();
            this.gui.drawItemStack(poseStack, this.x, this.y, stack);
            RenderSystem.disableBlend();
        }
    }

    @Override
    public void drawForeground(GuiGraphics poseStack, int mouseX, int mouseY) {
        ItemStack stack;
        if (!this.visible()) {
            return;
        }
        if (this.contains(mouseX, mouseY) && !ModUtils.isEmpty(stack = this.itemSupplier.get())) {
            this.gui.drawTooltip(poseStack, mouseX, mouseY, stack);
        }
    }
}

