/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.widget;

import com.denfop.api.widget.EmptyWidget;
import com.denfop.api.widget.EnumTypeComponent;
import com.denfop.api.widget.MouseButton;
import com.denfop.api.widget.ScreenWidget;
import com.denfop.api.widget.WidgetDefault;
import com.denfop.blockentity.base.BlockEntityBase;
import com.denfop.network.packet.PacketUpdateServerTile;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.utils.ModUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;

public class ButtonWidget
extends ScreenWidget {
    private final EnumTypeComponent type;
    private final String text;
    private final int event;
    private final BlockEntityBase tile;
    private final int x1;
    private final int y1;
    public boolean highlighted = false;
    protected boolean hasHighlighted = true;

    public ButtonWidget(ScreenIndustrialUpgrade gui, int x, int y, int x1, int y1, BlockEntityBase entityBlock, int event, String text) {
        super(gui, x, y, EnumTypeComponent.BUTTON.getWeight(), EnumTypeComponent.BUTTON.getHeight(), new WidgetDefault<EmptyWidget>(new EmptyWidget()));
        this.text = text;
        this.event = event;
        this.tile = entityBlock;
        this.type = EnumTypeComponent.BUTTON;
        this.x1 = x1;
        this.y1 = y1;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public boolean contains(int x, int y) {
        return x >= this.x && x <= this.x + this.x1 && y >= this.y && y <= this.y + this.y1;
    }

    @Override
    public void drawForeground(GuiGraphics poseStack, int mouseX, int mouseY) {
        super.drawForeground(poseStack, mouseX, mouseY);
        if (this.hasHighlighted) {
            this.highlighted = this.contains(mouseX, mouseY);
        }
    }

    @Override
    protected List<String> getToolTip() {
        return Collections.singletonList(this.getText());
    }

    @Override
    public void drawBackground(GuiGraphics poseStack, int mouseX, int mouseY) {
        if (this.visible()) {
            if (this.highlighted) {
                ButtonWidget.bindCommonTexture2();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mouseX = this.gui.guiLeft();
                mouseY = this.gui.guiTop();
                this.getGui().drawTexturedModalRect(poseStack, mouseX + this.getX(), mouseY + this.getY(), 1, 97, Math.min(199, this.x1 - 1), 2);
                this.getGui().drawTexturedModalRect(poseStack, mouseX + this.getX() + this.x1 - 5, mouseY + this.getY(), 197, 97, 6, 2);
                int height = this.y1 - 4;
                int modulo = height % 16;
                if (height / 16 > 0) {
                    for (int i = mouseY + this.getY() + 2; i < mouseY + this.getY() + this.y1 - 2; i += 16) {
                        this.getGui().drawTexturedModalRect(poseStack, mouseX + this.getX(), i, 1, 99, Math.min(199, this.x1 - 1), 16);
                        this.getGui().drawTexturedModalRect(poseStack, mouseX + this.getX() + this.x1 - 5, i, 197, 99, 6, 16);
                    }
                }
                this.getGui().drawTexturedModalRect(poseStack, mouseX + this.getX(), mouseY + this.getY() + 2 + height / 16, 1, 99, Math.min(199, this.x1 - 1), modulo);
                this.getGui().drawTexturedModalRect(poseStack, mouseX + this.getX() + this.x1 - 5, mouseY + this.getY() + 2, 197, 99, 6, modulo);
                this.getGui().drawTexturedModalRect(poseStack, mouseX + this.getX(), mouseY + this.getY() + this.y1 - 2, 1, 116, Math.min(199, this.x1 - 1), 2);
                this.getGui().drawTexturedModalRect(poseStack, mouseX + this.getX() + this.x1 - 5, mouseY + this.getY() + this.y1 - 2, 197, 116, 6, 2);
            } else {
                ButtonWidget.bindCommonTexture2();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mouseX = this.gui.guiLeft();
                mouseY = this.gui.guiTop();
                this.getGui().drawTexturedModalRect(poseStack, mouseX + this.getX(), mouseY + this.getY(), 1, 75, Math.min(199, this.x1 - 1), 2);
                this.getGui().drawTexturedModalRect(poseStack, mouseX + this.getX() + this.x1 - 5, mouseY + this.getY(), 197, 75, 6, 2);
                int height = this.y1 - 4;
                int modulo = height % 16;
                if (height / 16 > 0) {
                    for (int i = mouseY + this.getY() + 2; i < mouseY + this.getY() + this.y1 - 2; i += 16) {
                        this.getGui().drawTexturedModalRect(poseStack, mouseX + this.getX(), i, 1, 77, Math.min(199, this.x1 - 1), 16);
                        this.getGui().drawTexturedModalRect(poseStack, mouseX + this.getX() + this.x1 - 5, i, 197, 77, 6, 16);
                    }
                }
                if (modulo > 0) {
                    this.getGui().drawTexturedModalRect(poseStack, mouseX + this.getX(), mouseY + this.getY() + 2 + height / 16, 1, 77, Math.min(199, this.x1 - 1), modulo);
                    this.getGui().drawTexturedModalRect(poseStack, mouseX + this.getX() + this.x1 - 5, mouseY + this.getY() + 2, 197, 77, 6, modulo);
                }
                this.getGui().drawTexturedModalRect(poseStack, mouseX + this.getX(), mouseY + this.getY() + this.y1 - 2, 1, 94, Math.min(199, this.x1 - 1), 2);
                this.getGui().drawTexturedModalRect(poseStack, mouseX + this.getX() + this.x1 - 5, mouseY + this.getY() + this.y1 - 2, 197, 94, 6, 2);
            }
            if (!this.highlighted) {
                this.getGui().drawXCenteredString(poseStack, this.getX() + this.x1 / 2, this.getY() + this.y1 / 2 - 4, (Component)Component.literal((String)this.getText()), 0x404040, false);
            } else {
                this.getGui().drawXCenteredString(poseStack, this.getX() + this.x1 / 2, this.getY() + this.y1 / 2 - 4, (Component)Component.literal((String)this.getText()), ModUtils.convertRGBcolorToInt(255, 255, 255), false);
            }
        }
    }

    @Override
    public boolean onMouseClick(int mouseX, int mouseY, MouseButton button) {
        if (this.visible() && this.contains(mouseX, mouseY)) {
            this.getGui().getMinecraft().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            new PacketUpdateServerTile(this.tile, this.event);
        }
        return super.onMouseClick(mouseX, mouseY, button);
    }
}

