/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.vein.gas;

import com.denfop.api.vein.gas.GasVeinBase;
import com.denfop.api.vein.gas.GasVeinBaseSystem;
import com.denfop.api.vein.gas.TypeGas;
import com.denfop.config.ModConfig;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;

public class GasVeinSystem
implements GasVeinBaseSystem {
    public static GasVeinBaseSystem system;
    public static GasVeinBase EMPTY;
    private final Random rand;
    List<GasVeinBase> list;
    List<ChunkPos> chunkPos;
    Map<ChunkPos, GasVeinBase> chunkPosVeinMap;

    public GasVeinSystem() {
        system = this;
        this.list = new LinkedList<GasVeinBase>();
        this.chunkPos = new LinkedList<ChunkPos>();
        this.chunkPosVeinMap = new HashMap<ChunkPos, GasVeinBase>();
        this.rand = new Random();
    }

    @Override
    public GasVeinBase getEMPTY() {
        return EMPTY;
    }

    @Override
    public List<ChunkPos> getChunkPos() {
        return this.chunkPos;
    }

    @Override
    public List<GasVeinBase> getVeinsList() {
        return this.list;
    }

    @Override
    public void addVein(ChunkAccess chunk) {
        int chance = this.rand.nextInt(100);
        GasVeinBase vein = new GasVeinBase(TypeGas.NONE, chunk.getPos());
        if (chance < (Integer)ModConfig.COMMON.gasChance.get()) {
            vein.setType(TypeGas.values()[this.rand.nextInt(4) + 1]);
            vein.setMaxCol((Integer)ModConfig.COMMON.gasMaxVein.get());
            vein.setCol((Integer)ModConfig.COMMON.gasMaxVein.get());
        }
        this.list.add(vein);
        this.chunkPos.add(vein.getChunk());
        this.chunkPosVeinMap.put(vein.getChunk(), vein);
    }

    @Override
    public void addVein(CompoundTag tag) {
        GasVeinBase vein = new GasVeinBase(tag);
        this.list.add(vein);
        this.chunkPos.add(vein.getChunk());
        this.chunkPosVeinMap.put(vein.getChunk(), vein);
    }

    @Override
    public GasVeinBase getVein(ChunkPos pos) {
        return this.chunkPosVeinMap.getOrDefault(pos, EMPTY);
    }

    @Override
    public void unload() {
        this.list.clear();
        this.chunkPos.clear();
        this.chunkPosVeinMap.clear();
    }

    static {
        EMPTY = new GasVeinBase(TypeGas.NONE, new ChunkPos(999999999, 999999999));
    }
}

