/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.vein.gas;

import com.denfop.api.vein.gas.GasVein;
import com.denfop.api.vein.gas.TypeGas;
import com.denfop.network.packet.CustomPacketBuffer;
import java.util.Objects;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ChunkPos;

public class GasVeinBase
implements GasVein {
    private final ChunkPos chunk;
    boolean find;
    private TypeGas type;
    private int col;
    private int maxcol;

    public GasVeinBase(TypeGas type, ChunkPos chunk) {
        this.type = type;
        this.chunk = chunk;
        this.col = 0;
        this.maxcol = 0;
    }

    public GasVeinBase(CompoundTag tagCompound) {
        this.type = TypeGas.values()[tagCompound.getByte("type")];
        this.chunk = new ChunkPos((int)tagCompound.getShort("x"), (int)tagCompound.getShort("z"));
        this.col = tagCompound.getInt("col");
        this.maxcol = tagCompound.getInt("maxcol");
        this.find = tagCompound.getBoolean("find");
        if (!this.find && this.col != this.maxcol) {
            this.find = true;
        }
    }

    public GasVeinBase(CustomPacketBuffer is) {
        this.find = is.readBoolean();
        this.chunk = new ChunkPos((int)is.readShort(), (int)is.readShort());
        this.type = TypeGas.values()[is.readByte()];
        this.col = is.readInt();
        this.maxcol = is.readInt();
        if (!this.find && this.col != this.maxcol) {
            this.find = true;
        }
    }

    @Override
    public CustomPacketBuffer writePacket(RegistryAccess provider) {
        CustomPacketBuffer customPacketBuffer = new CustomPacketBuffer(32, provider);
        customPacketBuffer.writeBoolean(this.find);
        customPacketBuffer.writeShort(this.chunk.x);
        customPacketBuffer.writeShort(this.chunk.z);
        customPacketBuffer.writeByte(this.type.ordinal());
        customPacketBuffer.writeInt(this.col);
        customPacketBuffer.writeInt(this.maxcol);
        return customPacketBuffer;
    }

    @Override
    public TypeGas getType() {
        return this.type;
    }

    @Override
    public void setType(TypeGas type) {
        this.type = type;
    }

    @Override
    public ChunkPos getChunk() {
        return this.chunk;
    }

    @Override
    public int getCol() {
        return this.col;
    }

    @Override
    public void setCol(int col) {
        this.col = col;
    }

    @Override
    public int getMaxCol() {
        return this.maxcol;
    }

    @Override
    public void setMaxCol(int maxcol) {
        this.maxcol = maxcol;
    }

    @Override
    public void removeCol(int col) {
        assert (this.col - col >= 0);
        this.col -= col;
    }

    @Override
    public boolean isFind() {
        return this.find;
    }

    @Override
    public void setFind(boolean find) {
        this.find = find;
    }

    @Override
    public CompoundTag writeTag() {
        CompoundTag tagCompound = new CompoundTag();
        tagCompound.putBoolean("find", this.find);
        tagCompound.putShort("x", (short)this.chunk.x);
        tagCompound.putShort("z", (short)this.chunk.z);
        tagCompound.putByte("type", (byte)this.type.ordinal());
        tagCompound.putInt("col", this.col);
        tagCompound.putInt("maxcol", this.maxcol);
        return tagCompound;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GasVeinBase vein = (GasVeinBase)o;
        return vein.chunk.equals((Object)this.chunk);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.chunk, this.find, this.type, this.col, this.maxcol});
    }
}

