/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.space.upgrades.info;

import com.denfop.api.space.rovers.enums.EnumTypeUpgrade;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public class SpaceUpgradeItemInform {
    public static final Codec<SpaceUpgradeItemInform> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.xmap(EnumTypeUpgrade::valueOf, Enum::name).fieldOf("upgrade").forGetter(obj -> obj.upgrade), (App)Codec.INT.fieldOf("number").forGetter(obj -> obj.number)).apply((Applicative)instance, SpaceUpgradeItemInform::new));
    public static final StreamCodec<FriendlyByteBuf, SpaceUpgradeItemInform> STREAM_CODEC = StreamCodec.of((buf, value) -> {
        buf.writeEnum((Enum)value.upgrade);
        buf.writeInt(value.number);
    }, buf -> new SpaceUpgradeItemInform((EnumTypeUpgrade)buf.readEnum(EnumTypeUpgrade.class), buf.readInt()));
    public final EnumTypeUpgrade upgrade;
    public int number;

    public SpaceUpgradeItemInform(EnumTypeUpgrade modules, int number) {
        this.upgrade = modules;
        this.number = number;
    }

    public boolean matched(EnumTypeUpgrade modules) {
        return this.upgrade.getUpgrade().equals(modules.getUpgrade());
    }

    public int getInformation(EnumTypeUpgrade modules) {
        if (this.upgrade.getUpgrade().equals(modules.getUpgrade())) {
            return this.number;
        }
        return 0;
    }

    public String getName() {
        switch (this.upgrade) {
            case SOLAR: {
                return String.valueOf(ChatFormatting.YELLOW) + Localization.translate("iu.spaceupgrade.solar") + String.valueOf(ChatFormatting.GREEN) + ModUtils.getString(30 * this.number);
            }
            case DRILL: {
                return String.valueOf(ChatFormatting.AQUA) + Localization.translate("iu.spaceupgrade.drill") + String.valueOf(ChatFormatting.GREEN) + ModUtils.getString(this.number);
            }
            case PROTECTION: {
                return String.valueOf(ChatFormatting.GOLD) + Localization.translate("protect") + String.valueOf(ChatFormatting.GREEN) + ModUtils.getString(0.2 * (double)this.number * 100.0) + "%";
            }
            case COOLER: {
                return String.valueOf(ChatFormatting.LIGHT_PURPLE) + Localization.translate("iu.spaceupgrade.cool") + String.valueOf(ChatFormatting.GREEN) + ModUtils.getString(this.number * -37) + "C\u00b0";
            }
            case ENGINE: {
                return String.valueOf(ChatFormatting.RED) + Localization.translate("iu.spaceupgrade.engine") + String.valueOf(ChatFormatting.GREEN) + ModUtils.getString((double)this.number * 12.5) + "%";
            }
            case HEATER: {
                return String.valueOf(ChatFormatting.RED) + Localization.translate("iu.spaceupgrade.heat") + String.valueOf(ChatFormatting.GREEN) + ModUtils.getString(350 * this.number) + "C\u00b0";
            }
            case PRESSURE: {
                return String.valueOf(ChatFormatting.GOLD) + Localization.translate("iu.spaceupgrade.pressure");
            }
        }
        return "";
    }
}

