/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.space.fakebody;

import com.denfop.api.space.IBaseResource;
import com.denfop.api.space.IBody;
import com.denfop.api.space.SpaceNet;
import com.denfop.api.space.fakebody.Data;
import com.denfop.api.space.fakebody.EnumOperation;
import com.denfop.api.space.fakebody.EventHandlerPlanet;
import com.denfop.api.space.fakebody.FakeAsteroid;
import com.denfop.api.space.fakebody.FakePlanet;
import com.denfop.api.space.fakebody.FakeSatellite;
import com.denfop.api.space.fakebody.IFakeAsteroid;
import com.denfop.api.space.fakebody.IFakeBody;
import com.denfop.api.space.fakebody.IFakePlanet;
import com.denfop.api.space.fakebody.IFakeSatellite;
import com.denfop.api.space.fakebody.IFakeSpaceSystemBase;
import com.denfop.api.space.fakebody.SpaceOperation;
import com.denfop.api.space.research.api.IResearchTable;
import com.denfop.api.space.research.api.IRocketLaunchPad;
import com.denfop.api.space.rovers.api.IRovers;
import com.denfop.api.space.rovers.enums.EnumTypeUpgrade;
import com.denfop.api.space.upgrades.SpaceUpgradeSystem;
import com.denfop.utils.ElectricItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class FakeSpaceSystemBase
implements IFakeSpaceSystemBase {
    private final Map<UUID, List<IFakeBody>> uuidListMap = new HashMap<UUID, List<IFakeBody>>();
    private final Map<UUID, Map<IBody, Data>> dataMap = new HashMap<UUID, Map<IBody, Data>>();
    private final List<FakePlanet> fakePlanetList;
    private final List<FakeSatellite> fakeSatelliteList;
    private final Map<UUID, IResearchTable> MapEntityPlayer;
    private final Map<UUID, IRocketLaunchPad> rocketLaunchPadMap = new HashMap<UUID, IRocketLaunchPad>();
    private final List<FakeAsteroid> fakeAsteroids;
    private final Random rand;
    Map<UUID, Map<IBody, SpaceOperation>> fakeBodyMap = new HashMap<UUID, Map<IBody, SpaceOperation>>();
    List<IFakeBody> deletingBody = new LinkedList<IFakeBody>();

    public FakeSpaceSystemBase() {
        NeoForge.EVENT_BUS.register((Object)new EventHandlerPlanet());
        this.fakePlanetList = new LinkedList<FakePlanet>();
        this.fakeSatelliteList = new LinkedList<FakeSatellite>();
        this.rand = new Random();
        this.rand.setSeed(this.rand.nextLong());
        this.MapEntityPlayer = new HashMap<UUID, IResearchTable>();
        this.fakeAsteroids = new LinkedList<FakeAsteroid>();
    }

    @Override
    public Map<IBody, Data> getDataFromUUID(UUID uuid) {
        return this.dataMap.computeIfAbsent(uuid, k -> new HashMap());
    }

    @Override
    public List<FakeAsteroid> getFakeAsteroidList() {
        return this.fakeAsteroids;
    }

    @Override
    public Map<IBody, SpaceOperation> getSpaceTable(UUID player) {
        return this.fakeBodyMap.computeIfAbsent(player, k -> new HashMap());
    }

    @Override
    public Map<UUID, IRocketLaunchPad> getRocketPadMap() {
        return this.rocketLaunchPadMap;
    }

    @Override
    public Map<UUID, IResearchTable> getResearchTableMap() {
        return this.MapEntityPlayer;
    }

    @Override
    public Map<UUID, List<IFakeBody>> getBodyMap() {
        return this.uuidListMap;
    }

    @Override
    public List<FakePlanet> getFakePlanetList() {
        return this.fakePlanetList;
    }

    @Override
    public void working() {
        for (FakePlanet fakePlanet : this.fakePlanetList) {
            this.processFakeBody(fakePlanet, this.getBodyMap());
        }
        for (FakeSatellite fakeSatellite : this.fakeSatelliteList) {
            this.processFakeBody(fakeSatellite, this.getBodyMap());
        }
        for (FakeAsteroid fakeAsteroid : this.fakeAsteroids) {
            this.processFakeBody(fakeAsteroid, this.getBodyMap());
        }
        for (IFakeBody fakeBody : this.deletingBody) {
            if (fakeBody instanceof FakePlanet) {
                this.processFakeBody((FakePlanet)fakeBody, this.fakePlanetList);
                continue;
            }
            if (fakeBody instanceof FakeSatellite) {
                this.processFakeBody((FakeSatellite)fakeBody, this.fakeSatelliteList);
                continue;
            }
            if (!(fakeBody instanceof FakeAsteroid)) continue;
            this.processFakeBody((FakeAsteroid)fakeBody, this.fakeAsteroids);
        }
        this.deletingBody.clear();
    }

    private <T extends IFakeBody> void processFakeBody(T fakeBody, List<T> bodyList) {
        bodyList.remove(fakeBody);
        if (fakeBody.getSpaceOperation().getOperation() == EnumOperation.SUCCESS) {
            IRocketLaunchPad rocketLaunchPad = this.rocketLaunchPadMap.get(fakeBody.getPlayer());
            IResearchTable researchTable = this.getResearchTableMap().get(fakeBody.getPlayer());
            if (rocketLaunchPad != null) {
                this.handleSuccessfulOperation(fakeBody, rocketLaunchPad, researchTable);
            }
        }
    }

    private <T extends IFakeBody> void handleSuccessfulOperation(T fakeBody, IRocketLaunchPad rocketLaunchPad, IResearchTable researchTable) {
        if (fakeBody.getSpaceOperation().getAuto()) {
            rocketLaunchPad.charge(fakeBody.getRover().getItemStack());
            rocketLaunchPad.refuel(fakeBody.getRover().getItemStack(), fakeBody.getRover().getItem());
            Object target = this.getTarget(fakeBody);
            rocketLaunchPad.addDataRocket(fakeBody.getRover().getItemStack());
            SpaceNet.instance.getResearchSystem().sendingAutoOperation(fakeBody.getRover(), (IBody)target, researchTable);
        } else {
            rocketLaunchPad.getSlotOutput().add(fakeBody.getRover().getItemStack());
        }
    }

    private Object getTarget(IFakeBody fakeBody) {
        if (fakeBody instanceof FakePlanet) {
            return ((FakePlanet)fakeBody).getPlanet();
        }
        if (fakeBody instanceof FakeSatellite) {
            return ((FakeSatellite)fakeBody).getSatellite();
        }
        if (fakeBody instanceof FakeAsteroid) {
            return ((FakeAsteroid)fakeBody).getAsteroid();
        }
        return null;
    }

    @Override
    public List<FakeSatellite> getFakeSatelliteList() {
        return this.fakeSatelliteList;
    }

    @Override
    public void addFakeSatellite(FakeSatellite satellite) {
        this.fakeSatelliteList.add(satellite);
    }

    private void processFakeBody(IFakeBody fakeBody, Map<UUID, List<IFakeBody>> uuidListMap) {
        UUID playerId = fakeBody.getPlayer();
        if (fakeBody.getSpaceOperation().getOperation() == EnumOperation.SUCCESS) {
            this.removeFakeBody(fakeBody, playerId, uuidListMap);
            return;
        }
        if (fakeBody.getTimerFrom().getTime() == 0) {
            this.handleResourceReturn(fakeBody, playerId, uuidListMap);
            return;
        }
        ItemStack itemStack = fakeBody.getRover().getItemStack();
        if (ElectricItem.manager.getCharge(itemStack) < 100.0 || fakeBody.getRover().getItem().getFluidHandler(itemStack).drain(2, IFluidHandler.FluidAction.SIMULATE).isEmpty()) {
            this.failOperation(fakeBody, playerId, uuidListMap);
            return;
        }
        this.processTimers(fakeBody);
        this.manageEnergy(fakeBody);
        if (!fakeBody.getTimerTo().canWork() && !fakeBody.getTimerFrom().canWork() && fakeBody.getTimerFrom().getTime() > 0) {
            this.collectResources(fakeBody);
            fakeBody.getTimerFrom().setCanWork(true);
            this.validateEnvironment(fakeBody, playerId, uuidListMap);
        } else if (fakeBody.getTimerFrom().getTime() == 0) {
            this.handleResourceReturn(fakeBody, playerId, uuidListMap);
        }
    }

    @Override
    public void addFakePlanet(FakePlanet planet) {
        this.fakePlanetList.add(planet);
    }

    @Override
    public void addFakeAsteroid(FakeAsteroid asteroid) {
        this.fakeAsteroids.add(asteroid);
    }

    @Override
    public int[] getLimitTemperatureFromRovers(IRovers rover) {
        int max_temperature = 150;
        int min_temperature = -125;
        int cooler_mod = 0;
        int heater_mod = 0;
        if (SpaceUpgradeSystem.system.getModules(EnumTypeUpgrade.COOLER, rover.getItemStack()) != null) {
            cooler_mod = SpaceUpgradeSystem.system.getModules((EnumTypeUpgrade)EnumTypeUpgrade.COOLER, (ItemStack)rover.getItemStack()).number;
        }
        if (SpaceUpgradeSystem.system.getModules(EnumTypeUpgrade.HEATER, rover.getItemStack()) != null) {
            heater_mod = SpaceUpgradeSystem.system.getModules((EnumTypeUpgrade)EnumTypeUpgrade.HEATER, (ItemStack)rover.getItemStack()).number;
        }
        int[] temperatures = new int[]{max_temperature += 350 * heater_mod, min_temperature -= 37 * cooler_mod};
        return temperatures;
    }

    @Override
    public IRovers getRoversFromPlanet(FakePlanet planet) {
        return planet.getRover();
    }

    @Override
    public IRovers getRoversFromSatellite(FakeSatellite satellite) {
        return satellite.getRover();
    }

    @Override
    public IRovers getRoversFromAsteroid(FakeAsteroid asteroid) {
        return asteroid.getRover();
    }

    @Override
    public List<IBaseResource> getBaseResource(FakePlanet planet, int percent) {
        List<IBaseResource> list = planet.getPlanet().getResources();
        ArrayList<IBaseResource> newlist = new ArrayList<IBaseResource>();
        for (IBaseResource resource : list) {
            if (resource.getTypeRovers() != planet.getRover().getType() || resource.getPercentResearchBody() > percent || resource.getChance() < this.rand.nextInt(resource.getMaxChance())) continue;
            newlist.add(resource);
        }
        return newlist;
    }

    @Override
    public List<IBaseResource> getBaseResource(FakeSatellite satellite, int percent) {
        List<IBaseResource> list = satellite.getSatellite().getResources();
        ArrayList<IBaseResource> newlist = new ArrayList<IBaseResource>();
        for (IBaseResource resource : list) {
            if (resource.getTypeRovers() != satellite.getRover().getType() || resource.getPercentResearchBody() > percent || resource.getChance() <= this.rand.nextInt(resource.getMaxChance())) continue;
            newlist.add(resource);
        }
        return newlist;
    }

    public List<IBaseResource> getBaseResource(IFakeBody planet, int percent) {
        if (planet instanceof IFakePlanet) {
            return this.getBaseResource((FakePlanet)planet, percent);
        }
        if (planet instanceof IFakeSatellite) {
            return this.getBaseResource((FakeSatellite)planet, percent);
        }
        if (planet instanceof IFakeAsteroid) {
            return this.getBaseResource((FakeAsteroid)planet, percent);
        }
        return Collections.emptyList();
    }

    @Override
    public List<IBaseResource> getBaseResource(FakeAsteroid planet, int percent) {
        List<IBaseResource> list = planet.getAsteroid().getResources();
        LinkedList<IBaseResource> newlist = new LinkedList<IBaseResource>();
        for (IBaseResource resource : list) {
            if (resource.getTypeRovers() != planet.getRover().getType() || resource.getPercentResearchBody() > percent || resource.getChance() <= this.rand.nextInt(resource.getMaxChance())) continue;
            newlist.add(resource);
        }
        return newlist;
    }

    @Override
    public void unload() {
        this.fakePlanetList.clear();
        this.fakeSatelliteList.clear();
        this.MapEntityPlayer.clear();
        this.rocketLaunchPadMap.clear();
        this.fakeBodyMap.clear();
        this.fakeAsteroids.clear();
        this.uuidListMap.clear();
        this.dataMap.clear();
    }

    @Override
    public void addDataBody(UUID name, Map<IBody, Data> map) {
        if (!this.dataMap.containsKey(name)) {
            this.dataMap.put(name, map);
        }
    }

    @Override
    public void copyData(Map<IBody, Data> data, UUID uniqueID) {
        if (this.dataMap.containsKey(uniqueID)) {
            Map<IBody, Data> dataPlayer = this.dataMap.get(uniqueID);
            for (Map.Entry<IBody, Data> dataEntry : data.entrySet()) {
                Data data1 = dataPlayer.get(dataEntry.getKey());
                if (!(data1.getPercent() < dataEntry.getValue().getPercent())) continue;
                data1.setInformation(dataEntry.getValue().getPercent());
            }
        } else {
            this.dataMap.put(uniqueID, new HashMap<IBody, Data>(data));
        }
    }

    private void processTimers(IFakeBody fakeBody) {
        if (fakeBody.getTimerTo().canWork()) {
            fakeBody.getTimerTo().work();
        }
        if (fakeBody.getTimerFrom().canWork()) {
            fakeBody.getTimerFrom().work();
        }
    }

    private void manageEnergy(IFakeBody fakeBody) {
        int solar;
        ItemStack itemStack = fakeBody.getRover().getItemStack();
        ElectricItem.manager.discharge(itemStack, 100.0, 14, true, false, false);
        fakeBody.getRover().getItem().getFluidHandler(itemStack).drain(2, IFluidHandler.FluidAction.EXECUTE);
        int n = solar = SpaceUpgradeSystem.system.hasModules(EnumTypeUpgrade.SOLAR, itemStack) ? SpaceUpgradeSystem.system.getModules((EnumTypeUpgrade)EnumTypeUpgrade.SOLAR, (ItemStack)itemStack).number : 0;
        if (solar > 0) {
            ElectricItem.manager.charge(itemStack, 30 * solar, Integer.MAX_VALUE, true, false);
        }
    }

    private void collectResources(IFakeBody fakeBody) {
        int drill = 1;
        int level = fakeBody.getRover().getItem().getLevel().ordinal() + 1;
        drill += level;
        if (SpaceUpgradeSystem.system.hasModules(EnumTypeUpgrade.DRILL, fakeBody.getRover().getItemStack())) {
            drill += SpaceUpgradeSystem.system.getModules((EnumTypeUpgrade)EnumTypeUpgrade.DRILL, (ItemStack)fakeBody.getRover().getItemStack()).number;
        }
        for (int i = 0; i < drill; ++i) {
            List<IBaseResource> baseResource = this.getBaseResource(fakeBody, (int)fakeBody.getData().getPercent());
            for (IBaseResource resource : baseResource) {
                if (resource == null) continue;
                fakeBody.addBaseResource(resource);
            }
        }
    }

    private void validateEnvironment(IFakeBody fakeBody, UUID playerId, Map<UUID, List<IFakeBody>> uuidListMap) {
        int[] tempLimits;
        int temperature = fakeBody.getBody().getTemperature();
        if (temperature > (tempLimits = SpaceNet.instance.getFakeSpaceSystem().getLimitTemperatureFromRovers(fakeBody.getRover()))[0] || temperature < tempLimits[1]) {
            this.failOperation(fakeBody, playerId, uuidListMap);
        }
    }

    private void handleResourceReturn(IFakeBody fakeBody, UUID playerId, Map<UUID, List<IFakeBody>> uuidListMap) {
        IRocketLaunchPad rocketLaunchPad = this.getRocketPadMap().get(playerId);
        if (rocketLaunchPad != null) {
            for (IBaseResource resource : fakeBody.getResource()) {
                if (resource.getItemStack() != null) {
                    rocketLaunchPad.getSlotOutput().add(resource.getItemStack());
                }
                if (resource.getFluidStack() == null) continue;
                rocketLaunchPad.addFluidStack(resource.getFluidStack());
            }
            fakeBody.getSpaceOperation().setOperation(EnumOperation.SUCCESS);
            if (fakeBody.getTimerTo().getTime() == 0) {
                fakeBody.getData().addInformation(5.0);
            }
            this.removeFakeBody(fakeBody, playerId, uuidListMap);
        }
    }

    private void removeFakeBody(IFakeBody fakeBody, UUID playerId, Map<UUID, List<IFakeBody>> uuidListMap) {
        this.deletingBody.add(fakeBody);
        List list = uuidListMap.computeIfAbsent(playerId, k -> new LinkedList());
        list.remove(fakeBody);
    }

    private void failOperation(IFakeBody fakeBody, UUID playerId, Map<UUID, List<IFakeBody>> uuidListMap) {
        fakeBody.getSpaceOperation().setOperation(EnumOperation.FAIL);
        this.removeFakeBody(fakeBody, playerId, uuidListMap);
    }
}

