/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.space.fakebody;

import com.denfop.api.space.BaseResource;
import com.denfop.api.space.BaseSpaceSystem;
import com.denfop.api.space.IBaseResource;
import com.denfop.api.space.IBody;
import com.denfop.api.space.IPlanet;
import com.denfop.api.space.SpaceInit;
import com.denfop.api.space.SpaceNet;
import com.denfop.api.space.fakebody.IData;
import com.denfop.api.space.fakebody.IFakePlanet;
import com.denfop.api.space.fakebody.SpaceOperation;
import com.denfop.api.space.rovers.Rovers;
import com.denfop.api.space.rovers.api.IRovers;
import com.denfop.api.space.rovers.api.IRoversItem;
import com.denfop.api.space.rovers.enums.EnumTypeUpgrade;
import com.denfop.api.space.upgrades.SpaceUpgradeSystem;
import com.denfop.utils.Timer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class FakePlanet
implements IFakePlanet {
    SpaceOperation spaceOperation;
    private UUID player;
    private IPlanet planet;
    private IRovers rovers;
    private IData data;
    private List<IBaseResource> iBaseResourceList = new ArrayList<IBaseResource>();
    private Timer timerToPlanet;
    private Timer timerFromPlanet;

    public FakePlanet(UUID player, IPlanet planet, IRovers rovers, IData data, SpaceOperation spaceOperation) {
        this.player = player;
        this.planet = planet;
        this.rovers = rovers;
        this.spaceOperation = spaceOperation;
        this.data = data;
        int seconds = (int)(Math.abs(planet.getDistance() - SpaceInit.earth.getDistance()) / (SpaceInit.mars.getDistance() - SpaceInit.earth.getDistance()) * 360.0);
        seconds += planet.getSystem().getDistanceFromSolar() * 60 * 60;
        if (SpaceUpgradeSystem.system.hasModules(EnumTypeUpgrade.ENGINE, rovers.getItemStack())) {
            int engine = SpaceUpgradeSystem.system.getModules((EnumTypeUpgrade)EnumTypeUpgrade.ENGINE, (ItemStack)rovers.getItemStack()).number;
            seconds = (int)((double)seconds * (1.0 - (double)engine * 0.125));
        }
        FluidStack fluidStack = rovers.getItem().getFluidHandler(rovers.getItemStack()).drain(1, IFluidHandler.FluidAction.SIMULATE);
        double coef = BaseSpaceSystem.rocketFuelCoef.get(BaseSpaceSystem.fluidToLevel.get(fluidStack.getFluid()));
        seconds = (int)((double)seconds / coef);
        this.timerToPlanet = new Timer(seconds);
        this.timerFromPlanet = new Timer(seconds);
        this.timerFromPlanet.setCanWork(false);
    }

    public FakePlanet(CompoundTag nbtTagCompound, HolderLookup.Provider lookupProvider) {
        this.player = nbtTagCompound.getUUID("uuid");
        this.planet = (IPlanet)SpaceNet.instance.getBodyFromName(nbtTagCompound.getString("body"));
        this.data = SpaceNet.instance.getFakeSpaceSystem().getDataFromUUID(this.player).get(this.planet);
        ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)nbtTagCompound.getCompound("rover"));
        this.rovers = new Rovers((IRoversItem)stack.getItem(), stack);
        this.timerToPlanet = new Timer(nbtTagCompound.getCompound("timerTo"));
        this.timerFromPlanet = new Timer(nbtTagCompound.getCompound("timerFrom"));
        this.spaceOperation = new SpaceOperation((IBody)this.planet, nbtTagCompound.getCompound("operation"));
        ListTag tagList = nbtTagCompound.getList("baseResource", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag tagCompound = tagList.getCompound(i);
            BaseResource baseResource = new BaseResource(tagCompound, lookupProvider);
            this.iBaseResourceList.add(baseResource);
        }
        SpaceUpgradeSystem.system.updateListFromNBT(this.rovers.getItem(), this.rovers.getItemStack());
    }

    @Override
    public void addBaseResource(IBaseResource baseResource) {
        this.iBaseResourceList.add(baseResource);
    }

    @Override
    public IBody getBody() {
        return this.planet;
    }

    @Override
    public void resetAuto() {
        this.spaceOperation.setAuto(!this.getSpaceOperation().getAuto());
    }

    @Override
    public SpaceOperation getSpaceOperation() {
        return this.spaceOperation;
    }

    @Override
    public List<IBaseResource> getResource() {
        return this.iBaseResourceList;
    }

    @Override
    public Timer getTimerTo() {
        return this.timerToPlanet;
    }

    @Override
    public Timer getTimerFrom() {
        return this.timerFromPlanet;
    }

    @Override
    public CompoundTag writeNBTTagCompound(CompoundTag nbtTagCompound, HolderLookup.Provider p_323640_) {
        nbtTagCompound.putUUID("uuid", this.player);
        nbtTagCompound.putString("body", this.planet.getName());
        nbtTagCompound.put("rover", this.rovers.getItemStack().save(p_323640_));
        nbtTagCompound.put("timerTo", (Tag)this.timerToPlanet.writeNBT(new CompoundTag()));
        nbtTagCompound.put("timerFrom", (Tag)this.timerFromPlanet.writeNBT(new CompoundTag()));
        nbtTagCompound.put("operation", (Tag)this.spaceOperation.writeTag(new CompoundTag()));
        ListTag tagList = new ListTag();
        for (IBaseResource baseResource : this.iBaseResourceList) {
            CompoundTag nbt = new CompoundTag();
            baseResource.writeNBTTag(nbt, p_323640_);
            tagList.add((Object)nbt);
        }
        nbtTagCompound.put("baseResource", (Tag)tagList);
        return nbtTagCompound;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FakePlanet that = (FakePlanet)o;
        return Objects.equals(this.player, that.player) && Objects.equals(this.planet, that.planet);
    }

    @Override
    public IPlanet getPlanet() {
        return this.planet;
    }

    @Override
    public UUID getPlayer() {
        return this.player;
    }

    @Override
    public IRovers getRover() {
        return this.rovers;
    }

    @Override
    public IData getData() {
        return this.data;
    }

    @Override
    public boolean matched(IBody body) {
        return this.planet.getName().equals(body.getName());
    }
}

