/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.space.fakebody;

import com.denfop.api.space.IBody;
import com.denfop.api.space.SpaceNet;
import com.denfop.api.space.fakebody.IData;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;

public class Data
implements IData {
    private final UUID player;
    private final IBody body;
    private double percent;

    public Data(UUID player, IBody body) {
        this.player = player;
        this.body = body;
    }

    public Data(CompoundTag nbtTagCompound) {
        this.player = nbtTagCompound.getUUID("uuid");
        this.body = SpaceNet.instance.getBodyFromName(nbtTagCompound.getString("nameBody"));
        this.percent = nbtTagCompound.getDouble("percent");
    }

    public IBody getBody() {
        return this.body;
    }

    public CompoundTag writeNBT() {
        CompoundTag nbtTagCompound = new CompoundTag();
        nbtTagCompound.putDouble("percent", this.percent);
        nbtTagCompound.putUUID("uuid", this.player);
        nbtTagCompound.putString("nameBody", this.body.getName());
        return nbtTagCompound;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Data data = (Data)o;
        return Objects.equals(this.player, data.player) && Objects.equals(this.body, data.body);
    }

    @Override
    public double getPercent() {
        return this.percent;
    }

    @Override
    public void addInformation() {
        this.percent += 1.0;
        if (this.percent > 100.0) {
            this.percent = 100.0;
        }
    }

    @Override
    public void setInformation(double information) {
        this.percent = information;
        if (this.percent > 100.0) {
            this.percent = 100.0;
        }
    }

    @Override
    public void addInformation(double information) {
        this.percent += information;
        if (this.percent > 100.0) {
            this.percent = 100.0;
        }
    }
}

