/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.space.colonies.building;

import com.denfop.api.space.colonies.Building;
import com.denfop.api.space.colonies.Colony;
import com.denfop.api.space.colonies.api.IColony;
import com.denfop.api.space.colonies.api.building.IEntertainment;
import com.denfop.api.space.colonies.enums.EnumEntertainment;
import com.denfop.api.space.colonies.enums.EnumProblems;
import com.denfop.api.space.colonies.enums.EnumTypeBuilding;
import com.denfop.network.packet.CustomPacketBuffer;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;

public class ColonyEntertainment
extends Building
implements IEntertainment {
    private final EnumEntertainment type;
    byte people;

    public ColonyEntertainment(EnumEntertainment type, IColony colonies, boolean simulate) {
        super(colonies);
        this.type = type;
        if (!simulate) {
            this.getColony().addBuilding(this);
        }
    }

    public ColonyEntertainment(CustomPacketBuffer packetBuffer, Colony colonies) {
        super(colonies);
        byte id = packetBuffer.readByte();
        this.type = EnumEntertainment.getID(id);
        this.people = packetBuffer.readByte();
        this.getColony().addBuilding(this);
    }

    public ColonyEntertainment(CompoundTag tag, IColony colonies) {
        super(colonies);
        byte id = tag.getByte("id");
        this.type = EnumEntertainment.getID(id);
        this.people = tag.getByte("people");
        this.getColony().addBuilding(this);
    }

    @Override
    public boolean isIgnore() {
        return true;
    }

    @Override
    public void work() {
        if (this.people == this.type.getNeedPeople()) {
            if (this.getColony().getEnergy() >= this.type.getEnergy()) {
                this.getColony().useEnergy(this.type.getEnergy());
                this.getColony().addEntertainment(this.type.getEntertainment());
            } else if (!this.getColony().getProblems().contains((Object)EnumProblems.ENERGY)) {
                this.getColony().getProblems().add(EnumProblems.ENERGY);
            }
        }
    }

    @Override
    public CompoundTag writeTag(CompoundTag tag, HolderLookup.Provider p_323640_) {
        super.writeTag(tag, p_323640_);
        tag.putByte("people", this.people);
        tag.putByte("id", (byte)this.type.ordinal());
        return tag;
    }

    @Override
    public CustomPacketBuffer writePacket(CustomPacketBuffer customPacketBuffer) {
        super.writePacket(customPacketBuffer);
        customPacketBuffer.writeByte(this.type.ordinal());
        customPacketBuffer.writeByte(this.people);
        return customPacketBuffer;
    }

    @Override
    public int getMinLevelColony() {
        return this.type.getLevel();
    }

    @Override
    public EnumTypeBuilding getTypeBuilding() {
        return EnumTypeBuilding.ENTERTAINMENT;
    }

    @Override
    public byte getId() {
        return 8;
    }

    @Override
    public int getPeople() {
        return this.people;
    }

    @Override
    public int getWorkers() {
        return this.people;
    }

    @Override
    public int needWorkers() {
        return this.type.getNeedPeople() - this.people;
    }

    @Override
    public void addWorkers(int workers) {
        this.people = (byte)(this.people + workers);
    }

    @Override
    public void removeWorkers(int remove) {
        this.people = (byte)(this.people - remove);
    }

    @Override
    public EnumEntertainment getType() {
        return this.type;
    }
}

