/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.space.colonies;

import com.denfop.api.space.IAsteroid;
import com.denfop.api.space.IBody;
import com.denfop.api.space.IPlanet;
import com.denfop.api.space.ISatellite;
import com.denfop.api.space.SpaceInit;
import com.denfop.api.space.SpaceNet;
import com.denfop.api.space.colonies.api.IColony;
import com.denfop.api.space.research.api.IRocketLaunchPad;
import com.denfop.utils.Timer;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;

public class Sends {
    private final UUID uuid;
    private final Timer timerToPlanet;
    private final IBody body;
    List<ItemStack> stacks = new LinkedList<ItemStack>();
    List<FluidStack> fluidStacks = new LinkedList<FluidStack>();

    public Sends(UUID uuid, IBody body, IColony colony) {
        this.uuid = uuid;
        int seconds = 0;
        this.body = body;
        if (body instanceof IPlanet) {
            seconds = (int)(Math.abs(body.getDistance() - SpaceInit.earth.getDistance()) / (SpaceInit.mars.getDistance() - SpaceInit.earth.getDistance()) * 799.6800000000001);
        } else if (body instanceof ISatellite) {
            double distancePlanetToPlanet = (((ISatellite)body).getPlanet().getDistance() - SpaceInit.earth.getDistance()) / (SpaceInit.mars.getDistance() - SpaceInit.earth.getDistance());
            double distanceSatellite = Math.abs(SpaceInit.moon.getDistanceFromPlanet() - ((ISatellite)body).getDistanceFromPlanet()) / SpaceInit.moon.getDistanceFromPlanet();
            if (((ISatellite)body).getPlanet() == SpaceInit.earth) {
                distanceSatellite = 1.0;
            }
            seconds = (int)Math.abs(distanceSatellite * 5.0 * 60.0 * 0.8 + distancePlanetToPlanet * 799.6800000000001);
        } else {
            seconds = (int)(Math.abs((((IAsteroid)body).getMaxDistance() - ((IAsteroid)body).getMinDistance()) / 2.0 + ((IAsteroid)body).getMinDistance() - SpaceInit.earth.getDistance()) / (SpaceInit.mars.getDistance() - SpaceInit.earth.getDistance()) * 799.6800000000001);
        }
        int dop = colony.getLevel() / 10;
        this.timerToPlanet = new Timer(seconds / (4 + dop));
    }

    public Sends(CompoundTag tagCompound, HolderLookup.Provider p_323640_) {
        this.uuid = tagCompound.getUUID("uuid");
        this.body = SpaceNet.instance.getBodyFromName(tagCompound.getString("body"));
        this.timerToPlanet = new Timer(tagCompound.getCompound("time"));
        ListTag nbtTagList = tagCompound.getList("items", 10);
        this.stacks.clear();
        for (int i = 0; i < nbtTagList.size(); ++i) {
            this.stacks.add(ItemStack.parseOptional((HolderLookup.Provider)p_323640_, (CompoundTag)nbtTagList.getCompound(i)));
        }
        ListTag nbtTagList1 = tagCompound.getList("fluids", 10);
        this.fluidStacks.clear();
        for (int i = 0; i < nbtTagList1.size(); ++i) {
            this.fluidStacks.add(FluidStack.parseOptional((HolderLookup.Provider)p_323640_, (CompoundTag)nbtTagList1.getCompound(i)));
        }
    }

    public IBody getBody() {
        return this.body;
    }

    public CompoundTag writeToNbt(HolderLookup.Provider p_323640_) {
        CompoundTag tagCompound = new CompoundTag();
        tagCompound.putUUID("uuid", this.uuid);
        tagCompound.putString("body", this.body.getName());
        tagCompound.put("time", (Tag)this.timerToPlanet.writeNBT(new CompoundTag()));
        ListTag nbtTagList = new ListTag();
        for (ItemStack stack : this.stacks) {
            nbtTagList.add((Object)stack.save(p_323640_));
        }
        tagCompound.put("items", (Tag)nbtTagList);
        ListTag nbtTagList1 = new ListTag();
        for (FluidStack fluidStack : this.fluidStacks) {
            nbtTagList1.add((Object)fluidStack.save(p_323640_));
        }
        tagCompound.put("fluids", (Tag)nbtTagList1);
        return tagCompound;
    }

    public Timer getTimerToPlanet() {
        return this.timerToPlanet;
    }

    public boolean needRemove() {
        return !this.timerToPlanet.canWork();
    }

    public void works() {
        this.timerToPlanet.work();
        if (!this.timerToPlanet.canWork()) {
            IRocketLaunchPad spacePad = SpaceNet.instance.getFakeSpaceSystem().getRocketPadMap().get(this.uuid);
            if (spacePad != null) {
                for (ItemStack stack : this.stacks) {
                    spacePad.getSlotOutput().add(stack);
                }
                for (FluidStack fluidStack : this.fluidStacks) {
                    spacePad.addFluidStack(fluidStack);
                }
            } else {
                this.timerToPlanet.setCanWork(true);
            }
        }
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void addStack(FluidStack fluidStack) {
        this.fluidStacks.add(fluidStack);
    }

    public void addStack(ItemStack itemStack) {
        this.stacks.add(itemStack);
    }
}

