/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.recipe;

import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import java.io.IOException;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.ItemStack;

public class RecipeInfo {
    private final ItemStack stack;
    private final double col;

    public RecipeInfo(ItemStack stack, double col) {
        this.stack = stack;
        this.col = col;
    }

    public RecipeInfo(CustomPacketBuffer packetBuffer) {
        this.col = packetBuffer.readDouble();
        try {
            this.stack = (ItemStack)DecoderHandler.decode(packetBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public CustomPacketBuffer getPacket(RegistryAccess access) {
        CustomPacketBuffer packetBuffer = new CustomPacketBuffer(access);
        packetBuffer.writeDouble(this.col);
        try {
            EncoderHandler.encode(packetBuffer, this.stack);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packetBuffer;
    }

    public double getCol() {
        return this.col;
    }

    public ItemStack getStack() {
        return this.stack;
    }
}

