/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.recipe;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IBaseRecipe;
import com.denfop.api.recipe.IInput;
import com.denfop.api.recipe.IRecipeInputStack;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.InventoryOutput;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.recipe.RecipeArrayList;
import com.denfop.api.recipe.RecipeInputStack;
import com.denfop.api.widget.EnumTypeSlot;
import com.denfop.api.widget.ITypeSlot;
import com.denfop.blockentity.base.BlockEntityConverterSolidMatter;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.componets.Fluids;
import com.denfop.inventory.Inventory;
import com.denfop.inventory.InventoryFluidByList;
import com.denfop.items.ItemRecipeSchedule;
import com.denfop.recipe.IInputItemStack;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class InventoryRecipes
extends Inventory
implements ITypeSlot {
    public final IUpdateTick tile;
    private final ConcurrentHashMap<Integer, RecipeArrayList<IRecipeInputStack>> map = new ConcurrentHashMap();
    private final RecipeArrayList<IRecipeInputStack> default_accepts;
    private IBaseRecipe recipe;
    private RecipeArrayList<IRecipeInputStack> accepts;
    private List<BaseMachineRecipe> recipe_list;
    private Fluids.InternalFluidTank tank;
    private InventoryFluidByList invSlotConsumableLiquidByList = null;
    private int index;

    public InventoryRecipes(BlockEntityInventory base, IBaseRecipe baseRecipe, IUpdateTick tile) {
        super(base, Inventory.TypeItemSlot.INPUT, baseRecipe.getSize());
        this.recipe = baseRecipe;
        this.recipe_list = Recipes.recipes.getRecipeList(this.recipe.getName());
        this.accepts = Recipes.recipes.getMap_recipe_managers_itemStack(this.recipe.getName());
        this.default_accepts = this.accepts;
        if (this.recipe_list != null) {
            for (BaseMachineRecipe baseMachineRecipe : this.recipe_list) {
                IInput input = baseMachineRecipe.input;
                for (int i = 0; i < input.getInputs().size(); ++i) {
                    RecipeArrayList<IRecipeInputStack> list = this.map.get(i);
                    if (list == null) {
                        RecipeArrayList inputStackList = new RecipeArrayList();
                        inputStackList.add(new RecipeInputStack(input.getInputs().get(i)));
                        this.map.put(i, inputStackList);
                        continue;
                    }
                    list.add(new RecipeInputStack(input.getInputs().get(i)));
                }
            }
        }
        this.tile = tile;
        this.tank = null;
    }

    public InventoryRecipes(BlockEntityInventory base, String baseRecipe, IUpdateTick tile) {
        this(base, Recipes.recipes.getRecipe(baseRecipe), tile);
    }

    public InventoryRecipes(BlockEntityInventory base, String baseRecipe, IUpdateTick tile, Fluids.InternalFluidTank tank) {
        this(base, Recipes.recipes.getRecipe(baseRecipe), tile);
        this.tank = tank;
    }

    @Override
    public boolean hasItemList() {
        return true;
    }

    @Override
    public List<IInputItemStack> getStacks(int index) {
        if (!this.recipe.require()) {
            ArrayList<IInputItemStack> uniqueStacks = new ArrayList<IInputItemStack>();
            HashSet<IInputItemStack> seenStacks = new HashSet<IInputItemStack>();
            for (IInputItemStack input : this.accepts.stream().map(IRecipeInputStack::getInput).toList()) {
                boolean isNew = seenStacks.stream().noneMatch(existing -> existing.equals(input));
                if (!isNew) continue;
                seenStacks.add(input);
                uniqueStacks.add(input);
            }
            return uniqueStacks;
        }
        RecipeArrayList<IRecipeInputStack> list = this.map.get(index);
        LinkedList<IInputItemStack> stacks = new LinkedList<IInputItemStack>();
        list.forEach((? super E accept) -> stacks.add(accept.getInput()));
        return stacks;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void changeAccepts(ItemStack stack) {
        if (stack.isEmpty()) {
            this.accepts = this.default_accepts;
        } else {
            ItemRecipeSchedule itemRecipeSchedule = (ItemRecipeSchedule)stack.getItem();
            this.accepts = itemRecipeSchedule.getInputs((HolderLookup.Provider)this.base.getWorld().registryAccess(), this.recipe, stack);
        }
    }

    public IUpdateTick getTile() {
        return this.tile;
    }

    public void setInvSlotConsumableLiquidByList(InventoryFluidByList invSlotConsumableLiquidByList) {
        this.invSlotConsumableLiquidByList = invSlotConsumableLiquidByList;
    }

    public Fluids.InternalFluidTank getTank() {
        return this.tank;
    }

    public void load() {
        this.recipe_list = Recipes.recipes.getRecipeList(this.recipe.getName());
        this.map.clear();
        if (this.recipe_list != null) {
            for (BaseMachineRecipe baseMachineRecipe : this.recipe_list) {
                IInput input = baseMachineRecipe.input;
                for (int i = 0; i < input.getInputs().size(); ++i) {
                    RecipeArrayList<IRecipeInputStack> list = this.map.get(i);
                    if (list == null) {
                        RecipeArrayList inputStackList = new RecipeArrayList();
                        inputStackList.add(new RecipeInputStack(input.getInputs().get(i)));
                        this.map.put(i, inputStackList);
                        continue;
                    }
                    list.add(new RecipeInputStack(input.getInputs().get(i)));
                }
            }
        }
        if (this.invSlotConsumableLiquidByList != null) {
            this.invSlotConsumableLiquidByList.setAcceptedFluids(new HashSet<Fluid>(Recipes.recipes.getInputFluidsFromRecipe(this.recipe.getName())));
        }
        if (this.tank != null) {
            this.tank.setAcceptedFluids(Fluids.fluidPredicate(Recipes.recipes.getInputFluidsFromRecipe(this.recipe.getName())));
        }
    }

    @Override
    public ItemStack set(int index, ItemStack content) {
        super.set(index, content);
        MachineRecipe recipe1 = this.process();
        this.tile.setRecipeOutput(this.index, recipe1);
        this.tile.onUpdate();
        return content;
    }

    @Override
    public boolean acceptAllOrIndex() {
        return !this.recipe.require();
    }

    @Override
    public boolean canPlaceItem(int index, ItemStack itemStack) {
        if (index > this.recipe.getSize()) {
            return false;
        }
        if (!this.recipe.require()) {
            return !itemStack.isEmpty() && (this.recipe.getName().equals("painter") || this.recipe.getName().equals("upgradeblock") || this.recipe.getName().equals("roverupgradeblock") || this.recipe.getName().equals("recycler") || this.accepts.contains(itemStack));
        }
        RecipeArrayList<IRecipeInputStack> list = this.map.get(index);
        if (list == null) {
            return false;
        }
        return list.contains(itemStack);
    }

    public void consume(int number, int amount) {
        this.consume(number, amount, false);
    }

    public boolean continue_process(MachineRecipe recipe) {
        if (this.tank == null) {
            return Recipes.recipes.needContinue(recipe, this);
        }
        return Recipes.recipes.needContinue(recipe, this, this.tank);
    }

    public void consume(int number, int amount, boolean simulate) {
        ItemStack stack = this.get(number);
        if (!stack.isEmpty() && stack.getCount() >= 1) {
            int currentAmount = Math.min(amount, stack.getCount());
            if (!simulate) {
                stack.shrink(currentAmount);
            }
        }
    }

    @Override
    public ItemStack get(int index) {
        return super.get(index);
    }

    public MachineRecipe process() {
        if (!this.recipe.workbench()) {
            for (int i = 0; i < Math.min(this.size(), this.recipe.getSize()); ++i) {
                if (!this.get(i).isEmpty()) continue;
                return null;
            }
            MachineRecipe output = this.getOutputFor();
            if (this.tile instanceof BlockEntityConverterSolidMatter) {
                BlockEntityConverterSolidMatter mechanism = (BlockEntityConverterSolidMatter)this.tile;
                if (output != null) {
                    mechanism.getrequiredmatter(output.getRecipe().getOutput());
                }
            }
            return output;
        }
        MachineRecipe output = this.getOutputFor();
        return output;
    }

    public BaseMachineRecipe consume() {
        for (int i = 0; i < this.recipe.getSize(); ++i) {
            if (!this.get(i).isEmpty()) continue;
            return null;
        }
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < this.recipe.getSize(); ++i) {
            list.add((ItemStack)this.contents.get(i));
        }
        if (this.tank == null) {
            return Recipes.recipes.getRecipeConsume(this.recipe, this.tile.getRecipeOutput(this.index), this.recipe.consume(), list);
        }
        return Recipes.recipes.getRecipeOutputFluid(this.recipe, this.tile.getRecipeOutput(this.index), this.recipe.consume(), list, this.tank);
    }

    public boolean continue_proccess(InventoryOutput slot) {
        if (this.tile.getRecipeOutput(this.index) == null) {
            return false;
        }
        if (this.tank == null) {
            return this.tile.getRecipeOutput(this.index) != null && slot.canAdd(this.tile.getRecipeOutput((int)this.index).getRecipe().output.items) && this.get(0).getCount() >= this.tile.getRecipeOutput(this.index).getList().get(0);
        }
        return this.tile.getRecipeOutput(this.index) != null && slot.canAdd(this.tile.getRecipeOutput((int)this.index).getRecipe().output.items) && this.get(0).getCount() >= this.tile.getRecipeOutput(this.index).getList().get(0) && this.tank.getFluidAmount() >= this.tile.getRecipeOutput((int)this.index).getRecipe().input.getFluid().getAmount();
    }

    private MachineRecipe getOutputFor() {
        ArrayList<ItemStack> list = new ArrayList(this.contents);
        list = list.stream().limit(this.recipe.getSize()).collect(Collectors.toList());
        if (this.tank == null) {
            return Recipes.recipes.getRecipeMachineRecipeOutput(this.recipe, this.recipe_list, false, list);
        }
        return Recipes.recipes.getRecipeOutputMachineFluid(this.recipe, this.recipe_list, false, list, this.tank);
    }

    public IBaseRecipe getRecipe() {
        return this.recipe;
    }

    public void setRecipe(IBaseRecipe recipe) {
        this.recipe = recipe;
        this.accepts = Recipes.recipes.getMap_recipe_managers_itemStack(this.recipe.getName());
        this.load();
    }

    public void setRecipe(String recipe) {
        this.setRecipe(Recipes.recipes.getRecipe(recipe));
    }

    public List<BaseMachineRecipe> getRecipe_list() {
        return this.recipe_list;
    }

    @Override
    public EnumTypeSlot getTypeSlot(int slotid) {
        if (this.recipe.getName().equals("rotor_assembler")) {
            if (slotid == 4) {
                return EnumTypeSlot.ROD_PART1;
            }
            return EnumTypeSlot.ROD_PART;
        }
        if (this.recipe.getName().equals("water_rotor_assembler")) {
            if (slotid == 4) {
                return EnumTypeSlot.ROD_PART1;
            }
            return EnumTypeSlot.WATER_ROD_PART;
        }
        return null;
    }

    public void consume(int size, MachineRecipe output) {
        if (this.recipe.consume()) {
            if (this.recipe.workbench()) {
                for (int i = 0; i < output.getList().size(); ++i) {
                    ItemStack stack = this.get(i);
                    if (stack.isEmpty()) continue;
                    stack.shrink(size * output.getList().get(i));
                }
                if (output.getRecipe().input.getFluid() != null) {
                    this.getTank().drain(output.getRecipe().input.getFluid().getAmount() * size, IFluidHandler.FluidAction.EXECUTE);
                }
            } else {
                for (int i = 0; i < output.getList().size(); ++i) {
                    ItemStack stack = this.get(i);
                    stack.shrink(size * output.getList().get(i));
                }
                if (output.getRecipe().input.getFluid() != null) {
                    this.getTank().drain(output.getRecipe().input.getFluid().getAmount() * size, IFluidHandler.FluidAction.EXECUTE);
                }
            }
        }
    }
}

