/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.recipe;

import com.denfop.api.container.CustomWorldContainer;
import com.denfop.inventory.Inventory;
import com.denfop.utils.ModUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class InventoryOutput
extends Inventory {
    public InventoryOutput(CustomWorldContainer base1, int count) {
        super(base1, Inventory.TypeItemSlot.OUTPUT, count);
    }

    @Override
    public boolean canPlaceItem(int index, ItemStack stack) {
        return false;
    }

    @Override
    public boolean add(List<ItemStack> stacks) {
        return this.add(stacks, false);
    }

    @Override
    public boolean add(ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException("null ItemStack");
        }
        return this.add(Collections.singletonList(stack), false);
    }

    @Override
    public boolean canAdd(List<ItemStack> stacks) {
        HashSet<Item> seen = new HashSet<Item>();
        for (ItemStack stack : stacks) {
            Item item;
            if (stack == null || stack.isEmpty() || seen.contains(item = stack.getItem())) continue;
            if (!this.canAdd(stack)) {
                return false;
            }
            seen.add(item);
        }
        return true;
    }

    public void add(ItemStack stack, int size) {
        int count = size * stack.getCount();
        for (int i = 0; i < this.size(); ++i) {
            int size1;
            ItemStack slot = this.get(i);
            if (slot.isEmpty()) {
                size1 = Math.min(count, stack.getMaxStackSize());
                slot = stack.copy();
                slot.setCount(size1);
                this.set(i, slot);
                if ((count -= size1) != 0) continue;
                return;
            }
            if (!ModUtils.checkItemEquality(slot, stack) || slot.getCount() == stack.getMaxStackSize()) continue;
            if (stack.getComponents().isEmpty() && slot.getComponents().isEmpty()) {
                size1 = Math.min(count, stack.getMaxStackSize() - slot.getCount());
                this.get(i).grow(size1);
                if ((count -= size1) != 0) continue;
                return;
            }
            if (!ModUtils.checkNbtEquality(slot.getComponents(), stack.getComponents())) continue;
            size1 = Math.min(count, stack.getMaxStackSize() - slot.getCount());
            this.get(i).grow(size1);
            if ((count -= size1) != 0) continue;
            return;
        }
    }

    @Override
    public boolean canAdd(ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException("null ItemStack");
        }
        return this.add(Collections.singletonList(stack), true);
    }

    public boolean add(List<ItemStack> stacks, int size) {
        if (stacks != null && !stacks.isEmpty()) {
            for (ItemStack stack : stacks) {
                int minSlot = this.size();
                for (int i = 0; i < this.size(); ++i) {
                    if (this.get(i).isEmpty()) {
                        if (i >= minSlot) continue;
                        minSlot = i;
                        continue;
                    }
                    if (!ModUtils.checkItemEquality(this.get(i), stack) || this.get(i).getCount() + stack.getCount() * size > stack.getMaxStackSize()) continue;
                    if (stack.getComponents().isEmpty() && this.get(i).getComponents().isEmpty()) {
                        this.get(i).grow(stack.getCount() * size);
                        return true;
                    }
                    if (!ModUtils.checkNbtEquality(this.get(i).getComponents(), stack.getComponents())) continue;
                    this.get(i).grow(stack.getCount() * size);
                    return true;
                }
                if (minSlot == this.size()) continue;
                stack = stack.copy();
                stack.setCount(stack.getCount() * size);
                this.set(minSlot, stack);
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean add(List<ItemStack> stacks, boolean simulate) {
        if (stacks != null && !stacks.isEmpty()) {
            for (ItemStack stack : stacks) {
                int minSlot = this.size();
                for (int i = 0; i < this.size(); ++i) {
                    if (this.get(i).isEmpty()) {
                        if (i >= minSlot) continue;
                        minSlot = i;
                        continue;
                    }
                    if (!ModUtils.checkItemEquality(this.get(i), stack) || this.get(i).getCount() + stack.getCount() > stack.getMaxStackSize()) continue;
                    if (stack.getComponents().isEmpty() && this.get(i).getComponents().isEmpty()) {
                        if (!simulate) {
                            this.get(i).grow(stack.getCount());
                        }
                        return true;
                    }
                    if (!ModUtils.checkNbtEquality(this.get(i).getComponents(), stack.getComponents())) continue;
                    if (!simulate) {
                        this.get(i).grow(stack.getCount());
                    }
                    return true;
                }
                if (minSlot == this.size()) continue;
                if (!simulate) {
                    this.set(minSlot, stack.copy());
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean addWithoutIgnoring(List<ItemStack> stacks, boolean simulate) {
        HashSet<Item> seen = new HashSet<Item>();
        if (stacks != null && !stacks.isEmpty()) {
            LinkedList<Integer> linkedList = new LinkedList<Integer>();
            int col = 0;
            block0: for (ItemStack stack : stacks) {
                if (simulate) {
                    if (seen.contains(stack.getItem())) {
                        ++col;
                        continue;
                    }
                    seen.add(stack.getItem());
                }
                int minSlot = this.size();
                for (int i = 0; i < this.size(); ++i) {
                    if (this.get(i).isEmpty()) {
                        if (i >= minSlot || linkedList.contains(i)) continue;
                        minSlot = i;
                        continue;
                    }
                    if (!ModUtils.checkItemEquality(this.get(i), stack) || this.get(i).getCount() + stack.getCount() > stack.getMaxStackSize()) continue;
                    if (stack.getComponents().isEmpty() && this.get(i).getComponents().isEmpty()) {
                        if (!simulate) {
                            this.get(i).grow(stack.getCount());
                        }
                        ++col;
                        linkedList.add(i);
                        continue block0;
                    }
                    if (!ModUtils.checkNbtEquality(stack.getComponents(), this.get(i).getComponents())) continue;
                    if (!simulate) {
                        this.get(i).grow(stack.getCount());
                    }
                    ++col;
                    linkedList.add(i);
                    continue block0;
                }
                if (minSlot == this.size()) continue;
                if (!simulate) {
                    this.set(minSlot, stack.copy());
                }
                ++col;
                linkedList.add(minSlot);
            }
            return col == stacks.size();
        }
        return true;
    }
}

