/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.recipe;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.IInputFluid;
import com.denfop.recipe.IInputItemStack;
import com.denfop.recipe.InputItemStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;

public class InputFluid
implements IInputFluid {
    private final List<FluidStack> inputsfluid;
    private IInputItemStack stack = null;

    public InputFluid(FluidStack ... inputs) {
        this.inputsfluid = Arrays.asList(inputs);
    }

    public InputFluid(String stack) {
        this.stack = Recipes.inputFactory.getInput(stack);
        this.inputsfluid = Collections.emptyList();
    }

    public InputFluid(ItemStack stack) {
        this.stack = Recipes.inputFactory.getInput(stack);
        this.inputsfluid = Collections.emptyList();
    }

    public InputFluid(IInputItemStack stack) {
        this.stack = Recipes.inputFactory.getInput(stack);
        this.inputsfluid = Collections.emptyList();
    }

    public InputFluid(ItemStack stack, FluidStack ... inputs) {
        this.stack = Recipes.inputFactory.getInput(stack);
        this.inputsfluid = Arrays.asList(inputs);
    }

    public InputFluid(IInputItemStack stack, FluidStack ... inputs) {
        this.stack = Recipes.inputFactory.getInput(stack);
        this.inputsfluid = Arrays.asList(inputs);
    }

    public InputFluid(List<FluidStack> inputs) {
        this.inputsfluid = inputs;
    }

    @Override
    public List<FluidStack> getInputs() {
        return this.inputsfluid;
    }

    @Override
    public IInputItemStack getStack() {
        return this.stack;
    }

    public static InputFluid readNBT(CompoundTag tag, RegistryAccess access) {
        ArrayList<FluidStack> fluids = new ArrayList<FluidStack>();
        ListTag fluidsTag = tag.getList("Fluids", 10);
        for (Tag fluidTag : fluidsTag) {
            if (!(fluidTag instanceof CompoundTag)) continue;
            CompoundTag fluidCompound = (CompoundTag)fluidTag;
            if (!fluidCompound.isEmpty()) {
                fluids.add(FluidStack.parseOptional((HolderLookup.Provider)access, (CompoundTag)fluidCompound));
                continue;
            }
            fluids.add(FluidStack.EMPTY);
        }
        IInputItemStack stack = null;
        if (tag.contains("Stack", 10)) {
            stack = InputItemStack.create(tag.getCompound("Stack"), (HolderLookup.Provider)access);
        }
        InputFluid inputFluid = new InputFluid(fluids);
        if (stack != null) {
            inputFluid.setStack(stack);
        }
        return inputFluid;
    }

    private void setStack(IInputItemStack stack) {
        this.stack = stack;
    }

    @Override
    public CompoundTag writeNBT(RegistryAccess access) {
        CompoundTag tag = new CompoundTag();
        ListTag fluidsTag = new ListTag();
        for (FluidStack fluid : this.inputsfluid) {
            CompoundTag fluidTag = new CompoundTag();
            if (!fluid.isEmpty()) {
                fluid.save((HolderLookup.Provider)access, (Tag)fluidTag);
            }
            fluidsTag.add((Object)fluidTag);
        }
        tag.put("Fluids", (Tag)fluidsTag);
        if (this.stack != null) {
            tag.put("Stack", (Tag)this.stack.writeNBT((HolderLookup.Provider)access));
        }
        return tag;
    }
}

