/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.recipe;

import com.denfop.api.recipe.IInput;
import com.denfop.recipe.IInputItemStack;
import com.denfop.recipe.InputItemStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;

public class Input
implements IInput {
    private final List<IInputItemStack> list;
    private final boolean hasfluid;
    private final FluidStack fluid;
    private List<FluidStack> inputsfluid;

    public Input(FluidStack fluid, IInputItemStack ... inputs) {
        this.list = Arrays.asList(inputs);
        this.hasfluid = fluid != null;
        this.fluid = fluid;
        this.inputsfluid = null;
    }

    public Input(IInputItemStack ... inputs) {
        this((FluidStack)null, inputs);
    }

    public Input(List<IInputItemStack> inputs) {
        this(null, inputs);
    }

    public Input(FluidStack fluid, List<IInputItemStack> inputs) {
        this.list = inputs;
        this.hasfluid = fluid != null;
        this.fluid = fluid;
        this.inputsfluid = null;
    }

    public Input(FluidStack ... inputs) {
        this(new IInputItemStack[]{null});
        this.inputsfluid = Arrays.asList(inputs);
    }

    @Override
    public List<IInputItemStack> getInputs() {
        return this.list;
    }

    @Override
    public boolean hasFluids() {
        return this.hasfluid;
    }

    @Override
    public FluidStack getFluid() {
        return this.fluid;
    }

    @Override
    public List<FluidStack> getFluidInputs() {
        return this.inputsfluid;
    }

    @Override
    public List<ItemStack> getStackInputs() {
        LinkedList<ItemStack> stacks = new LinkedList<ItemStack>();
        for (IInputItemStack itemStack : this.list) {
            stacks.add(itemStack.getInputs().get(0));
        }
        return new ArrayList<ItemStack>(stacks);
    }

    public static Input readNBT(CompoundTag tag, RegistryAccess access) {
        ArrayList<IInputItemStack> inputList = new ArrayList<IInputItemStack>();
        ListTag itemsTag = tag.getList("Items", 10);
        for (Tag itemTag : itemsTag) {
            if (!(itemTag instanceof CompoundTag)) continue;
            CompoundTag compoundTag = (CompoundTag)itemTag;
            inputList.add(InputItemStack.create(compoundTag, (HolderLookup.Provider)access));
        }
        FluidStack fluid = FluidStack.EMPTY;
        if (tag.getBoolean("HasFluid") && tag.contains("Fluid", 10)) {
            fluid = FluidStack.parseOptional((HolderLookup.Provider)access, (CompoundTag)tag.getCompound("Fluid"));
        }
        return new Input(fluid, inputList.toArray(new IInputItemStack[0]));
    }

    @Override
    public CompoundTag writeNBT(RegistryAccess access) {
        CompoundTag tag = new CompoundTag();
        ListTag itemsTag = new ListTag();
        for (IInputItemStack item : this.list) {
            itemsTag.add((Object)item.writeNBT((HolderLookup.Provider)access));
        }
        tag.put("Items", (Tag)itemsTag);
        if (this.hasfluid && this.fluid != null && !this.fluid.isEmpty()) {
            CompoundTag fluidTag = new CompoundTag();
            this.fluid.save((HolderLookup.Provider)access, (Tag)fluidTag);
            tag.put("Fluid", (Tag)fluidTag);
        }
        tag.putBoolean("HasFluid", this.hasfluid);
        return tag;
    }

    @Override
    public List<ItemStack> getAllStackInputs() {
        LinkedList<ItemStack> stacks = new LinkedList<ItemStack>();
        for (IInputItemStack itemStack : this.list) {
            stacks.addAll(itemStack.getInputs());
        }
        return new ArrayList<ItemStack>(stacks);
    }
}

