/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.recipe;

import com.denfop.api.recipe.IInput;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.RecipeOutput;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class BaseMachineRecipe {
    public final IInput input;
    public final RecipeOutput output;

    public BaseMachineRecipe(IInput input, RecipeOutput output) {
        this.input = input;
        this.output = output;
    }

    public static BaseMachineRecipe readNBT(CompoundTag tag, RegistryAccess access) {
        Input input = Input.readNBT(tag.getCompound("Input"), access);
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ListTag itemsTag = tag.getList("Items", 10);
        for (Tag t : itemsTag) {
            if (!(t instanceof CompoundTag)) continue;
            CompoundTag itemTag = (CompoundTag)t;
            items.add(ItemStack.parseOptional((HolderLookup.Provider)access, (CompoundTag)itemTag));
        }
        CompoundTag metadata = tag.contains("Metadata", 10) ? tag.getCompound("Metadata") : null;
        RecipeOutput output = new RecipeOutput(metadata, items);
        return new BaseMachineRecipe(input, output);
    }

    public boolean matches(List<ItemStack> stacks) {
        for (int i = 0; i < stacks.size(); ++i) {
            if (!this.input.getInputs().get(i).matches(stacks.get(i))) continue;
            return true;
        }
        return false;
    }

    public RecipeOutput getOutput() {
        return this.output;
    }

    public CompoundTag writeNBT(RegistryAccess access) {
        CompoundTag tag = new CompoundTag();
        tag.put("Input", (Tag)this.input.writeNBT(access));
        ListTag itemsTag = new ListTag();
        if (this.output != null && this.output.items != null) {
            for (ItemStack stack : this.output.items) {
                if (stack == null || stack.isEmpty()) continue;
                itemsTag.add((Object)stack.save((HolderLookup.Provider)access, (Tag)new CompoundTag()));
            }
        }
        if (!itemsTag.isEmpty()) {
            tag.put("Items", (Tag)itemsTag);
        }
        if (this.output != null && this.output.metadata != null) {
            tag.put("Metadata", (Tag)this.output.metadata);
        }
        return tag;
    }
}

