/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.recipe;

import com.denfop.api.recipe.IInputFluid;
import com.denfop.api.recipe.InputFluid;
import com.denfop.api.recipe.RecipeOutput;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;

public class BaseFluidMachineRecipe {
    public final IInputFluid input;
    public final List<FluidStack> output_fluid;
    private final RecipeOutput output;

    public BaseFluidMachineRecipe(IInputFluid input, List<FluidStack> output) {
        this.input = input;
        this.output_fluid = output;
        this.output = null;
    }

    public BaseFluidMachineRecipe(IInputFluid input, RecipeOutput output) {
        this.input = input;
        this.output_fluid = new ArrayList<FluidStack>();
        this.output = output;
    }

    public BaseFluidMachineRecipe(IInputFluid input, RecipeOutput output, List<FluidStack> output_fluid) {
        this.input = input;
        this.output_fluid = output_fluid;
        this.output = output;
    }

    public static BaseFluidMachineRecipe readNBT(CompoundTag tag, RegistryAccess access) {
        InputFluid input = InputFluid.readNBT(tag.getCompound("Input"), access);
        ArrayList<FluidStack> fluids = new ArrayList<FluidStack>();
        ListTag fluidsTag = tag.getList("OutputFluids", 10);
        for (Tag fluidTag : fluidsTag) {
            if (!(fluidTag instanceof CompoundTag)) continue;
            CompoundTag fluidCompound = (CompoundTag)fluidTag;
            fluids.add(FluidStack.parseOptional((HolderLookup.Provider)access, (CompoundTag)fluidCompound));
        }
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ListTag itemsTag = tag.getList("OutputItems", 10);
        for (Tag itemTag : itemsTag) {
            if (!(itemTag instanceof CompoundTag)) continue;
            CompoundTag itemCompound = (CompoundTag)itemTag;
            items.add(ItemStack.parseOptional((HolderLookup.Provider)access, (CompoundTag)itemCompound));
        }
        CompoundTag metadata = tag.contains("Metadata", 10) ? tag.getCompound("Metadata") : null;
        RecipeOutput output = new RecipeOutput(metadata, items);
        return new BaseFluidMachineRecipe(input, output, fluids);
    }

    public boolean matches(List<FluidStack> stacks) {
        for (int i = 0; i < stacks.size(); ++i) {
            if (!this.input.getInputs().get(i).getFluid().equals(stacks.get(i).getFluid())) continue;
            return true;
        }
        return false;
    }

    public RecipeOutput getOutput() {
        return this.output;
    }

    public List<FluidStack> getOutput_fluid() {
        return this.output_fluid;
    }

    public IInputFluid getInput() {
        return this.input;
    }

    public CompoundTag writeNBT(RegistryAccess registryAccess) {
        CompoundTag tag = new CompoundTag();
        tag.put("Input", (Tag)this.input.writeNBT(registryAccess));
        ListTag fluidsTag = new ListTag();
        for (FluidStack fluid : this.output_fluid) {
            CompoundTag fluidTag = new CompoundTag();
            fluid.save((HolderLookup.Provider)registryAccess, (Tag)fluidTag);
            fluidsTag.add((Object)fluidTag);
        }
        tag.put("OutputFluids", (Tag)fluidsTag);
        ListTag itemsTag = new ListTag();
        if (this.output != null) {
            for (ItemStack stack : this.output.items) {
                itemsTag.add((Object)stack.save((HolderLookup.Provider)registryAccess, (Tag)new CompoundTag()));
            }
        }
        tag.put("OutputItems", (Tag)itemsTag);
        if (this.output != null && this.output.metadata != null) {
            tag.put("Metadata", (Tag)this.output.metadata);
        }
        return tag;
    }
}

