/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.reactors;

import com.denfop.api.reactors.IGasReactor;
import com.denfop.api.reactors.LogicReactor;
import com.denfop.blocks.FluidName;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class LogicGasReactor
extends LogicReactor {
    private final IGasReactor gasReactor;
    public double temp_heat = 0.0;

    public LogicGasReactor(IGasReactor advReactor) {
        super(advReactor);
        this.gasReactor = advReactor;
    }

    public double getTemp_heat() {
        return this.temp_heat;
    }

    public void setTemp_heat(double temp_heat) {
        this.temp_heat = temp_heat;
    }

    @Override
    public void onTick() {
        double log = Math.log(this.gasReactor.getTemperatureRefrigerator()) / Math.log(4.0);
        if (log == Double.NEGATIVE_INFINITY) {
            log = 1.0;
        }
        double temp = (double)this.generation * 1.175;
        if (this.rodsList.isEmpty()) {
            if (this.temp_heat >= 1.0) {
                this.temp_heat -= (double)rand.nextInt((int)this.temp_heat);
            }
            this.reactor.setOutput(0.0);
        } else if (log > 0.0 && (double)this.gasReactor.getHeliumTank().getFluidAmount() >= 5.0 * log) {
            int energy;
            int j;
            super.onTick();
            if (!this.gasReactor.isFull()) {
                return;
            }
            this.gasReactor.getHeliumTank().drain((int)(5.0 * log), IFluidHandler.FluidAction.EXECUTE);
            if (this.temp_heat <= this.getMaxHeat()) {
                this.temp_heat += (double)rand.nextInt(Math.max((int)(this.getMaxHeat() - this.temp_heat), 4));
                if (this.temp_heat > this.getMaxHeat()) {
                    this.temp_heat = this.getMaxHeat();
                }
            }
            if (rand.nextInt(100) >= 80) {
                this.gasReactor.addHeliumToRegenerate((int)(5.0 * log));
            } else {
                this.gasReactor.addHeliumToRegenerate((int)(4.0 * log));
            }
            for (j = 0; j < this.gasReactor.getLengthCompressors(); ++j) {
                energy = this.gasReactor.getEnergyCompressor(j);
                if (!(temp >= (double)energy)) continue;
                temp -= (double)energy;
                int col = this.gasReactor.getHeliumToRegenerate();
                if (col <= 0 || this.gasReactor.getHeliumTank().getFluidAmount() + col * this.gasReactor.getPressure(j) > this.gasReactor.getCapacityHelium()) continue;
                this.gasReactor.getHeliumTank().fill(new FluidStack((Fluid)FluidName.fluidhelium.getInstance().get(), col * this.gasReactor.getPressure(j)), IFluidHandler.FluidAction.EXECUTE);
                this.gasReactor.addHeliumToRegenerate(-col * this.gasReactor.getPressure(j));
            }
            if (this.gasReactor.hasPump()) {
                int power;
                for (j = 0; j < this.gasReactor.getLengthPump(); ++j) {
                    energy = this.gasReactor.getEnergyPump(j);
                    if (energy <= 0 || !(temp >= (double)energy)) continue;
                    temp -= (double)energy;
                    power = this.gasReactor.getPowerPump(j);
                    if (this.gasReactor.getHydrogenTank(j).getFluidAmount() + 2 * power > this.gasReactor.getHydrogenTank(j).getCapacity() || this.gasReactor.getOxygenTank(j).getFluidAmount() + power > this.gasReactor.getOxygenTank(j).getCapacity() || this.gasReactor.getWaterTank(j).getFluidAmount() <= 2 * power) continue;
                    this.gasReactor.getWaterTank(j).drain(2 * power, IFluidHandler.FluidAction.EXECUTE);
                    this.gasReactor.getHydrogenTank(j).fill(new FluidStack((Fluid)FluidName.fluidhydrogen.getInstance().get(), 2 * power), IFluidHandler.FluidAction.EXECUTE);
                    this.gasReactor.getOxygenTank(j).fill(new FluidStack((Fluid)FluidName.fluidoxygen.getInstance().get(), power), IFluidHandler.FluidAction.EXECUTE);
                    this.gasReactor.damagePump(j);
                }
                if (this.gasReactor.hasFan()) {
                    for (j = 0; j < this.gasReactor.getLengthFan(); ++j) {
                        energy = this.gasReactor.getEnergyFan(j);
                        if (energy <= 0 || !(temp >= (double)energy)) continue;
                        temp -= (double)energy;
                        power = this.gasReactor.getPowerFan(j);
                        int col = 0;
                        for (int jj = 0; jj < this.gasReactor.getLengthPump() && col < power; ++jj) {
                            if (this.gasReactor.getWaterTank(jj).getFluidAmount() <= 0) continue;
                            int temp1 = Math.min(this.gasReactor.getWaterTank(jj).getFluidAmount(), power - col);
                            this.gasReactor.getWaterTank(jj).drain(temp1, IFluidHandler.FluidAction.EXECUTE);
                            col += temp1;
                        }
                        if (col <= 0) continue;
                        this.temp_heat -= (double)rand.nextInt(30 * col);
                        this.temp_heat = Math.max(1.0, this.temp_heat);
                        this.gasReactor.damageFan(j);
                    }
                }
            }
            if (temp < 0.0) {
                temp = 0.0;
            }
            this.gasReactor.setOutput(temp);
        } else {
            if (!this.rodsList.isEmpty()) {
                this.temp_heat += (double)rand.nextInt(200);
                if (this.temp_heat > (double)this.gasReactor.getMaxHeat()) {
                    this.temp_heat = this.gasReactor.getMaxHeat();
                }
            }
            this.gasReactor.setOutput(0.0);
        }
        this.gasReactor.setHeat(this.temp_heat);
    }
}

