/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.pollution.radiation;

import com.denfop.api.item.armor.HazmatLike;
import com.denfop.api.pollution.radiation.EnumCoefficient;
import com.denfop.api.pollution.radiation.EnumLevelRadiation;
import com.denfop.config.ModConfig;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketRadiationUpdateValue;
import com.denfop.network.packet.PacketUpdateRadiation;
import com.denfop.potion.IUPotion;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class Radiation {
    private static final Random rand = new Random();
    private final ChunkPos pos;
    private double radiation;
    private EnumLevelRadiation level;
    private EnumCoefficient coef;

    public Radiation(ChunkPos pos) {
        this.radiation = 0.0;
        this.level = EnumLevelRadiation.LOW;
        this.coef = EnumCoefficient.NANO;
        this.pos = pos;
    }

    public Radiation(CompoundTag tagCompound) {
        this.radiation = tagCompound.getDouble("radiation");
        this.level = EnumLevelRadiation.values()[tagCompound.getByte("level")];
        this.coef = EnumCoefficient.values()[tagCompound.getByte("coef")];
        this.pos = new ChunkPos(tagCompound.getInt("x"), tagCompound.getInt("z"));
    }

    public Radiation(CustomPacketBuffer packetBuffer) {
        this.radiation = (double)packetBuffer.readShort() / 32.5;
        byte levelAndCoef = packetBuffer.readByte();
        this.level = EnumLevelRadiation.values()[levelAndCoef & 7];
        this.coef = EnumCoefficient.values()[levelAndCoef >> 3 & 7];
        this.pos = new ChunkPos((int)packetBuffer.readShort(), (int)packetBuffer.readShort());
    }

    public CustomPacketBuffer writePacket(CustomPacketBuffer os) {
        CustomPacketBuffer customPacketBuffer = new CustomPacketBuffer(os.registryAccess());
        customPacketBuffer.writeShort((short)(this.radiation * 32.5));
        byte levelAndCoef = (byte)(this.level.ordinal() & 7 | (this.coef.ordinal() & 7) << 3);
        customPacketBuffer.writeByte(levelAndCoef);
        customPacketBuffer.writeShort((short)this.pos.x);
        customPacketBuffer.writeShort((short)this.pos.z);
        return customPacketBuffer;
    }

    public ChunkPos getPos() {
        return this.pos;
    }

    public EnumCoefficient getCoef() {
        return this.coef;
    }

    public void setCoef(EnumCoefficient coef) {
        this.coef = coef;
    }

    public EnumLevelRadiation getLevel() {
        return this.level;
    }

    public void setLevel(EnumLevelRadiation level) {
        this.level = level;
    }

    public double getRadiation() {
        return this.radiation;
    }

    public void setRadiation(double radiation) {
        this.radiation = radiation;
    }

    public boolean removeRadiationWithType(double radiation, Level level) {
        boolean removed;
        if (this.level == EnumLevelRadiation.LOW) {
            if (this.radiation == 999.0 && radiation == 1000.0) {
                this.radiation = 0.0;
                new PacketUpdateRadiation(this, (ServerLevel)level);
                return true;
            }
            if (this.radiation < radiation) {
                return false;
            }
        }
        if (this.level == EnumLevelRadiation.DEFAULT) {
            radiation /= 10.0;
        }
        if (this.level == EnumLevelRadiation.MEDIUM) {
            radiation /= 100.0;
        }
        if (this.level == EnumLevelRadiation.HIGH) {
            radiation /= 1000.0;
        }
        if (this.level == EnumLevelRadiation.VERY_HIGH) {
            radiation /= 10000.0;
        }
        if (this.radiation - radiation == 0.0) {
            this.radiation = this.level != EnumLevelRadiation.LOW ? 1000.0 : 0.0;
            this.level = EnumLevelRadiation.values()[Math.max(this.level.ordinal() - 1, 0)];
            this.coef = EnumCoefficient.values()[Math.max(this.coef.ordinal() - 1, 0)];
            removed = true;
        } else if (this.radiation - radiation < 0.0) {
            this.radiation = 1000.0 - (radiation - this.radiation);
            this.level = EnumLevelRadiation.values()[Math.max(this.level.ordinal() - 1, 0)];
            this.coef = EnumCoefficient.values()[Math.max(this.coef.ordinal() - 1, 0)];
            removed = true;
        } else {
            this.radiation -= radiation;
            radiation = 0.0;
            removed = true;
        }
        new PacketUpdateRadiation(this, (ServerLevel)level);
        return removed;
    }

    public void removeRadiation(double radiation) {
        while (radiation > 0.0 && (this.radiation != 0.0 || this.getLevel() != EnumLevelRadiation.LOW)) {
            if (this.radiation - radiation == 0.0) {
                radiation = 0.0;
                this.radiation = 1000.0;
                this.level = EnumLevelRadiation.values()[Math.max(this.level.ordinal() - 1, 0)];
                this.coef = EnumCoefficient.values()[Math.max(this.coef.ordinal() - 1, 0)];
                continue;
            }
            if (this.radiation - radiation < 0.0) {
                this.radiation = 1000.0;
                radiation -= this.radiation;
                this.level = EnumLevelRadiation.values()[Math.max(this.level.ordinal() - 1, 0)];
                this.coef = EnumCoefficient.values()[Math.max(this.coef.ordinal() - 1, 0)];
                continue;
            }
            this.radiation -= radiation;
            radiation = 0.0;
        }
    }

    public void addRadiation(double radiation) {
        while (radiation > 0.0) {
            if (this.level == EnumLevelRadiation.DEFAULT) {
                radiation /= 10.0;
            }
            if (this.level == EnumLevelRadiation.MEDIUM) {
                radiation /= 100.0;
            }
            if (this.level == EnumLevelRadiation.HIGH) {
                radiation /= 1000.0;
            }
            if (this.level == EnumLevelRadiation.VERY_HIGH) {
                radiation /= 10000.0;
            }
            if (this.radiation + radiation == 1000.0) {
                radiation = 0.0;
                this.level = EnumLevelRadiation.values()[Math.min(this.level.ordinal() + 1, EnumLevelRadiation.values().length - 1)];
                this.coef = EnumCoefficient.values()[Math.min(this.coef.ordinal() + 1, EnumCoefficient.values().length - 1)];
                continue;
            }
            if (this.radiation + radiation > 1000.0) {
                this.radiation = 0.0;
                radiation -= 1000.0 - this.radiation;
                this.level = EnumLevelRadiation.values()[Math.min(this.level.ordinal() + 1, EnumLevelRadiation.values().length - 1)];
                this.coef = EnumCoefficient.values()[Math.min(this.coef.ordinal() + 1, EnumCoefficient.values().length - 1)];
                continue;
            }
            this.radiation += radiation;
            radiation = 0.0;
        }
    }

    public void process(Player player) {
        if (!((Boolean)ModConfig.COMMON.radiationAccumulationEnabled.get()).booleanValue()) {
            return;
        }
        boolean need = HazmatLike.hasCompleteHazmat((LivingEntity)player, this.level);
        CompoundTag nbt = player.getPersistentData();
        double radiation = nbt.getDouble("radiation");
        if (!need) {
            switch (this.level) {
                case MEDIUM: {
                    int num = rand.nextInt(4);
                    nbt.putDouble("radiation", radiation + (double)0.02f);
                    new PacketRadiationUpdateValue(player, radiation + 0.02);
                    if (!((Boolean)ModConfig.COMMON.radiationDamageEnabled.get()).booleanValue()) {
                        return;
                    }
                    switch (num) {
                        case 0: {
                            player.addEffect(new MobEffectInstance(MobEffects.HUNGER, 200, 0));
                            break;
                        }
                        case 1: {
                            player.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 200, 0));
                            break;
                        }
                        case 2: {
                            player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 200, 0));
                            break;
                        }
                        case 3: {
                            player.addEffect(new MobEffectInstance(MobEffects.POISON, 200, 0));
                        }
                    }
                    break;
                }
                case HIGH: {
                    int num = rand.nextInt(4);
                    nbt.putDouble("radiation", radiation + (double)0.02f);
                    new PacketRadiationUpdateValue(player, radiation + 0.2);
                    if (!((Boolean)ModConfig.COMMON.radiationDamageEnabled.get()).booleanValue()) {
                        return;
                    }
                    switch (num) {
                        case 0: {
                            player.addEffect(new MobEffectInstance(MobEffects.HUNGER, 200, 0));
                            break;
                        }
                        case 1: {
                            player.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 200, 0));
                            break;
                        }
                        case 2: {
                            player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 200, 0));
                            break;
                        }
                        case 3: {
                            player.addEffect(new MobEffectInstance(MobEffects.POISON, 200, 0));
                        }
                    }
                    player.addEffect(new MobEffectInstance(IUPotion.rad, 200, 0));
                    break;
                }
                case VERY_HIGH: {
                    int num = rand.nextInt(4);
                    nbt.putDouble("radiation", radiation + (double)0.02f);
                    new PacketRadiationUpdateValue(player, radiation + 2.0);
                    if (!((Boolean)ModConfig.COMMON.radiationDamageEnabled.get()).booleanValue()) {
                        return;
                    }
                    switch (num) {
                        case 0: {
                            player.addEffect(new MobEffectInstance(MobEffects.HUNGER, 200, 0));
                            break;
                        }
                        case 1: {
                            player.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 200, 0));
                            break;
                        }
                        case 2: {
                            player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 200, 0));
                            break;
                        }
                        case 3: {
                            player.addEffect(new MobEffectInstance(MobEffects.POISON, 200, 0));
                        }
                    }
                    player.addEffect(new MobEffectInstance(IUPotion.rad, 43200, 0));
                    player.addEffect(new MobEffectInstance(MobEffects.WITHER, 400, 0));
                    break;
                }
            }
        }
    }

    public CompoundTag writeCompound() {
        CompoundTag tag = new CompoundTag();
        tag.putDouble("radiation", this.radiation);
        tag.putByte("level", (byte)this.level.ordinal());
        tag.putByte("coef", (byte)this.coef.ordinal());
        tag.putInt("x", this.pos.x);
        tag.putInt("z", this.pos.z);
        return tag;
    }
}

