/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.pollution;

import com.denfop.api.pollution.EventHandler;
import com.denfop.api.pollution.PollutionMechanism;
import com.denfop.api.pollution.component.ChunkLevel;
import com.denfop.api.pollution.component.LevelPollution;
import com.denfop.api.pollution.utils.Vec2f;
import com.denfop.api.windsystem.EnumTypeWind;
import com.denfop.api.windsystem.EnumWindSide;
import com.denfop.api.windsystem.IWindSystem;
import com.denfop.api.windsystem.WindSystem;
import com.denfop.config.ModConfig;
import com.denfop.potion.IUPotion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.NeoForge;

public class PollutionManager {
    public static PollutionManager pollutionManager;
    private final IWindSystem wind;
    private final Random random;
    Map<ChunkPos, ChunkLevel> pollutionAir = new HashMap<ChunkPos, ChunkLevel>();
    Map<ChunkPos, List<PollutionMechanism>> pollutionAirChunks = new HashMap<ChunkPos, List<PollutionMechanism>>();
    Map<ChunkPos, List<PollutionMechanism>> pollutionSoilChunks = new HashMap<ChunkPos, List<PollutionMechanism>>();
    Map<ChunkPos, ChunkLevel> pollutionSoil = new HashMap<ChunkPos, ChunkLevel>();

    public PollutionManager() {
        this.wind = WindSystem.windSystem;
        this.random = new Random();
        NeoForge.EVENT_BUS.register((Object)new EventHandler());
    }

    public void work(Player player) {
        if (player.level().dimension() != Level.OVERWORLD || player.level().isClientSide) {
            return;
        }
        if (player.level().getGameTime() % 200L == 0L) {
            ChunkPos pos = new ChunkPos(player.blockPosition());
            ChunkLevel pollution = this.pollutionSoil.get(pos);
            if (((Boolean)ModConfig.COMMON.soilPollution.get()).booleanValue() && pollution != null && pollution.getLevelPollution().ordinal() >= 2) {
                player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 200, 0));
                if (pollution.getLevelPollution().ordinal() >= 3) {
                    player.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 200, 0));
                    if (pollution.getLevelPollution().ordinal() >= 4) {
                        player.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 200, 0));
                    }
                }
            }
            pollution = this.pollutionAir.get(pos);
            if (((Boolean)ModConfig.COMMON.airPollution.get()).booleanValue() && pollution != null && pollution.getLevelPollution().ordinal() >= 2) {
                player.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 200, 0));
                if (pollution.getLevelPollution().ordinal() >= 3) {
                    player.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 200, 0));
                    if (pollution.getLevelPollution().ordinal() >= 4) {
                        player.addEffect(new MobEffectInstance(IUPotion.poison, 200, 0));
                    }
                }
            }
        }
    }

    public void addAirPollutionMechanism(PollutionMechanism pollutionMechanism) {
        List<PollutionMechanism> pollution = this.pollutionAirChunks.get(pollutionMechanism.getChunkPos());
        if (pollution == null) {
            pollution = new ArrayList<PollutionMechanism>();
            pollution.add(pollutionMechanism);
            this.pollutionAirChunks.put(pollutionMechanism.getChunkPos(), pollution);
        } else {
            pollution.add(pollutionMechanism);
        }
    }

    public void removeAirPollutionMechanism(PollutionMechanism pollutionMechanism) {
        if (pollutionMechanism == null) {
            return;
        }
        List pollution = this.pollutionAirChunks.computeIfAbsent(pollutionMechanism.getChunkPos(), k -> new ArrayList());
        pollution.remove(pollutionMechanism);
    }

    public void removeSoilPollutionMechanism(PollutionMechanism pollutionMechanism) {
        if (pollutionMechanism == null) {
            return;
        }
        List pollution = this.pollutionSoilChunks.computeIfAbsent(pollutionMechanism.getChunkPos(), k -> new ArrayList());
        pollution.remove(pollutionMechanism);
    }

    public void loadData(CompoundTag tagCompound) {
        ChunkLevel chunkLevel;
        int i;
        this.pollutionSoil.clear();
        this.pollutionAir.clear();
        this.pollutionAirChunks.clear();
        this.pollutionSoilChunks.clear();
        CompoundTag soil = tagCompound.getCompound("soil");
        CompoundTag air = tagCompound.getCompound("air");
        int size = soil.getInt("size");
        int size1 = air.getInt("size");
        for (i = 0; i < size; ++i) {
            chunkLevel = new ChunkLevel(soil.getCompound(String.valueOf(i)));
            this.pollutionSoil.put(chunkLevel.getPos(), chunkLevel);
        }
        for (i = 0; i < size1; ++i) {
            chunkLevel = new ChunkLevel(air.getCompound(String.valueOf(i)));
            this.pollutionAir.put(chunkLevel.getPos(), chunkLevel);
        }
    }

    public CompoundTag writeCompound() {
        CompoundTag nbtTagCompound = new CompoundTag();
        CompoundTag soil = new CompoundTag();
        CompoundTag air = new CompoundTag();
        try {
            ChunkLevel chunkLevel;
            int i;
            List<ChunkLevel> pollutionSoilChunk = this.pollutionSoil.values().stream().toList();
            List<ChunkLevel> pollutionAirChunk = this.pollutionAir.values().stream().toList();
            soil.putInt("size", pollutionSoilChunk.size());
            air.putInt("size", pollutionAirChunk.size());
            for (i = 0; i < pollutionSoilChunk.size(); ++i) {
                chunkLevel = pollutionSoilChunk.get(i);
                if (chunkLevel == null) continue;
                soil.put(String.valueOf(i), (Tag)chunkLevel.writeCompound());
            }
            for (i = 0; i < pollutionAirChunk.size(); ++i) {
                chunkLevel = pollutionAirChunk.get(i);
                if (chunkLevel == null) continue;
                air.put(String.valueOf(i), (Tag)chunkLevel.writeCompound());
            }
            nbtTagCompound.put("air", (Tag)air);
            nbtTagCompound.put("soil", (Tag)soil);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nbtTagCompound;
    }

    public void addSoilPollutionMechanism(PollutionMechanism pollutionMechanism) {
        if (pollutionMechanism == null) {
            return;
        }
        List<PollutionMechanism> pollution = this.pollutionSoilChunks.get(pollutionMechanism.getChunkPos());
        if (pollution == null) {
            pollution = new ArrayList<PollutionMechanism>();
            pollution.add(pollutionMechanism);
            this.pollutionSoilChunks.put(pollutionMechanism.getChunkPos(), pollution);
        } else {
            pollution.add(pollutionMechanism);
        }
    }

    public ChunkLevel getChunkLevelAir(ChunkPos chunkPos) {
        return this.pollutionAir.get(chunkPos);
    }

    public ChunkLevel getChunkLevelSoil(ChunkPos chunkPos) {
        return this.pollutionSoil.get(chunkPos);
    }

    public void addChunkLevelSoil(ChunkLevel level) {
        this.pollutionSoil.put(level.getPos(), level);
    }

    public Vec2f getVector(EnumWindSide windSide) {
        switch (windSide) {
            case E: {
                return new Vec2f(1.0f, 0.0f);
            }
            case W: {
                return new Vec2f(-1.0f, 0.0f);
            }
            case N: {
                return new Vec2f(0.0f, 1.0f);
            }
            case S: {
                return new Vec2f(0.0f, -1.0f);
            }
            case NE: {
                return new Vec2f(1.0f, 1.0f);
            }
            case NW: {
                return new Vec2f(-1.0f, 1.0f);
            }
            case SE: {
                return new Vec2f(1.0f, -1.0f);
            }
            case SW: {
                return new Vec2f(-1.0f, -1.0f);
            }
        }
        return new Vec2f(0.0f, 0.0f);
    }

    public void tick(Level world) {
        ChunkLevel chunkLevel;
        if (world.getGameTime() % 20L != 0L) {
            return;
        }
        HashSet<Map.Entry<ChunkPos, ChunkLevel>> entries = new HashSet<Map.Entry<ChunkPos, ChunkLevel>>(this.pollutionAir.entrySet());
        EnumWindSide windSide = this.wind.getWindSide();
        Vec2f vector = this.getVector(windSide);
        EnumTypeWind windLevel = this.wind.getEnumTypeWind();
        if (((Boolean)ModConfig.COMMON.airPollution.get()).booleanValue()) {
            entries.parallelStream().forEach(entry -> {
                ChunkLevel chunkLevel = (ChunkLevel)entry.getValue();
                double distance = this.calculateDistance(chunkLevel.getDefaultPos(), chunkLevel.getPos());
                if (this.canChange(windLevel) && distance <= 10.0) {
                    this.pollutionAir.remove(entry.getKey());
                    chunkLevel.addChunkPos((int)vector.x, (int)vector.y);
                    this.pollutionAir.put(chunkLevel.getPos(), chunkLevel);
                }
            });
        }
        if (((Boolean)ModConfig.COMMON.soilPollution.get()).booleanValue() && world.getGameTime() % 6000L == 0L) {
            for (Map.Entry<ChunkPos, ChunkLevel> entry2 : this.pollutionSoil.entrySet()) {
                chunkLevel = entry2.getValue();
                if (chunkLevel == null) continue;
                chunkLevel.setPollution(chunkLevel.getPollution() / 2.0);
                if (!(chunkLevel.getPollution() < 2.0) || chunkLevel.getLevelPollution() == LevelPollution.VERY_LOW) continue;
                chunkLevel.setPollution(10.0);
                chunkLevel.setLevelPollution(LevelPollution.values()[Math.max(0, chunkLevel.getLevelPollution().ordinal() - 1)]);
            }
        }
        if (((Boolean)ModConfig.COMMON.airPollution.get()).booleanValue() && world.getGameTime() % 6000L == 0L) {
            for (Map.Entry<ChunkPos, Object> entry3 : this.pollutionAir.entrySet()) {
                chunkLevel = (ChunkLevel)entry3.getValue();
                if (chunkLevel == null) continue;
                chunkLevel.setPollution(chunkLevel.getPollution() / 2.0);
                if (!(chunkLevel.getPollution() < 2.0) || chunkLevel.getLevelPollution() == LevelPollution.VERY_LOW) continue;
                chunkLevel.setPollution(10.0);
                chunkLevel.setLevelPollution(LevelPollution.values()[Math.max(0, chunkLevel.getLevelPollution().ordinal() - 1)]);
            }
        }
        if (((Boolean)ModConfig.COMMON.airPollution.get()).booleanValue()) {
            for (Map.Entry<ChunkPos, Object> entry4 : this.pollutionAirChunks.entrySet()) {
                chunkLevel = this.pollutionAir.get(entry4.getKey());
                if (chunkLevel == null) {
                    chunkLevel = new ChunkLevel(entry4.getKey(), LevelPollution.VERY_LOW, 0.0);
                    for (PollutionMechanism pollutionMechanism : (List)entry4.getValue()) {
                        chunkLevel.addPollution(pollutionMechanism.getPollution());
                    }
                    this.pollutionAir.put(chunkLevel.getPos(), chunkLevel);
                    continue;
                }
                for (PollutionMechanism pollutionMechanism : (List)entry4.getValue()) {
                    chunkLevel.addPollution(pollutionMechanism.getPollution());
                }
            }
        }
        if (((Boolean)ModConfig.COMMON.soilPollution.get()).booleanValue()) {
            for (Map.Entry<ChunkPos, Object> entry5 : this.pollutionSoilChunks.entrySet()) {
                chunkLevel = this.pollutionSoil.get(entry5.getKey());
                if (chunkLevel == null) {
                    chunkLevel = new ChunkLevel(entry5.getKey(), LevelPollution.VERY_LOW, 0.0);
                    for (PollutionMechanism pollutionMechanism : (List)entry5.getValue()) {
                        chunkLevel.addPollution(pollutionMechanism.getPollution());
                    }
                    this.pollutionSoil.put(chunkLevel.getPos(), chunkLevel);
                    continue;
                }
                for (PollutionMechanism pollutionMechanism : (List)entry5.getValue()) {
                    chunkLevel.addPollution(pollutionMechanism.getPollution());
                }
            }
        }
    }

    public double calculateDistance(ChunkPos pos1, ChunkPos pos2) {
        int xDiff = pos1.x - pos2.x;
        int zDiff = pos1.z - pos2.z;
        return Math.sqrt(xDiff * xDiff + zDiff * zDiff);
    }

    private boolean canChange(EnumTypeWind windLevel) {
        return this.random.nextInt(100 - windLevel.ordinal() * 5) == 0;
    }
}

