/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.otherenergies.transport;

import com.denfop.api.otherenergies.transport.EventHandler;
import com.denfop.api.otherenergies.transport.ITransportNet;
import com.denfop.api.otherenergies.transport.ITransportTile;
import com.denfop.api.otherenergies.transport.TransportNetLocal;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TransportNetGlobal
implements ITransportNet {
    public static TransportNetGlobal instance;
    private static Map<ResourceKey<Level>, TransportNetLocal> worldToEnergyNetMap;

    public static TransportNetGlobal initialize() {
        new EventHandler();
        instance = new TransportNetGlobal();
        return instance;
    }

    public static void onWorldUnload(Level world) {
        TransportNetLocal local = worldToEnergyNetMap.remove(world.dimension());
        if (local != null) {
            local.onUnload();
        }
    }

    public static TransportNetLocal getForWorld(Level world) {
        if (world == null) {
            return null;
        }
        if (!worldToEnergyNetMap.containsKey(world.dimension())) {
            worldToEnergyNetMap.put((ResourceKey<Level>)world.dimension(), new TransportNetLocal(world));
        }
        return worldToEnergyNetMap.get(world.dimension());
    }

    public static void onTickEnd(Level world) {
        TransportNetLocal energyNet = TransportNetGlobal.getForWorld(world);
        if (energyNet != null) {
            energyNet.onTickEnd();
        }
    }

    @Override
    public ITransportTile getSubTile(Level var1, BlockPos var2) {
        TransportNetLocal local = TransportNetGlobal.getForWorld(var1);
        if (local != null) {
            return local.getTileEntity(var2);
        }
        return null;
    }

    @Override
    public <T extends BlockEntity> void addTile(T var1) {
        TransportNetLocal local = TransportNetGlobal.getForWorld(var1.getLevel());
        local.addTile((ITransportTile)var1);
    }

    @Override
    public void removeTile(ITransportTile var1) {
        TransportNetLocal local = TransportNetGlobal.getForWorld(((BlockEntity)var1).getLevel());
        local.removeTile(var1);
    }

    static {
        worldToEnergyNetMap = new WeakHashMap<ResourceKey<Level>, TransportNetLocal>();
    }
}

