/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.otherenergies.heat;

import com.denfop.api.otherenergies.heat.EventHandler;
import com.denfop.api.otherenergies.heat.HeatNetLocal;
import com.denfop.api.otherenergies.heat.IHeatNet;
import com.denfop.api.otherenergies.heat.IHeatTile;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class HeatNetGlobal
implements IHeatNet {
    private static Map<ResourceKey<Level>, HeatNetLocal> worldToEnergyNetMap = new WeakHashMap<ResourceKey<Level>, HeatNetLocal>();

    public static HeatNetGlobal initialize() {
        new EventHandler();
        return new HeatNetGlobal();
    }

    public static void onWorldUnload(Level world) {
        HeatNetLocal local = worldToEnergyNetMap.remove(world.dimension());
        if (local != null) {
            local.onUnload();
        }
    }

    public static HeatNetLocal getForWorld(Level world) {
        if (world == null) {
            return null;
        }
        if (!worldToEnergyNetMap.containsKey(world.dimension())) {
            worldToEnergyNetMap.put((ResourceKey<Level>)world.dimension(), new HeatNetLocal());
        }
        return worldToEnergyNetMap.get(world.dimension());
    }

    public static void onTickEnd(Level world) {
        HeatNetLocal energyNet = HeatNetGlobal.getForWorld(world);
        if (energyNet != null) {
            energyNet.onTickEnd();
        }
    }

    @Override
    public IHeatTile getSubTile(Level var1, BlockPos var2) {
        HeatNetLocal local = HeatNetGlobal.getForWorld(var1);
        if (local != null) {
            return local.getTileEntity(var2);
        }
        return null;
    }
}

