/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.otherenergies.heat;

import com.denfop.api.otherenergies.heat.HeatNetGlobal;
import com.denfop.api.otherenergies.heat.HeatNetLocal;
import com.denfop.api.otherenergies.heat.event.HeatTileLoadEvent;
import com.denfop.api.otherenergies.heat.event.HeatTileUnloadEvent;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

public class EventHandler {
    public EventHandler() {
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onEnergyTileLoad(HeatTileLoadEvent event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        HeatNetLocal local = HeatNetGlobal.getForWorld((Level)event.getLevel());
        if (local != null) {
            local.addTile(event.tile);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onEnergyTileUnload(HeatTileUnloadEvent event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        HeatNetLocal local = HeatNetGlobal.getForWorld((Level)event.getLevel());
        if (local != null) {
            local.removeTile(event.tile);
        }
    }

    @SubscribeEvent
    public void tick(LevelTickEvent.Post event) {
        if (event.getLevel().isClientSide) {
            return;
        }
        HeatNetGlobal.onTickEnd(event.getLevel());
    }

    @SubscribeEvent
    public void onWorldUnload(LevelEvent.Unload event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        HeatNetGlobal.onWorldUnload((Level)event.getLevel());
    }
}

