/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.item.upgrade;

import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.IOException;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class UpgradeModificator {
    public static final Codec<UpgradeModificator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("item").forGetter(mod -> mod.itemstack), (App)Codec.STRING.fieldOf("type").forGetter(mod -> mod.type)).apply((Applicative)instance, UpgradeModificator::new));
    public static final StreamCodec<FriendlyByteBuf, UpgradeModificator> STREAM_CODEC = StreamCodec.of((buf, value) -> {
        CustomPacketBuffer customPacketBuffer = new CustomPacketBuffer((FriendlyByteBuf)buf);
        try {
            EncoderHandler.encode(customPacketBuffer, value.itemstack);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        buf.writeUtf(value.type);
    }, buf -> {
        try {
            return new UpgradeModificator((Item)DecoderHandler.decode(new CustomPacketBuffer((FriendlyByteBuf)buf)), buf.readUtf());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    });
    public final Item itemstack;
    public final String type;

    public UpgradeModificator(Item stack, String type) {
        this.itemstack = stack;
        this.type = type;
    }

    public boolean matches(ItemStack stack) {
        return this.itemstack == stack.getItem();
    }

    public boolean matches(String type) {
        return this.type.equals(type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpgradeModificator that = (UpgradeModificator)o;
        return this.itemstack == that.itemstack;
    }
}

