/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.item.upgrade;

import com.denfop.api.item.upgrade.UpgradeSystem;
import com.denfop.datacomponent.DataComponentsInit;
import net.minecraft.world.item.ItemStack;

public interface LevelInstruments {
    default public int getLevel(ItemStack stack) {
        return (Integer)stack.getOrDefault(DataComponentsInit.LEVEL, (Object)0);
    }

    default public int getExperience(ItemStack stack) {
        return (Integer)stack.getOrDefault(DataComponentsInit.EXPERIENCE, (Object)0);
    }

    default public int getMaxLevel(ItemStack stack) {
        int level = this.getLevel(stack);
        if (level >= 30) {
            return Integer.MAX_VALUE;
        }
        return (int)(Math.pow(2.0, Math.log(Math.exp(Math.log(level + 1)))) * (150.0 * Math.log(Math.pow(8.0, level + 1))));
    }

    default public void addExperience(ItemStack stack, int experience) {
        int exp = this.getExperience(stack) + experience;
        int maxLevel = this.getMaxLevel(stack);
        if (maxLevel == Integer.MAX_VALUE) {
            return;
        }
        if (maxLevel < exp) {
            exp -= maxLevel;
            stack.set(DataComponentsInit.LEVEL, (Object)(this.getLevel(stack) + 1));
            UpgradeSystem.system.updateLevel(stack);
        }
        stack.set(DataComponentsInit.EXPERIENCE, (Object)exp);
    }
}

