/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.item.armor;

import com.denfop.api.pollution.radiation.EnumLevelRadiation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface HazmatLike {
    public static boolean hasCompleteHazmat(LivingEntity living) {
        return HazmatLike.hasCompleteHazmat(living, EnumLevelRadiation.LOW);
    }

    public static boolean hasCompleteHazmat(LivingEntity living, EnumLevelRadiation levelRadiation) {
        EquipmentSlot[] var1 = EquipmentSlot.values();
        int var2 = var1.length;
        block8: for (EquipmentSlot slot : var1) {
            Item item;
            if (slot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR) continue;
            ItemStack stack = living.getItemBySlot(slot);
            if (stack.isEmpty() || !((item = stack.getItem()) instanceof HazmatLike)) {
                return false;
            }
            HazmatLike hazmat = (HazmatLike)item;
            if (!hazmat.addsProtection(living, slot, stack)) {
                return false;
            }
            if (hazmat.fullyProtects(living, slot, stack)) {
                switch (levelRadiation) {
                    case LOW: 
                    case DEFAULT: 
                    case MEDIUM: {
                        return hazmat.getLevel() >= 1;
                    }
                    case HIGH: 
                    case VERY_HIGH: {
                        return hazmat.getLevel() > 1;
                    }
                }
                return false;
            }
            switch (levelRadiation) {
                case LOW: 
                case DEFAULT: 
                case MEDIUM: {
                    if (hazmat.getLevel() >= 1) continue block8;
                    return false;
                }
                case HIGH: 
                case VERY_HIGH: {
                    if (hazmat.getLevel() > 1) continue block8;
                    return false;
                }
            }
        }
        return true;
    }

    default public int getLevel() {
        return 1;
    }

    public boolean addsProtection(LivingEntity var1, EquipmentSlot var2, ItemStack var3);

    default public boolean fullyProtects(LivingEntity entity, EquipmentSlot slot, ItemStack stack) {
        return false;
    }
}

