/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.energy.utils;

import net.minecraft.world.level.Level;

public class SunCoef {
    private final Level world;
    private double coef;

    public SunCoef(Level world) {
        this.world = world;
        this.coef = 0.0;
    }

    public double getCoef() {
        return this.coef;
    }

    public void calculate() {
        float k = 0.0f;
        float celestialAngle = (float)(this.getWorld().getDayTime() % 24000L * 360L) / 24000.0f;
        if ((celestialAngle %= 360.0f) <= 90.0f) {
            k = celestialAngle / 90.0f;
        } else if (celestialAngle > 90.0f && celestialAngle < 180.0f) {
            k = 1.0f - (celestialAngle -= 90.0f) / 90.0f;
        } else if (celestialAngle > 180.0f && celestialAngle < 270.0f) {
            k = (celestialAngle -= 180.0f) / 90.0f;
        } else if (celestialAngle > 270.0f && celestialAngle < 360.0f) {
            k = 1.0f - (celestialAngle -= 270.0f) / 90.0f;
        }
        this.coef = k;
    }

    private Level getWorld() {
        return this.world;
    }
}

