/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.energy.networking;

import com.denfop.api.energy.EnergyTile;
import com.denfop.api.energy.EventHandler;
import com.denfop.api.energy.interfaces.EnergyNet;
import com.denfop.api.energy.interfaces.EnergySink;
import com.denfop.api.energy.networking.EnergyNetLocal;
import com.denfop.api.energy.networking.NodeStats;
import com.denfop.api.energy.networking.Path;
import com.denfop.api.energy.utils.SunCoef;
import com.denfop.config.ModConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class EnergyNetGlobal
implements EnergyNet {
    public static EnergyNet instance;
    public static long tick;
    public static com.denfop.api.energy.interfaces.EnergyTile EMPTY;
    private static Map<ResourceKey<Level>, EnergyNetLocal> worldToEnergyNetMap;
    private boolean transformer;
    private boolean hasrestrictions;
    private boolean explosing;
    private boolean ignoring;
    private boolean losing;

    public EnergyNetGlobal() {
        instance = this;
    }

    public static EnergyNetLocal getForWorld(Level world) {
        if (world == null) {
            return EnergyNetLocal.EMPTY;
        }
        ResourceKey id = world.dimension();
        if (!worldToEnergyNetMap.containsKey(id)) {
            EnergyNetLocal local = new EnergyNetLocal(world);
            worldToEnergyNetMap.put((ResourceKey<Level>)id, local);
            return local;
        }
        return worldToEnergyNetMap.getOrDefault(id, EnergyNetLocal.EMPTY);
    }

    public static EnergyNetLocal getForWorld(ResourceKey<Level> id) {
        return worldToEnergyNetMap.getOrDefault(id, EnergyNetLocal.EMPTY);
    }

    public static void onTickEnd(Level world) {
        EnergyNetLocal energyNet = EnergyNetGlobal.getForWorld(world);
        if (energyNet != EnergyNetLocal.EMPTY) {
            energyNet.onTickEnd();
        }
    }

    public static EnergyNetGlobal initialize() {
        new EventHandler();
        instance = new EnergyNetGlobal();
        instance.update();
        return (EnergyNetGlobal)instance;
    }

    public static void onWorldUnload(Level world) {
        EnergyNetLocal local = EnergyNetGlobal.getForWorld((ResourceKey<Level>)world.dimension());
        if (local != EnergyNetLocal.EMPTY) {
            local.onUnload();
            worldToEnergyNetMap.remove(world.dimension());
        }
    }

    public com.denfop.api.energy.interfaces.EnergyTile getTileEntity(Level world, int x, int y, int z) {
        EnergyNetLocal local = EnergyNetGlobal.getForWorld(world);
        if (local != EnergyNetLocal.EMPTY) {
            return local.getTileEntity(new BlockPos(x, y, z));
        }
        return EMPTY;
    }

    public com.denfop.api.energy.interfaces.EnergyTile getTileEntity(Level world, BlockPos pos) {
        EnergyNetLocal local = EnergyNetGlobal.getForWorld(world);
        if (local != EnergyNetLocal.EMPTY) {
            return local.getTileEntity(pos);
        }
        return EMPTY;
    }

    @Override
    public com.denfop.api.energy.interfaces.EnergyTile getTile(Level world, BlockPos blockPos) {
        EnergyNetLocal local = EnergyNetGlobal.getForWorld(world);
        if (local != EnergyNetLocal.EMPTY) {
            return local.getTileEntity(blockPos);
        }
        return EMPTY;
    }

    @Override
    public NodeStats getNodeStats(com.denfop.api.energy.interfaces.EnergyTile te, Level level) {
        EnergyNetLocal local = EnergyNetGlobal.getForWorld(level);
        if (local == EnergyNetLocal.EMPTY) {
            return new NodeStats(0.0, 0.0);
        }
        return local.getNodeStats(te);
    }

    @Override
    public double getPowerFromTier(int tier) {
        return tier < 14 ? 8.0 * Math.pow(4.0, tier) : 9.223372036854776E18;
    }

    @Override
    public int getTierFromPower(double power) {
        if (power <= 0.0) {
            return 0;
        }
        return Math.min(14, (int)Math.ceil(Math.log(power / 8.0) / Math.log(4.0)));
    }

    @Override
    public SunCoef getSunCoefficient(Level world) {
        return EnergyNetGlobal.getForWorld(world).getSuncoef();
    }

    @Override
    public boolean getTransformerMode() {
        return this.transformer;
    }

    @Override
    public Map<ChunkPos, List<EnergySink>> getChunkPosListMap(Level world) {
        return EnergyNetGlobal.getForWorld(world).getChunkPosListMap();
    }

    @Override
    public boolean getLosing() {
        return this.getTransformerMode() && this.losing;
    }

    @Override
    public boolean needExplosion() {
        return this.getTransformerMode() && this.explosing;
    }

    @Override
    public boolean needIgnoringTiers() {
        return this.getTransformerMode() && !this.ignoring;
    }

    @Override
    public boolean hasRestrictions() {
        return this.getTransformerMode() && this.hasrestrictions;
    }

    @Override
    public BlockEntity getBlockPosFromEnergyTile(com.denfop.api.energy.interfaces.EnergyTile tile, Level level) {
        EnergyNetLocal local = EnergyNetGlobal.getForWorld(level);
        if (local != EnergyNetLocal.EMPTY) {
            return local.getTileFromIEnergy(tile);
        }
        return null;
    }

    @Override
    public List<Path> getEnergyPaths(Level world, BlockPos pos) {
        EnergyNetLocal local = EnergyNetGlobal.getForWorld(world);
        com.denfop.api.energy.interfaces.EnergyTile energyTile = local.getChunkCoordinatesIEnergyTileMap().get(pos);
        if (energyTile != EMPTY) {
            return local.getEnergyPaths(energyTile);
        }
        return new ArrayList<Path>();
    }

    @Override
    public void update() {
        this.transformer = (Boolean)ModConfig.COMMON.newsystem.get();
        this.losing = (Boolean)ModConfig.COMMON.enableLosing.get();
        this.ignoring = (Boolean)ModConfig.COMMON.enableEasyMode.get();
        this.explosing = (Boolean)ModConfig.COMMON.enableExplosion.get();
        this.hasrestrictions = (Boolean)ModConfig.COMMON.cableEasyMode.get() == false;
    }

    static {
        tick = 0L;
        EMPTY = new EnergyTile(){};
        worldToEnergyNetMap = new HashMap<ResourceKey<Level>, EnergyNetLocal>();
    }
}

