/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.energy.forgeenergy;

import com.denfop.api.energy.forgeenergy.EnergyForge;
import com.denfop.api.energy.interfaces.Dual;
import com.denfop.api.energy.interfaces.EnergyAcceptor;
import com.denfop.api.energy.interfaces.EnergyEmitter;
import com.denfop.api.energy.networking.EnergyNetGlobal;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class EnergyForgeSinkSource
extends EnergyForge
implements Dual {
    List<Integer> energyTicks = new LinkedList<Integer>();
    private double perenergy;
    private double pastEnergy;
    private double tick;
    private double perenergy1;
    private double pastEnergy1;

    public EnergyForgeSinkSource(BlockEntity blockEntity) {
        super(blockEntity);
    }

    @Override
    public boolean acceptsEnergyFrom(EnergyEmitter var1, Direction var2) {
        IEnergyStorage energyStorage = (IEnergyStorage)this.storages.get(var2.getOpposite());
        boolean can = energyStorage != null && energyStorage.canReceive();
        return can;
    }

    @Override
    public double getPerEnergy() {
        return this.perenergy;
    }

    @Override
    public double getPastEnergy() {
        return this.pastEnergy;
    }

    @Override
    public void setPastEnergy(double pastEnergy) {
        this.pastEnergy = pastEnergy;
    }

    @Override
    public void addPerEnergy(double setEnergy) {
        this.perenergy += setEnergy;
    }

    @Override
    public void addTick(double tick) {
        this.tick = tick;
    }

    @Override
    public double getTick() {
        return this.tick;
    }

    @Override
    public boolean isSink() {
        return true;
    }

    @Override
    public double getDemandedEnergy() {
        return 0.0;
    }

    @Override
    public double getDemandedEnergy(Direction direction) {
        IEnergyStorage energyStorage = (IEnergyStorage)this.storages.get(direction);
        if (energyStorage == null) {
            return 0.0;
        }
        return (double)energyStorage.receiveEnergy(Integer.MAX_VALUE, true) / 4.0;
    }

    @Override
    public int getSinkTier(Direction direction) {
        IEnergyStorage energyStorage = (IEnergyStorage)this.storages.get(direction);
        return EnergyNetGlobal.instance.getTierFromPower((double)energyStorage.receiveEnergy(Integer.MAX_VALUE, true) / 4.0);
    }

    @Override
    public int getSinkTier() {
        return 1;
    }

    @Override
    public void receiveEnergy(Direction direction, double var2) {
        IEnergyStorage energyStorage = (IEnergyStorage)this.storages.get(direction);
        energyStorage.receiveEnergy((int)(var2 * 4.0), false);
    }

    @Override
    public void receiveEnergy(double var2) {
    }

    @Override
    public List<Integer> getEnergyTickList() {
        return this.energyTicks;
    }

    @Override
    public double getPerEnergy1() {
        return this.perenergy1;
    }

    @Override
    public double getPastEnergy1() {
        return this.pastEnergy1;
    }

    @Override
    public void setPastEnergy1(double pastEnergy) {
        this.pastEnergy1 = pastEnergy;
    }

    @Override
    public void addPerEnergy1(double setEnergy) {
        this.perenergy1 += setEnergy;
    }

    @Override
    public boolean isSource() {
        return true;
    }

    @Override
    public double canExtractEnergy(Direction direction) {
        IEnergyStorage energy = (IEnergyStorage)this.storages.get(direction);
        if (energy == null) {
            return 0.0;
        }
        return (double)energy.extractEnergy(Integer.MAX_VALUE, true) / 4.0;
    }

    @Override
    public double canExtractEnergy() {
        int amount = 0;
        for (Map.Entry storage : this.storages.entrySet()) {
            if (storage.getValue() == null || !((IEnergyStorage)storage.getValue()).canExtract()) continue;
            amount += ((IEnergyStorage)storage.getValue()).extractEnergy(Integer.MAX_VALUE, true) / 4;
        }
        return amount;
    }

    @Override
    public int getSourceTier(Direction direction) {
        IEnergyStorage energyStorage = (IEnergyStorage)this.storages.get(direction);
        return EnergyNetGlobal.instance.getTierFromPower((double)energyStorage.extractEnergy(Integer.MAX_VALUE, true) / 4.0);
    }

    @Override
    public void extractEnergy(Direction direction, double var1) {
        ((IEnergyStorage)this.storages.get(direction)).extractEnergy((int)(var1 * 4.0), false);
    }

    @Override
    public void extractEnergy(double var1) {
    }

    @Override
    public int getSourceTier() {
        return 1;
    }

    @Override
    public boolean emitsEnergyTo(EnergyAcceptor var1, Direction var2) {
        IEnergyStorage energyStorage = (IEnergyStorage)this.storages.get(var2);
        return energyStorage != null && energyStorage.canExtract();
    }
}

