/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.bee.genetics;

import com.denfop.api.bee.genetics.EnumGenetic;
import com.denfop.api.bee.genetics.GeneticTraits;
import com.denfop.api.bee.genetics.GenomeBase;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.datacomponent.GenomeBee;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.world.item.ItemStack;

public class Genome
implements GenomeBase {
    Map<EnumGenetic, GeneticTraits> geneticTraitsMap = new HashMap<EnumGenetic, GeneticTraits>();
    private ItemStack stack;

    public Genome(ItemStack stack) {
        if (!stack.has(DataComponentsInit.GENOME_BEE)) {
            stack.set(DataComponentsInit.GENOME_BEE, (Object)new GenomeBee(new HashMap<EnumGenetic, GeneticTraits>()));
        }
        GenomeBee genomeBee = (GenomeBee)stack.get(DataComponentsInit.GENOME_BEE);
        this.geneticTraitsMap = genomeBee.geneticTraitsMap();
        this.stack = stack;
    }

    public Genome(Map<EnumGenetic, GeneticTraits> geneticTraitsMap) {
        this.geneticTraitsMap = new HashMap<EnumGenetic, GeneticTraits>(geneticTraitsMap);
    }

    public Map<EnumGenetic, GeneticTraits> getGeneticTraitsMap() {
        return this.geneticTraitsMap;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Genome genome = (Genome)o;
        return this.geneticTraitsMap.values().size() == genome.geneticTraitsMap.size() && this.checkGenomes(genome);
    }

    private boolean checkGenomes(Genome genome) {
        ArrayList<GeneticTraits> geneticTraits = new ArrayList<GeneticTraits>(genome.geneticTraitsMap.values());
        ArrayList<GeneticTraits> geneticTraits1 = new ArrayList<GeneticTraits>(this.geneticTraitsMap.values());
        geneticTraits1.removeIf(geneticTraits::contains);
        return geneticTraits1.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.geneticTraitsMap);
    }

    public void addGenome(GeneticTraits geneticTraits, ItemStack stack) {
        if (!this.geneticTraitsMap.containsKey((Object)geneticTraits.getGenetic())) {
            this.geneticTraitsMap.put(geneticTraits.getGenetic(), geneticTraits);
            this.writeNBT(stack);
        }
    }

    public void addGenome(GeneticTraits geneticTraits) {
        if (!this.geneticTraitsMap.containsKey((Object)geneticTraits.getGenetic())) {
            this.geneticTraitsMap.put(geneticTraits.getGenetic(), geneticTraits);
            this.writeNBT(this.stack);
        }
    }

    public void removeGenome(GeneticTraits geneticTraits, ItemStack stack) {
        if (this.geneticTraitsMap.containsKey((Object)geneticTraits.getGenetic())) {
            this.geneticTraitsMap.remove((Object)geneticTraits.getGenetic(), (Object)geneticTraits);
            this.writeNBT(stack);
        }
    }

    public GeneticTraits removeGenome(EnumGenetic genetic, ItemStack stack) {
        if (this.geneticTraitsMap.containsKey((Object)genetic)) {
            GeneticTraits value = this.geneticTraitsMap.remove((Object)genetic);
            this.writeNBT(stack);
            return value;
        }
        return null;
    }

    @Override
    public boolean hasGenome(EnumGenetic genome) {
        return this.geneticTraitsMap.containsKey((Object)genome);
    }

    @Override
    public <T> T getLevelGenome(EnumGenetic genome, Class<T> tClass) {
        return this.geneticTraitsMap.get((Object)genome).getValue(tClass);
    }

    @Override
    public GeneticTraits getGenome(EnumGenetic genome) {
        return this.geneticTraitsMap.get((Object)genome);
    }

    @Override
    public Genome copy() {
        Genome genome = new Genome(this.geneticTraitsMap);
        genome.stack = this.stack.copy();
        return genome;
    }

    @Override
    public void writeNBT(ItemStack stack) {
        HashMap<EnumGenetic, GeneticTraits> geneticTraitsMap = new HashMap<EnumGenetic, GeneticTraits>(this.geneticTraitsMap);
        stack.set(DataComponentsInit.GENOME_BEE, (Object)new GenomeBee(geneticTraitsMap));
    }
}

