/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.bee;

import com.denfop.api.bee.Bee;
import com.denfop.api.bee.BeeBase;
import com.denfop.blockentity.bee.BlockEntityApiary;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class BeeNetwork {
    public static BeeNetwork instance;
    Map<Integer, Bee> beeMap = new HashMap<Integer, Bee>();
    Map<ResourceKey<Level>, Map<ChunkPos, List<BlockEntityApiary>>> mapWorldApiary = new HashMap<ResourceKey<Level>, Map<ChunkPos, List<BlockEntityApiary>>>();

    public static void init() {
        if (instance == null) {
            instance = new BeeNetwork();
        }
    }

    public List<BlockEntityApiary> getApiaryFromChunk(Level world, ChunkPos chunkPos) {
        Map map = this.mapWorldApiary.computeIfAbsent((ResourceKey<Level>)world.dimension(), k -> new HashMap());
        return map.computeIfAbsent(chunkPos, k -> new ArrayList());
    }

    public void addNewApiaryToWorld(BlockEntityApiary apiary) {
        Map<ChunkPos, List<BlockEntityApiary>> map = this.mapWorldApiary.get(apiary.getWorld().dimension());
        if (map == null) {
            map = new HashMap<ChunkPos, List<BlockEntityApiary>>();
            ChunkPos chunkPos = new ChunkPos(apiary.getPos());
            ArrayList<BlockEntityApiary> list = new ArrayList<BlockEntityApiary>();
            list.add(apiary);
            map.put(chunkPos, list);
            this.mapWorldApiary.put((ResourceKey<Level>)apiary.getWorld().dimension(), map);
        } else {
            ChunkPos chunkPos = new ChunkPos(apiary.getPos());
            List<BlockEntityApiary> list = map.get(chunkPos);
            if (list == null) {
                list = new ArrayList<BlockEntityApiary>();
                list.add(apiary);
                map.put(chunkPos, list);
            } else {
                list.add(apiary);
            }
        }
    }

    public void removeApiaryFromWorld(BlockEntityApiary apiary) {
        ChunkPos chunkPos;
        List<BlockEntityApiary> list;
        Map<ChunkPos, List<BlockEntityApiary>> map = this.mapWorldApiary.get(apiary.getWorld().dimension());
        if (map != null && (list = map.get(chunkPos = new ChunkPos(apiary.getPos()))) != null) {
            list.remove(apiary);
        }
    }

    public Bee getBee(int id) {
        return this.beeMap.get(id);
    }

    public Map<Integer, Bee> getBeeMap() {
        return this.beeMap;
    }

    public void addBee(BeeBase beeBase) {
        this.beeMap.putIfAbsent(beeBase.getId(), beeBase);
    }
}

