/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.util;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.FormattedCharSink;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

@Deprecated(forRemoval=true)
public class ItemColor {
    public static TextColor findFirstColorCode(Component textComponent) {
        String rawTitle = textComponent.getString();
        for (int i = 0; i < rawTitle.length(); i += 2) {
            if (rawTitle.charAt(i) == '\u00a7') {
                try {
                    ChatFormatting format = ChatFormatting.getByCode((char)rawTitle.charAt(i + 1));
                    if (format == null || !format.isColor()) continue;
                    return TextColor.fromLegacyFormat((ChatFormatting)format);
                }
                catch (StringIndexOutOfBoundsException e) {
                    return null;
                }
            }
            return null;
        }
        return null;
    }

    public static TextColor getColorForItem(ItemStack item, TextColor defaultColor) {
        TextColor formattingColor;
        TextColor result = null;
        result = item.getDisplayName().getStyle().getColor();
        if (item.getItem() != null && item.getItem().getName(item) != null && item.getItem().getName(item).getStyle() != null && item.getItem().getName(item).getStyle().getColor() != null) {
            result = item.getItem().getName(item).getStyle().getColor();
        }
        if (!item.getHoverName().getStyle().isEmpty() && item.getHoverName().getStyle().getColor() != null) {
            result = item.getHoverName().getStyle().getColor();
        }
        if ((formattingColor = ItemColor.findFirstColorCode(item.getHoverName())) != null) {
            result = formattingColor;
        }
        ColorCollector colorCollector = new ColorCollector();
        item.getHoverName().getVisualOrderText().accept((FormattedCharSink)colorCollector);
        if (colorCollector.getColor() != null) {
            result = colorCollector.getColor();
        }
        if (result == null || result.equals((Object)item.getDisplayName().getStyle().getColor())) {
            Minecraft mc = Minecraft.getInstance();
            List lines = null;
            try {
                lines = item.getTooltipLines(Item.TooltipContext.EMPTY, (Player)mc.player, (TooltipFlag)TooltipFlag.Default.ADVANCED);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (lines != null && !lines.isEmpty()) {
                result = ((Component)lines.get(0)).getStyle().getColor();
            }
        }
        if (result == null) {
            result = defaultColor;
        }
        return result;
    }

    private static class ColorCollector
    implements FormattedCharSink {
        private TextColor color = null;

        private ColorCollector() {
        }

        public boolean accept(int index, Style style, int codePoint) {
            if (style.getColor() != null) {
                this.color = style.getColor();
                return false;
            }
            return true;
        }

        public TextColor getColor() {
            return this.color;
        }
    }
}

