/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.shapes.pane;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.SlopeType;

public final class CornerStripShapes {
    public static ShapeProvider generate(ImmutableList<BlockState> states) {
        VoxelShape[] shapes = ShapeUtils.makeHorizontalRotationsWithFlag(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)1.0), Block.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), Direction.NORTH);
        VoxelShape[] vertShapes = ShapeUtils.makeHorizontalRotations(Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)1.0), Direction.NORTH);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            SlopeType type = (SlopeType)((Object)state.getValue(PropertyHolder.SLOPE_TYPE));
            if (type == SlopeType.HORIZONTAL) {
                builder.put((Object)state, (Object)vertShapes[dir.get2DDataValue()]);
                continue;
            }
            int offset = type == SlopeType.TOP ? 4 : 0;
            builder.put((Object)state, (Object)shapes[dir.get2DDataValue() + offset]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    private CornerStripShapes() {
    }
}

