/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.conpreds.door;

import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.predicate.contex.ConnectionPredicate;
import xfacthd.framedblocks.api.util.Utils;

public final class DoorConnectionPredicate
implements ConnectionPredicate {
    public static final DoorConnectionPredicate INSTANCE = new DoorConnectionPredicate();

    private DoorConnectionPredicate() {
    }

    @Override
    public boolean canConnectFullEdge(BlockState state, Direction side, @Nullable Direction edge) {
        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        boolean open = (Boolean)state.getValue((Property)BlockStateProperties.OPEN);
        Direction fullFace = facing.getOpposite();
        if (open) {
            DoorHingeSide hinge = (DoorHingeSide)state.getValue((Property)BlockStateProperties.DOOR_HINGE);
            Direction direction = fullFace = hinge == DoorHingeSide.LEFT ? facing.getCounterClockWise() : facing.getClockWise();
        }
        if (side == fullFace) {
            return true;
        }
        if (side.getAxis() != fullFace.getAxis()) {
            return edge == fullFace;
        }
        return false;
    }

    @Override
    public boolean canConnectDetailed(BlockState state, Direction side, Direction edge) {
        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        boolean open = (Boolean)state.getValue((Property)BlockStateProperties.OPEN);
        Direction fullFace = facing;
        if (open) {
            DoorHingeSide hinge = (DoorHingeSide)state.getValue((Property)BlockStateProperties.DOOR_HINGE);
            Direction direction = fullFace = hinge == DoorHingeSide.LEFT ? facing.getClockWise() : facing.getCounterClockWise();
        }
        if (side == fullFace) {
            return edge.getAxis() != fullFace.getAxis();
        }
        if (side.getAxis() == fullFace.getClockWise().getAxis()) {
            return Utils.isY(edge);
        }
        return false;
    }
}

