/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.compat.searchables;

import com.blamejared.searchables.api.SearchableComponent;
import com.blamejared.searchables.api.SearchableType;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLEnvironment;
import xfacthd.framedblocks.FramedBlocks;
import xfacthd.framedblocks.common.menu.FramingSawMenu;

public final class SearchablesCompat {
    private static boolean loaded = false;

    public static void init() {
        if (ModList.get().isLoaded("searchables")) {
            try {
                if (FMLEnvironment.dist.isClient()) {
                    GuardedAccess.init();
                    loaded = true;
                }
            }
            catch (Throwable t) {
                FramedBlocks.LOGGER.warn("An error occured while initializing Searchables integration!", t);
            }
        }
    }

    public static boolean isLoaded() {
        return loaded;
    }

    public static Consumer<String> createSearchHandler(ValueSupplier valueSupplier, ResultConsumer resultConsumer, Consumer<String> defaultHandler) {
        if (loaded) {
            return GuardedAccess.createSearchHandler(valueSupplier, resultConsumer);
        }
        return defaultHandler;
    }

    private SearchablesCompat() {
    }

    private static final class GuardedAccess {
        private static final SearchableType<FramingSawMenu.FramedRecipeHolder> SEARCH_TYPE = new SearchableType.Builder().defaultComponent(SearchableComponent.create((String)"result", holder -> Optional.of(holder.getRecipe().getResult().getItem().getDescription().getString()))).build();

        private GuardedAccess() {
        }

        public static void init() {
        }

        public static Consumer<String> createSearchHandler(ValueSupplier valueSupplier, ResultConsumer resultConsumer) {
            return value -> resultConsumer.accept(SEARCH_TYPE.filterEntries((List)valueSupplier.get(), value));
        }
    }

    @FunctionalInterface
    public static interface ValueSupplier
    extends Supplier<List<FramingSawMenu.FramedRecipeHolder>> {
    }

    @FunctionalInterface
    public static interface ResultConsumer
    extends Consumer<List<FramingSawMenu.FramedRecipeHolder>> {
    }
}

