/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.pillar;

import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Vector3f;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.MultiQuadModifier;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.pillar.FramedChainBlock;

public class FramedChainGeometry
extends Geometry {
    private static final Vector3f ROT_ORIGIN = new Vector3f(0.5f, 0.5f, 0.5f);
    private static final CutterFactory CUTTER_SIDE_UD = (dir, len) -> Modifiers.cutSideUpDown(dir == Direction.DOWN, len);
    private final Direction.Axis axis;

    public FramedChainGeometry(GeometryFactory.Context ctx) {
        this.axis = (Direction.Axis)ctx.state().getValue((Property)FramedChainBlock.AXIS);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction quadDir = quad.getDirection();
        Direction.Axis quadPerpAxis = Utils.nextAxisNotEqualTo(quadDir.getAxis(), this.axis);
        if (this.axis == Direction.Axis.Y) {
            if (!Utils.isY(quadDir)) {
                this.createChainEdgeParts(quadMap, quad, quadDir, quadPerpAxis, Utils::isX, CUTTER_SIDE_UD, Modifiers::cutSideLeftRight);
                this.createChainCenterParts(quadMap, quad, CUTTER_SIDE_UD, Modifiers::cutSideLeftRight);
            }
        } else if (Utils.isY(quadDir)) {
            Direction.Axis perpAxis = this.axis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
            this.createChainEdgeParts(quadMap, quad, quadDir, quadPerpAxis, dir -> this.axis == Direction.Axis.Z, Modifiers::cutTopBottom, Modifiers::cutTopBottom);
            this.createChainCenterParts(quadMap, quad, Modifiers::cutTopBottom, len -> Modifiers.cutTopBottom(perpAxis, len));
        } else if (quadDir.getAxis() != this.axis) {
            this.createChainEdgeParts(quadMap, quad, quadDir, quadPerpAxis, dir -> this.axis == Direction.Axis.X, Modifiers::cutSideLeftRight, CUTTER_SIDE_UD);
            this.createChainCenterParts(quadMap, quad, Modifiers::cutSideLeftRight, Modifiers::cutSideUpDown);
        }
    }

    private void createChainEdgeParts(QuadMap quadMap, BakedQuad quad, Direction quadDir, Direction.Axis quadPerpAxis, Predicate<Direction> fourSectionPred, CutterFactory vertCutterFactory, CutterFactory horCutterFactory) {
        Direction dirUp = Direction.fromAxisAndDirection((Direction.Axis)this.axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        Direction dirDown = Direction.fromAxisAndDirection((Direction.Axis)this.axis, (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE);
        Direction dirNeg = Direction.fromAxisAndDirection((Direction.Axis)quadPerpAxis, (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE);
        Direction dirPos = Direction.fromAxisAndDirection((Direction.Axis)quadPerpAxis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        ArrayList<MultiQuadModifier> modifiers = new ArrayList<MultiQuadModifier>();
        MultiQuadModifier baseMod = new MultiQuadModifier(QuadModifier.of(quad).apply(horCutterFactory.create(dirNeg, 0.625f)).apply(horCutterFactory.create(dirPos, 0.4375f)).apply(Modifiers.offset(dirPos, 0.03125f)), QuadModifier.of(quad).apply(horCutterFactory.create(dirNeg, 0.4375f)).apply(horCutterFactory.create(dirPos, 0.625f)).apply(Modifiers.offset(dirNeg, 0.03125f)));
        if (fourSectionPred.test(quadDir)) {
            modifiers.add(baseMod.derive().apply(vertCutterFactory.create(dirUp, 0.125f)));
            modifiers.add(baseMod.derive().apply(vertCutterFactory.create(dirUp, 0.4375f)).apply(vertCutterFactory.create(dirDown, 0.8125f)));
            modifiers.add(baseMod.derive().apply(vertCutterFactory.create(dirDown, 0.4375f)).apply(vertCutterFactory.create(dirUp, 0.8125f)));
            modifiers.add(baseMod.derive().apply(vertCutterFactory.create(dirDown, 0.125f)));
        } else {
            modifiers.add(baseMod.derive().apply(vertCutterFactory.create(dirDown, 0.25f)).apply(vertCutterFactory.create(dirUp, 0.9375f)));
            modifiers.add(baseMod.derive().apply(vertCutterFactory.create(dirDown, 0.625f)).apply(vertCutterFactory.create(dirUp, 0.625f)));
            modifiers.add(baseMod.derive().apply(vertCutterFactory.create(dirUp, 0.25f)).apply(vertCutterFactory.create(dirDown, 0.9375f)));
        }
        for (MultiQuadModifier mod : modifiers) {
            mod.apply(Modifiers.setPosition(0.5f)).apply(Modifiers.rotate(this.axis, ROT_ORIGIN, 45.0f, false)).export(quadMap.get(null));
        }
    }

    private void createChainCenterParts(QuadMap quadMap, BakedQuad quad, CutterFactory vertCutterFactory, BidirectionalCutterFactory horCutterFactory) {
        Direction dirUp = Direction.fromAxisAndDirection((Direction.Axis)this.axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        Direction dirDown = Direction.fromAxisAndDirection((Direction.Axis)this.axis, (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE);
        for (int i = 0; i < 6; ++i) {
            float height = switch (i) {
                case 0 -> 2.0f;
                case 5 -> 15.0f;
                default -> 3.0f * (float)i + 1.0f;
            };
            QuadModifier.of(quad).apply(horCutterFactory.create(0.53125f)).apply(vertCutterFactory.create(dirDown, height / 16.0f)).apply(vertCutterFactory.create(dirUp, (16.0f - height + 1.0f) / 16.0f)).apply(Modifiers.setPosition(0.5f)).apply(Modifiers.rotate(this.axis, ROT_ORIGIN, 45.0f, false)).export(quadMap.get(null));
        }
    }

    @Override
    public boolean useSolidNoCamoModel() {
        return true;
    }

    @FunctionalInterface
    private static interface CutterFactory {
        public QuadModifier.Modifier create(Direction var1, float var2);
    }

    @FunctionalInterface
    private static interface BidirectionalCutterFactory {
        public QuadModifier.Modifier create(float var1);
    }
}

